// Copyright (c) Tailscale Inc & AUTHORS
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale/cmd/viewer; DO NOT EDIT.

package persist

import (
	jsonv1 "encoding/json"
	"errors"

	jsonv2 "github.com/go-json-experiment/json"
	"github.com/go-json-experiment/json/jsontext"
	"tailscale.com/tailcfg"
	"tailscale.com/types/key"
	"tailscale.com/types/structs"
	"tailscale.com/types/views"
)

//go:generate go run tailscale.com/cmd/cloner  -clonefunc=false -type=Persist

// View returns a read-only view of Persist.
func (p *Persist) View() PersistView {
	return PersistView{ж: p}
}

// PersistView provides a read-only view over Persist.
//
// Its methods should only be called if `Valid()` returns true.
type PersistView struct {
	// ж is the underlying mutable value, named with a hard-to-type
	// character that looks pointy like a pointer.
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *Persist
}

// Valid reports whether v's underlying value is non-nil.
func (v PersistView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v PersistView) AsStruct() *Persist {
	if v.ж == nil {
		return nil
	}
	return v.ж.Clone()
}

// MarshalJSON implements [jsonv1.Marshaler].
func (v PersistView) MarshalJSON() ([]byte, error) {
	return jsonv1.Marshal(v.ж)
}

// MarshalJSONTo implements [jsonv2.MarshalerTo].
func (v PersistView) MarshalJSONTo(enc *jsontext.Encoder) error {
	return jsonv2.MarshalEncode(enc, v.ж)
}

// UnmarshalJSON implements [jsonv1.Unmarshaler].
func (v *PersistView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x Persist
	if err := jsonv1.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

// UnmarshalJSONFrom implements [jsonv2.UnmarshalerFrom].
func (v *PersistView) UnmarshalJSONFrom(dec *jsontext.Decoder) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	var x Persist
	if err := jsonv2.UnmarshalDecode(dec, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v PersistView) PrivateNodeKey() key.NodePrivate { return v.ж.PrivateNodeKey }

// needed to request key rotation
func (v PersistView) OldPrivateNodeKey() key.NodePrivate { return v.ж.OldPrivateNodeKey }
func (v PersistView) UserProfile() tailcfg.UserProfile   { return v.ж.UserProfile }
func (v PersistView) NetworkLockKey() key.NLPrivate      { return v.ж.NetworkLockKey }
func (v PersistView) NodeID() tailcfg.StableNodeID       { return v.ж.NodeID }

// DisallowedTKAStateIDs stores the tka.State.StateID values which
// this node will not operate network lock on. This is used to
// prevent bootstrapping TKA onto a key authority which was forcibly
// disabled.
func (v PersistView) DisallowedTKAStateIDs() views.Slice[string] {
	return views.SliceOf(v.ж.DisallowedTKAStateIDs)
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _PersistViewNeedsRegeneration = Persist(struct {
	_                     structs.Incomparable
	PrivateNodeKey        key.NodePrivate
	OldPrivateNodeKey     key.NodePrivate
	UserProfile           tailcfg.UserProfile
	NetworkLockKey        key.NLPrivate
	NodeID                tailcfg.StableNodeID
	DisallowedTKAStateIDs []string
}{})
