// mailboxmenu.hh for bbmail - an tool for display the mail in X11.
//
//  Copyright (c) 1998-2000 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#ifndef __MENU_HH
#define __MENU_HH

#include "Basemenu.hh"
#include "bbacpi.hh"

class Basemenu;
class ToolWindow;

class Menu : public Basemenu
{
public:
  Menu(ToolWindow *);
  ~Menu(void);
  void Move(int ,int, bool);
  void Reconfigure(void);
  void ClearMenu(void);
  void Clean(void);
  void Update(void);
  virtual void show(void);
  bool dcelcius (void) {return celcius; }
  bool dmove (void) {return movemenu; }
  
protected:
  virtual void itemSelected(int, int);
  
private:
  ToolWindow *bbtool;
  bool wait_for_update;
  char temperature_menuitem[20];
  bool celcius;
  bool movemenu;
};

#endif /* __MENU_HH */
