// resource.hh for bbacpi - an tool to display battery level in X11.
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbacpi.hh"
#include "Baseresource.hh"

class BaseResource;

struct FRAME {
  int width;
  int height;
  BTexture texture;
  int bevelWidth;
  XFontStruct *font;
};

struct POSITION {
  int x;
  int y;
  int mask;
};

struct LABEL {
  int width;
  int width0, width1, width2, width3;
  int height;
  BTexture texture;
  bool transparent;
  XFontStruct *font;
  BColor separator_textColor;
  BColor battery_textColor;
  BColor time_textColor;
  BColor time_short_textColor;
  BColor temperature_textColor;
  BColor adapter_textColor;
};

struct GAUGE {
  int width;
  BTexture active_texture;
  BTexture inactive_texture;
  BTexture background_texture;
  int left_step_width;
  int right_step_width;
  double ratio;
  int number_of_bars;
  bool background;
  float max_load;
  bool tickmarks;
  bool use_simple_color;
  bool levels_defined;
  float *level;
  BTexture *segment_texture;
};

struct MENU
{
  BTexture texture;
  BColor textColor;
  BColor highlightColor;
  BColor hitextColor;
  int justify;
  XFontStruct *font;
  int bullet_style;
  int bullet_pos;
};

struct SHOW {
  bool gauge_battery;
  bool gauge_temperature;
  bool label_battery;
  bool label_time;
  bool label_temperature;
  bool label_adapter;
  bool gfx_adapter;
  bool xmessage;
  bool label;
  bool loadbar;
  bool vertical;
  int battery_number;
  bool label_temperature_celcius;
  bool gauge_battery_special_charging;
};

struct REVERSE {
  bool gauge_battery;
  bool gauge_temperature;
};

struct ORDER {
  int gauge_battery;
  int gauge_temperature;
  int label_battery;
  int label_time;
  int label_temperature;
  int label_adapter;
};  

struct REPORT {
  int check_delay;
  int xmessage_delay;
  int minlim;
};

class Resource : public BaseResource
{
  
public:
  Resource::Resource(ToolWindow *);
  Resource::~Resource(void);
  
  struct FRAME frame;
  struct LABEL label;
  struct POSITION position;
  struct GAUGE gauge;
  struct MENU menu;
  struct SHOW show;
  struct REVERSE reverse;
  struct ORDER order;
  struct REPORT report;

  const int getJustification(void) const { return LeftJustify; }
  int getMenuJustification(void) { return menu.justify;	}
  XFontStruct *getTitleFont(void) { return menu.font; }
  XFontStruct *getMenuFont(void) { return menu.font; }
  int getBulletStyle(void) { return menu.bullet_style; }
  int getBulletPosition(void) {	return menu.bullet_pos; }
  unsigned int getBevelWidth(void) { return frame.bevelWidth; }
  BColor *getBorderColor(void) { return frame.texture.getColor(); }
  unsigned int getBorderWidth(void) { return 0; }

  enum { AlignDontCare = 1, AlignTop, AlignBottom };
  enum { Right = 1, Left };
  enum { Empty = 0, Round, Square, Triangle, Diamond };
  enum { LeftJustify = 1, RightJustify, CenterJustify };

protected:
  virtual void  LoadBBToolResource(void);
  
private:
  void Frame(void);
  void SizeAndPosition(void);
  void CheckSettings(void);
  void Label(void);
  void Show(void);
  void Reverse(void);
  void Order(void);
  void LoadBar(void);
  bool showLabel(char *,char *,bool);
  bool showGauge(char *,char *,bool);
  void Menu(void);
  void Clean(void);
};
#endif /* __RESOURCE_HH */
