/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ECOPROCDS_H
#define ECOPROCDS_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"

#ifdef ECOPROCDS_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR			1

#define DRIVER_BITMAP_FILE				PIX_PATH"/ecoprocds.bmp"
#define DRIVER_CONFIG_FILE				"ecopro_usb.conf"
#define DRIVER_UPS_FAMILY				"ECO Pro 400-1200 CDS"
#define DRIVER_UPS_PREFIX				"ECO Pro CDS"
#define DRIVER_UPS_SUFFIX				""

#define DRIVER_UPS_SERIALNUMBER			"ECOPRO00"

#define UPS_MAX_MODELS					0

// Licznik pozycji ustawie z drivera
#define INT_MAX_SETUPITEMS				0

// Bity stanow pracy
#define USB_AND_POWERFAIL				0x10	// as refers to CTS in FTDI D2xx prog reference
#define USB_FLAG_POWERFAIL				0x10
#define USB_AND_LOWBATTERY				0x80	// as refers to DCD in FTDI D2xx prog reference
#define USB_FLAG_LOWBATTERY				0x80

/*
 * Indeksy z tablicy ustawien UPS-a
 */
#define SETUP_TABLE_ITEMS				0x01
// Indeksy tablicy ustawien
#define IDX_SHUTDOWN					0x00

/*
 * Indeksy z tablicy parametrow UPS-a
 */
#define PARAMS_TABLE_ITEMS				0x01
// Indeksy tablicy parametrow
#define IDXP_STATEFLAG					0x00

/*
 * Structures
 */
typedef struct _sdrv_config_
{
	/* struct size used for versioning */
	unsigned long	ulSize;
	/* serial port configured by user */
	char			szSerialNumber[MAX_PATHBUFF];
	/* setup table */
	unsigned int	uiSetupTable[SETUP_TABLE_ITEMS];
	/* parameters table */
	unsigned int	uiParamsTable[PARAMS_TABLE_ITEMS];
} sdrv_config, *lpsdrv_config;

/* 
 * Enumerators
 */
typedef enum _eups_structs_
{
	EU_STATE		= 1	// EU_INFORMATIONS
} eups_structs;

/* 
 * Function prototypes - internal
 */
int		EcoProCds_DoInit(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoSetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize, int *lpiBuffErrPos);
int		EcoProCds_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		EcoProCds_ReadConfig();
int		EcoProCds_GetAllUpsParams(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_GetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		EcoProCds_SetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);

#else/*ECOPROCDS_DRIVER_BUILD*/

int		ecoprocds_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*ECOPROCDS_DRIVER_BUILD*/

#endif/*ECOPROCDS_H*/
