/**********************************************************************
 *
 *	File		: ups_defs.h
 *	Comment		: UPS P7 & P9 series definition file
 *	Created	on	: 12/08/2005
 *	Author		: Copyright 2005 by Tomasz Fiszer, EVER Sp. z o.o.
 *
 **********************************************************************/

#ifndef UPS_DEFS_P7P9_H_
#define UPS_DEFS_P7P9_H_

/* Commands */
#define UPS_INFORMATION			0x01
#define UPS_CONFIGURATION		0x02
#define UPS_STATISTICS			0x03

/* Ups information items */
enum UI_ITEM {
	UII_TYPE = 0,		// UPS family id
	UII_PWR_APPARENT,	// apparent power for UPS type recognition
	UII_PWR_EFFECTIVE,	// effective power for UPS type recognition
	UII_FIRMMWARE,
	UII_STATES,
	UII_VOLT_INP,
	UII_VOLT_OUT,
	UII_CUR_INP,
	UII_CUR_OUT,
	UII_FREQ_INP,
	UII_FREQ_OUT,
	UII_PWR_EFFECTIVE_INP,
	UII_PWR_EFFECTIVE_OUT,
	UII_PWR_APPARENT_INP,
	UII_PWR_APPARENT_OUT,
	UII_PWR_IN_COEFF,
	UII_PWR_OUT_COEFF,
	UII_PWR_OUT_PERC,
	UII_CAPACITY_ACCU,
	UII_TEMP_INTERNAL1,
	UII_TEMP_INTERNAL2,
	UII_TIME_AUTONOMY,
	UII_VOLT_ACCU,
	UII_CUR_ACCU,
	UII__LASTITEM
};

/* Ups configuration items */
enum UC_ITEM {
	UCI_CONTROL = 0,
	UCI_FREQ_OUT,
	UCI_VOLT_OUT,
	UCI_PF_UPPER_TRANSFER_TRESHOLDS,	// power fail upper transfer tresh.
	UCI_PF_LOWER_TRANSFER_TRESHOLDS,	// power fail lower transfer tresh.
	UCI_AVR_TRIM_TRANSFER_TRESHOLDS,
	UCI_AVR_BOOST_TRANSFER_TRESHOLDS,
	UCI_TIMER_STARTUP,			// timer in sec. for standby to online transfer
	UCI_TIMER_STANDBY,			// timer in sec. for powerfail to online transfer
	UCI_CAPACITY_FOR_STARTUP,	// capacity treshold at which ups will switch to online mode
	UCI_MODULE_NO,				// connected modules number
	UCI__LASTITEM
};

/* Ups statistic items */
enum US_ITEM {
	USI_CNT_POWER_LOST = 0,
	USI_CNT_UNDERVOLTAGE,
	USI_CNT_OVERVOLTAGE,
	USI_CNT_OVERLOADS,
	USI_CNT_SHORTS,
	USI_CNT_DISCHARGES,	// capacity treshold at which ups will switch to online mode
	USI_CNT_AVR_TRIM,
	USI_CNT_AVR_BOOST,
	USI_CNT_OVERHEAT,
	USI_TIME_OVERLOADED,
	USI_TIME_POWERON,
	USI_TIME_POWERFAIL,
	USI_CNT_SYNC_LOST,
	USI__LASTITEM
};

/* Ups factory control items */
enum UCF_ITEM {
	UCFI_CNT_CHARGE_H = 0,
	UCFI_CNT_CHARGE_L,
	UCFI_TIME_MIN_POWERFAIL,
	UCFI_TIME_SEC_OVERLOAD,
	UCFI_TIME_MIN_POWERON,
	UCFI__LASTITEM
};

/* counters (use last items as a counter) */
#define UPS_INFORMATION_COUNT	(UII__LASTITEM)
#define UPS_CONFIGURATION_COUNT	(UCI__LASTITEM)
#define UPS_STATISTICS_COUNT	(USI__LASTITEM)
#define UPS_FACTORYCONTROL_COUNT (UCFI__LASTITEM)

/* Ups configuration Control item flags */
enum UCCI_FLAG {
	UCCI_LCD_LOCK					= 0x01,
	UCCI_BYPASS_FORCE				= 0x02,
	UCCI_BUZZER_ENABLED				= 0x04,
	UCCI_FORCE_ONL_STBY_TO_ONLINE	= 0x08,	// switch from online-standby to online
	UCCI_FORCE_STANDBY				= 0x10
};

#endif//UPS_DEFS_P7P9_H_
