/***************************************************************************
                          spellbook.c  -  Functions for our spells
                             -------------------
    begin                : Wed Jul 25 2001
    copyright            : (C) 2001 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "wand.h"



GtkWidget *make_combo(GtkWidget *fixer,
                      GtkWidget *box,
                      int obj_len,
                      int obj_hi,
                      short int pos_len,
                      short int pos_hi
                     )
{
  /* our combo box */
  box = gtk_combo_new();
  /* show the widget */
  gtk_widget_show(box);
  /* place widget in fixed position */
  gtk_fixed_put(GTK_FIXED(fixer), box, pos_len, pos_hi);
  /* set size of widget */
  gtk_widget_set_usize(box, obj_len, obj_hi);
  /* item must be in list, and item cannot be blank */
  gtk_combo_set_value_in_list(GTK_COMBO(box), TRUE, FALSE);

  return box;
}

GtkWidget *make_label(GtkWidget *fixer,
                      GtkWidget *lbl,
                      char *text,
                      short int pos_len,
                      short int pos_hi
                     )
{
  /* create a label with 'text' on it */
  lbl = gtk_label_new(text);
  gtk_widget_show(lbl);
  /* position label */
  gtk_fixed_put(GTK_FIXED(fixer), lbl, pos_len, pos_hi);
  return lbl;
}

GtkWidget *make_button(GtkWidget *fixed,
                       GtkWidget *button,
                       const gchar *text,
                       int obj_len,
                       int obj_hi,
                       short int pos_len,
                       short int pos_hi,
                       int textorcheck
                      )
{
  if(textorcheck == 1) 
  { 
    button = gtk_button_new_with_label(text);
    /* set size of widget */
    gtk_widget_set_usize(button, obj_len, obj_hi);

  }
  else { button = gtk_check_button_new_with_label(text); }
  gtk_widget_show(button);
  /* place widget in fixed position */
  gtk_fixed_put(GTK_FIXED(fixed), button, pos_len, pos_hi);
  return button;
}

GtkWidget *make_text(GtkWidget *fixer,
                     GtkWidget *text,
                     int obj_len,
                     int obj_hi,
                     short int pos_len,
                     short int pos_hi
                    )
{


  text = gtk_entry_new();
  gtk_widget_set_usize(text, obj_len, obj_hi);
  gtk_fixed_put(GTK_FIXED(fixer), text, pos_len, pos_hi);
  gtk_entry_set_editable(GTK_ENTRY(text), TRUE);
  gtk_widget_show(text);

  return text;

}

GtkWidget *make_tex(GtkWidget *fixer,
                    GtkWidget *text,
                    int obj_len,
                    int obj_hi,
                    short int pos_len,
                    short int pos_hi
                   )
{
  text = gtk_text_new(NULL, NULL);
  gtk_widget_set_usize(text, obj_len, obj_hi);
  gtk_fixed_put(GTK_FIXED(fixer), text, pos_len, pos_hi);
  gtk_text_set_editable(GTK_TEXT(text), TRUE);
 /*  gtk_text_set_line_wrap(GTK_TEXT(text), TRUE);   */
  gtk_widget_show(text);

  return text;

}














































