/* $Id: extension-search.h 222758 2020-06-01 00:22:58Z twu $ */
#ifndef EXTENSION_SEARCH_INCLUDED
#define EXTENSION_SEARCH_INCLUDED

#include "types.h"
#include "genomicpos.h"
#include "mode.h"
#include "list.h"

#include "iit-read-univ.h"
#include "genome.h"
#include "compress.h"

#include "stage1hr.h"
#include "indexdb.h"
#include "intlistpool.h"

#ifdef LARGE_GENOMES
#include "uint8listpool.h"
#else
#include "uintlistpool.h"
#endif

#include "listpool.h"
#include "univdiagpool.h"
#include "hitlistpool.h"


#define T Elt_T
typedef struct T *T;
struct T {
  int qstart;
  int qend;

  int nmatches;

  Univcoord_T *all_univdiagonals;
  int n_all_univdiagonals;

  Univcoord_T *univdiagonals;
  int nunivdiagonals;

  int lowi;
  int highi;
};


extern void
Extension_search_setup (Mode_T mode, Univ_IIT_T chromosome_iit_in,
			Univcoord_T genomelength_in, int circular_typeint_in, bool *circularp_in,
			Genome_T genomebits_in, Genome_T genomebits_alt_in, Indexdb_T indexdb_in, Indexdb_T indexdb2_in,
			int min_intronlength_in, int max_end_insertions_in, int max_end_deletions_in,
			int index1part_in, int index1interval_in, int local1part_in);

extern void
Elt_gc (List_T *set);

extern void
Extension_search (int *found_score_overall, int *found_score_within_trims,
		  List_T *sense_hits_gplus, List_T *sense_hits_gminus,
		  List_T *antisense_hits_gplus, List_T *antisense_hits_gminus,
		  Stage1_T stage1, char *queryuc_ptr, char *queryrc, int querylength,
		  int *mismatch_positions_alloc, Compress_T query_compress_fwd, Compress_T query_compress_rev, 

		  Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool, Listpool_T listpool,
		  Univdiagpool_T univdiagpool, Hitlistpool_T hitlistpool,
		  int nmismatches_allowed, int max_insertionlen, int max_deletionlen, Chrpos_T overall_end_distance,
		  int genestrand, bool paired_end_p, bool first_read_p, int level);

#undef T
#endif


