﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appsync/model/DisassociateSourceGraphqlApiResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::AppSync::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DisassociateSourceGraphqlApiResult::DisassociateSourceGraphqlApiResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

DisassociateSourceGraphqlApiResult& DisassociateSourceGraphqlApiResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("sourceApiAssociationStatus")) {
    m_sourceApiAssociationStatus =
        SourceApiAssociationStatusMapper::GetSourceApiAssociationStatusForName(jsonValue.GetString("sourceApiAssociationStatus"));
    m_sourceApiAssociationStatusHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
