/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Logarithmic
extends AbstractContinousDistribution {
    protected double my_p;
    private double t;
    private double h;
    private double a_prev = -1.0;
    protected static Logarithmic shared = new Logarithmic(0.5, AbstractDistribution.makeDefaultGenerator());

    public Logarithmic(double d2, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.my_p);
    }

    public double nextDouble(double d2) {
        if (d2 != this.a_prev) {
            this.a_prev = d2;
            if (d2 < 0.97) {
                this.t = -d2 / Math.log(1.0 - d2);
            } else {
                this.h = Math.log(1.0 - d2);
            }
        }
        double d3 = this.randomGenerator.raw();
        if (d2 < 0.97) {
            int n = 1;
            double d4 = this.t;
            while (d3 > d4) {
                d3 -= d4;
                d4 *= d2 * ((double)(++n) - 1.0) / (double)n;
            }
            return n;
        }
        if (d3 > d2) {
            return 1.0;
        }
        double d5 = d3 = this.randomGenerator.raw();
        double d6 = 1.0 - Math.exp(d5 * this.h);
        if (d3 <= d6 * d6) {
            int n = (int)(1.0 + Math.log(d3) / Math.log(d6));
            return n;
        }
        if (d3 > d6) {
            return 1.0;
        }
        return 2.0;
    }

    public void setState(double d2) {
        this.my_p = d2;
    }

    public static double staticNextDouble(double d2) {
        Logarithmic logarithmic = shared;
        synchronized (logarithmic) {
            double d3 = shared.nextDouble(d2);
            return d3;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.my_p + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Logarithmic logarithmic = shared;
        synchronized (logarithmic) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

