/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.Fun;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class StudentT
extends AbstractContinousDistribution {
    protected double freedom;
    protected double TERM;
    protected static StudentT shared = new StudentT(1.0, AbstractDistribution.makeDefaultGenerator());

    public StudentT(double d2, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2);
    }

    public double cdf(double d2) {
        return Probability.studentT(this.freedom, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double d2) {
        double d3;
        double d4;
        double d5;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        while ((d5 = (d4 = 2.0 * this.randomGenerator.raw() - 1.0) * d4 + (d3 = 2.0 * this.randomGenerator.raw() - 1.0) * d3) > 1.0) {
        }
        return d4 * Math.sqrt(d2 * (Math.exp(-2.0 / d2 * Math.log(d5)) - 1.0) / d5);
    }

    public double pdf(double d2) {
        return this.TERM * Math.pow(1.0 + d2 * d2 / this.freedom, -(this.freedom + 1.0) * 0.5);
    }

    public void setState(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = d2;
        double d3 = Fun.logGamma((d2 + 1.0) / 2.0) - Fun.logGamma(d2 / 2.0);
        this.TERM = Math.exp(d3) / Math.sqrt(Math.PI * d2);
    }

    public static double staticNextDouble(double d2) {
        StudentT studentT = shared;
        synchronized (studentT) {
            double d3 = shared.nextDouble(d2);
            return d3;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.freedom + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        StudentT studentT = shared;
        synchronized (studentT) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

