/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.engine.MersenneTwister;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Uniform
extends AbstractContinousDistribution {
    protected double min;
    protected double max;
    protected static Uniform shared = new Uniform(AbstractDistribution.makeDefaultGenerator());

    public Uniform(double d2, double d3, int n) {
        this(d2, d3, new MersenneTwister(n));
    }

    public Uniform(double d2, double d3, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2, d3);
    }

    public Uniform(RandomElement randomElement) {
        this(0.0, 1.0, randomElement);
    }

    public double cdf(double d2) {
        if (d2 <= this.min) {
            return 0.0;
        }
        if (d2 >= this.max) {
            return 1.0;
        }
        return (d2 - this.min) / (this.max - this.min);
    }

    public boolean nextBoolean() {
        return this.randomGenerator.raw() > 0.5;
    }

    public double nextDouble() {
        return this.min + (this.max - this.min) * this.randomGenerator.raw();
    }

    public double nextDoubleFromTo(double d2, double d3) {
        return d2 + (d3 - d2) * this.randomGenerator.raw();
    }

    public float nextFloatFromTo(float f, float f2) {
        return (float)this.nextDoubleFromTo(f, f2);
    }

    public int nextInt() {
        return this.nextIntFromTo((int)Math.round(this.min), (int)Math.round(this.max));
    }

    public int nextIntFromTo(int n, int n2) {
        return (int)((long)n + (long)((double)(1L + (long)n2 - (long)n) * this.randomGenerator.raw()));
    }

    public long nextLongFromTo(long l, long l2) {
        long l3;
        if (l >= 0L && l2 < Long.MAX_VALUE) {
            return l + (long)this.nextDoubleFromTo(0.0, l2 - l + 1L);
        }
        double d2 = (double)l2 - (double)l + 1.0;
        if (d2 <= 9.223372036854776E18) {
            return l + (long)this.nextDoubleFromTo(0.0, d2);
        }
        if (l == Long.MIN_VALUE) {
            if (l2 == Long.MAX_VALUE) {
                int n = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                int n2 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return ((long)n & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
            }
            l3 = Math.round(this.nextDoubleFromTo(l, l2 + 1L));
            if (l3 > l2) {
                l3 = l;
            }
        } else {
            l3 = Math.round(this.nextDoubleFromTo(l - 1L, l2));
            if (l3 < l) {
                l3 = l2;
            }
        }
        return l3;
    }

    public double pdf(double d2) {
        if (d2 <= this.min || d2 >= this.max) {
            return 0.0;
        }
        return 1.0 / (this.max - this.min);
    }

    public void setState(double d2, double d3) {
        if (d3 < d2) {
            this.setState(d3, d2);
            return;
        }
        this.min = d2;
        this.max = d3;
    }

    public static boolean staticNextBoolean() {
        Uniform uniform = shared;
        synchronized (uniform) {
            boolean bl = shared.nextBoolean();
            return bl;
        }
    }

    public static double staticNextDouble() {
        Uniform uniform = shared;
        synchronized (uniform) {
            double d2 = shared.nextDouble();
            return d2;
        }
    }

    public static double staticNextDoubleFromTo(double d2, double d3) {
        Uniform uniform = shared;
        synchronized (uniform) {
            double d4 = shared.nextDoubleFromTo(d2, d3);
            return d4;
        }
    }

    public static float staticNextFloatFromTo(float f, float f2) {
        Uniform uniform = shared;
        synchronized (uniform) {
            float f3 = shared.nextFloatFromTo(f, f2);
            return f3;
        }
    }

    public static int staticNextIntFromTo(int n, int n2) {
        Uniform uniform = shared;
        synchronized (uniform) {
            int n3 = shared.nextIntFromTo(n, n2);
            return n3;
        }
    }

    public static long staticNextLongFromTo(long l, long l2) {
        Uniform uniform = shared;
        synchronized (uniform) {
            long l3 = shared.nextLongFromTo(l, l2);
            return l3;
        }
    }

    public static void staticSetRandomEngine(RandomElement randomElement) {
        Uniform uniform = shared;
        synchronized (uniform) {
            shared.setRandomGenerator(randomElement);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.min + "," + this.max + ")";
    }
}

