/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import com.mchange.v2.lang.ThreadGroupUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.reflect.Method;

public final class ThreadUtils {
    private static final MLogger logger;
    static final Method holdsLock;

    public static void enumerateAll(Thread[] threads) {
        ThreadGroupUtils.rootThreadGroup().enumerate(threads);
    }

    public static Boolean reflectiveHoldsLock(Object o) {
        try {
            if (holdsLock == null) {
                return null;
            }
            return (Boolean)holdsLock.invoke(null, o);
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "An Exception occurred while trying to call Thread.holdsLock( ... ) reflectively.", e2);
            }
            return null;
        }
    }

    private ThreadUtils() {
    }

    static {
        Method _holdsLock;
        logger = MLog.getLogger(ThreadUtils.class);
        try {
            _holdsLock = Thread.class.getMethod("holdsLock", Object.class);
        }
        catch (NoSuchMethodException e2) {
            _holdsLock = null;
        }
        holdsLock = _holdsLock;
    }
}

