/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.util;

import com.mchange.v1.util.AbstractMapEntry;
import com.mchange.v1.util.WrapperIterator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DoubleWeakHashMap
implements Map {
    HashMap inner;
    ReferenceQueue keyQ = new ReferenceQueue();
    ReferenceQueue valQ = new ReferenceQueue();
    CheckKeyHolder holder = new CheckKeyHolder();
    Set userKeySet = null;
    Collection valuesCollection = null;
    static /* synthetic */ Class class$com$mchange$v2$util$DoubleWeakHashMap;

    public DoubleWeakHashMap() {
        this.inner = new HashMap();
    }

    public DoubleWeakHashMap(int initialCapacity) {
        this.inner = new HashMap(initialCapacity);
    }

    public DoubleWeakHashMap(int initialCapacity, float loadFactor) {
        this.inner = new HashMap(initialCapacity, loadFactor);
    }

    public DoubleWeakHashMap(Map m) {
        this();
        this.putAll(m);
    }

    public void cleanCleared() {
        WVal wv;
        WKey wk;
        while ((wk = (WKey)this.keyQ.poll()) != null) {
            this.inner.remove(wk);
        }
        while ((wv = (WVal)this.valQ.poll()) != null) {
            this.inner.remove(wv.getWKey());
        }
    }

    public void clear() {
        this.cleanCleared();
        this.inner.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.cleanCleared();
        try {
            boolean bl = this.inner.containsKey(this.holder.set(key));
            return bl;
        }
        finally {
            this.holder.clear();
        }
    }

    public boolean containsValue(Object val) {
        Iterator ii = this.inner.values().iterator();
        while (ii.hasNext()) {
            WVal wval = (WVal)ii.next();
            if (!val.equals(wval.get())) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        this.cleanCleared();
        return new UserEntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        try {
            this.cleanCleared();
            WVal wval = (WVal)this.inner.get(this.holder.set(key));
            Object var3_3 = wval == null ? null : wval.get();
            return var3_3;
        }
        finally {
            this.holder.clear();
        }
    }

    public boolean isEmpty() {
        this.cleanCleared();
        return this.inner.isEmpty();
    }

    public Set keySet() {
        this.cleanCleared();
        if (this.userKeySet == null) {
            this.userKeySet = new UserKeySet();
        }
        return this.userKeySet;
    }

    public Object put(Object key, Object val) {
        this.cleanCleared();
        WVal wout = this.doPut(key, val);
        if (wout != null) {
            return wout.get();
        }
        return null;
    }

    private WVal doPut(Object key, Object val) {
        WKey wk = new WKey(key, this.keyQ);
        WVal wv = new WVal(wk, val, this.valQ);
        return this.inner.put(wk, wv);
    }

    public void putAll(Map m) {
        this.cleanCleared();
        Iterator ii = m.entrySet().iterator();
        while (ii.hasNext()) {
            Map.Entry entry = ii.next();
            this.doPut(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        try {
            this.cleanCleared();
            WVal wv = (WVal)this.inner.remove(this.holder.set(key));
            Object var3_3 = wv == null ? null : wv.get();
            return var3_3;
        }
        finally {
            this.holder.clear();
        }
    }

    public int size() {
        this.cleanCleared();
        return this.inner.size();
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new ValuesCollection();
        }
        return this.valuesCollection;
    }

    class ValuesCollection
    implements Collection {
        ValuesCollection() {
        }

        public boolean add(Object o) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("DoubleWeakHashMap does not support adding to its values Collection.");
        }

        public boolean addAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("DoubleWeakHashMap does not support adding to its values Collection.");
        }

        public void clear() {
            DoubleWeakHashMap.this.clear();
        }

        public boolean contains(Object o) {
            return DoubleWeakHashMap.this.containsValue(o);
        }

        public boolean containsAll(Collection c2) {
            Iterator ii = c2.iterator();
            while (ii.hasNext()) {
                if (this.contains(ii.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return DoubleWeakHashMap.this.isEmpty();
        }

        public Iterator iterator() {
            return new WrapperIterator(DoubleWeakHashMap.this.inner.values().iterator(), true){

                protected Object transformObject(Object o) {
                    Object val = ((WVal)o).get();
                    if (val == null) {
                        return WrapperIterator.SKIP_TOKEN;
                    }
                    return val;
                }
            };
        }

        public boolean remove(Object o) {
            DoubleWeakHashMap.this.cleanCleared();
            return this.removeValue(o);
        }

        public boolean removeAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            boolean out = false;
            Iterator ii = c2.iterator();
            while (ii.hasNext()) {
                out |= this.removeValue(ii.next());
            }
            return out;
        }

        public boolean retainAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            return this.retainValues(c2);
        }

        public int size() {
            return DoubleWeakHashMap.this.size();
        }

        public Object[] toArray() {
            DoubleWeakHashMap.this.cleanCleared();
            return new ArrayList(this).toArray();
        }

        public Object[] toArray(Object[] array) {
            DoubleWeakHashMap.this.cleanCleared();
            return new ArrayList(this).toArray(array);
        }

        private boolean removeValue(Object val) {
            boolean out = false;
            Iterator ii = DoubleWeakHashMap.this.inner.values().iterator();
            while (ii.hasNext()) {
                WVal wv = (WVal)ii.next();
                if (!val.equals(wv.get())) continue;
                ii.remove();
                out = true;
            }
            return out;
        }

        private boolean retainValues(Collection c2) {
            boolean out = false;
            Iterator ii = DoubleWeakHashMap.this.inner.values().iterator();
            while (ii.hasNext()) {
                WVal wv = (WVal)ii.next();
                if (c2.contains(wv.get())) continue;
                ii.remove();
                out = true;
            }
            return out;
        }
    }

    class UserKeySet
    implements Set {
        UserKeySet() {
        }

        public boolean add(Object o) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("You cannot add to a Map's key set.");
        }

        public boolean addAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("You cannot add to a Map's key set.");
        }

        public void clear() {
            DoubleWeakHashMap.this.clear();
        }

        public boolean contains(Object o) {
            return DoubleWeakHashMap.this.containsKey(o);
        }

        public boolean containsAll(Collection c2) {
            Iterator ii = c2.iterator();
            while (ii.hasNext()) {
                if (this.contains(ii.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return DoubleWeakHashMap.this.isEmpty();
        }

        public Iterator iterator() {
            DoubleWeakHashMap.this.cleanCleared();
            return new WrapperIterator(DoubleWeakHashMap.this.inner.keySet().iterator(), true){

                protected Object transformObject(Object o) {
                    Object key = ((WKey)o).get();
                    if (key == null) {
                        return WrapperIterator.SKIP_TOKEN;
                    }
                    return key;
                }
            };
        }

        public boolean remove(Object o) {
            return DoubleWeakHashMap.this.remove(o) != null;
        }

        public boolean removeAll(Collection c2) {
            boolean out = false;
            Iterator ii = c2.iterator();
            while (ii.hasNext()) {
                out |= this.remove(ii.next());
            }
            return out;
        }

        public boolean retainAll(Collection c2) {
            boolean out = false;
            Iterator ii = this.iterator();
            while (ii.hasNext()) {
                if (c2.contains(ii.next())) continue;
                ii.remove();
                out = true;
            }
            return out;
        }

        public int size() {
            return DoubleWeakHashMap.this.size();
        }

        public Object[] toArray() {
            DoubleWeakHashMap.this.cleanCleared();
            return new HashSet(this).toArray();
        }

        public Object[] toArray(Object[] array) {
            DoubleWeakHashMap.this.cleanCleared();
            return new HashSet(this).toArray(array);
        }
    }

    class UserEntry
    extends AbstractMapEntry {
        Map.Entry innerEntry;
        Object key;
        Object val;

        UserEntry(Map.Entry innerEntry, Object key, Object val) {
            this.innerEntry = innerEntry;
            this.key = key;
            this.val = val;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.val;
        }

        public final Object setValue(Object value) {
            return this.innerEntry.setValue(new WVal((WKey)this.innerEntry.getKey(), value, DoubleWeakHashMap.this.valQ));
        }
    }

    private final class UserEntrySet
    extends AbstractSet {
        private UserEntrySet() {
        }

        private Set innerEntrySet() {
            DoubleWeakHashMap.this.cleanCleared();
            return DoubleWeakHashMap.this.inner.entrySet();
        }

        public Iterator iterator() {
            return new WrapperIterator(this.innerEntrySet().iterator(), true){

                protected Object transformObject(Object o) {
                    Map.Entry innerEntry = (Map.Entry)o;
                    Object key = ((WKey)innerEntry.getKey()).get();
                    Object val = ((WVal)innerEntry.getValue()).get();
                    if (key == null || val == null) {
                        return WrapperIterator.SKIP_TOKEN;
                    }
                    return new UserEntry(innerEntry, key, val);
                }
            };
        }

        public int size() {
            return this.innerEntrySet().size();
        }
    }

    static final class WVal
    extends WeakReference {
        WKey key;

        WVal(WKey key, Object valObj, ReferenceQueue rq) {
            super(valObj, rq);
            this.key = key;
        }

        public WKey getWKey() {
            return this.key;
        }
    }

    static final class WKey
    extends WeakReference {
        int cachedHash;

        WKey(Object keyObj, ReferenceQueue rq) {
            super(keyObj, rq);
            this.cachedHash = keyObj.hashCode();
        }

        public int hashCode() {
            return this.cachedHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WKey) {
                WKey oo = (WKey)o;
                Object myVal = this.get();
                Object ooVal = oo.get();
                if (myVal == null || ooVal == null) {
                    return false;
                }
                return myVal.equals(ooVal);
            }
            if (o instanceof CheckKeyHolder) {
                CheckKeyHolder oo = (CheckKeyHolder)o;
                Object myVal = this.get();
                Object ooVal = oo.get();
                if (myVal == null || ooVal == null) {
                    return false;
                }
                return myVal.equals(ooVal);
            }
            return false;
        }
    }

    static final class CheckKeyHolder {
        Object checkKey;
        static final /* synthetic */ boolean $assertionsDisabled;

        CheckKeyHolder() {
        }

        public Object get() {
            return this.checkKey;
        }

        public CheckKeyHolder set(Object ck) {
            if (!$assertionsDisabled && this.checkKey != null) {
                throw new AssertionError((Object)"Illegal concurrenct use of DoubleWeakHashMap!");
            }
            this.checkKey = ck;
            return this;
        }

        public void clear() {
            this.checkKey = null;
        }

        public int hashCode() {
            return this.checkKey.hashCode();
        }

        public boolean equals(Object o) {
            if (!$assertionsDisabled && this.get() == null) {
                throw new AssertionError((Object)"CheckedKeyHolder should never do an equality check while its value is null.");
            }
            if (this == o) {
                return true;
            }
            if (o instanceof CheckKeyHolder) {
                return this.get().equals(((CheckKeyHolder)o).get());
            }
            if (o instanceof WKey) {
                return this.get().equals(((WKey)o).get());
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$com$mchange$v2$util$DoubleWeakHashMap == null ? (class$com$mchange$v2$util$DoubleWeakHashMap = DoubleWeakHashMap.class$("com.mchange.v2.util.DoubleWeakHashMap")) : class$com$mchange$v2$util$DoubleWeakHashMap).desiredAssertionStatus();
        }
    }
}

