/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsHeap;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.PaddingException;
import nom.tam.fits.TableData;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;
import nom.tam.util.RandomAccess;
import nom.tam.util.TableException;

public class BinaryTable
extends Data
implements TableData {
    FitsHeap heap;
    int heapOffset;
    boolean heapReadFromStream = false;
    int[] sizes;
    int[][] dimens;
    int[] flags;
    private boolean warnedOnVariableConversion = false;
    static final int COL_CONSTANT = 0;
    static final int COL_VARYING = 1;
    static final int COL_COMPLEX = 2;
    static final int COL_STRING = 4;
    static final int COL_BOOLEAN = 8;
    static final int COL_BIT = 16;
    static final int COL_LONGVARY = 32;
    int nRow;
    int nCol;
    int rowLen;
    Class[] bases;
    Object[] modelRow;
    Object[] columns;
    ColumnTable table;
    ArrayDataInput currInput;

    public BinaryTable() throws FitsException {
        try {
            this.table = new ColumnTable(new Object[0], new int[0]);
        }
        catch (TableException e2) {
            System.err.println("Impossible exception in BinaryTable() constructor" + e2);
        }
        this.heap = new FitsHeap(0);
        this.extendArrays(0);
        this.nRow = 0;
        this.nCol = 0;
        this.rowLen = 0;
    }

    public BinaryTable(Header myHeader) throws FitsException {
        long heapSizeL = myHeader.getLongValue("PCOUNT");
        long heapOffsetL = myHeader.getLongValue("THEAP");
        if (heapOffsetL > Integer.MAX_VALUE) {
            throw new FitsException("Heap Offset > 2GB");
        }
        this.heapOffset = (int)heapOffsetL;
        if (heapSizeL > Integer.MAX_VALUE) {
            throw new FitsException("Heap size > 2 GB");
        }
        int heapSize = (int)heapSizeL;
        int rwsz = myHeader.getIntValue("NAXIS1");
        this.nRow = myHeader.getIntValue("NAXIS2");
        if (this.heapOffset > 0) {
            this.heapOffset -= this.nRow * rwsz;
        }
        if (this.heapOffset < 0 || this.heapOffset > heapSize) {
            throw new FitsException("Inconsistent THEAP and PCOUNT");
        }
        if (heapSize - this.heapOffset > Integer.MAX_VALUE) {
            throw new FitsException("Unable to allocate heap > 2GB");
        }
        this.heap = new FitsHeap(heapSize - this.heapOffset);
        this.nCol = myHeader.getIntValue("TFIELDS");
        this.rowLen = 0;
        this.extendArrays(this.nCol);
        int col = 0;
        while (col < this.nCol) {
            this.rowLen += this.processCol(myHeader, col);
            ++col;
        }
        HeaderCard card = myHeader.findCard("NAXIS1");
        card.setValue(String.valueOf(this.rowLen));
        myHeader.updateLine("NAXIS1", card);
    }

    public BinaryTable(Object[][] data) throws FitsException {
        this(BinaryTable.convertToColumns(data));
    }

    public BinaryTable(Object[] o) throws FitsException {
        this.heap = new FitsHeap(0);
        this.modelRow = new Object[o.length];
        this.extendArrays(o.length);
        int i = 0;
        while (i < o.length) {
            this.addColumn(o[i]);
            ++i;
        }
    }

    public BinaryTable(ColumnTable tab) {
        this.nCol = tab.getNCols();
        this.extendArrays(this.nCol);
        this.bases = tab.getBases();
        this.sizes = tab.getSizes();
        this.modelRow = new Object[this.nCol];
        this.dimens = new int[this.nCol][];
        this.flags = new int[this.nCol];
        int col = 0;
        while (col < this.nCol) {
            this.dimens[col] = this.sizes[col] != 1 ? new int[]{this.sizes[col]} : new int[0];
            ++col;
        }
        col = 0;
        while (col < this.nCol) {
            this.modelRow[col] = ArrayFuncs.newInstance(this.bases[col], this.sizes[col]);
            ++col;
        }
        this.columns = null;
        this.table = tab;
        this.heap = new FitsHeap(0);
        this.rowLen = 0;
        col = 0;
        while (col < this.nCol) {
            this.rowLen += this.sizes[col] * ArrayFuncs.getBaseLength(tab.getColumn(col));
            ++col;
        }
        this.heapOffset = 0;
        this.nRow = tab.getNRows();
    }

    public Object[] getModelRow() {
        return this.modelRow;
    }

    private int processCol(Header header, int col) throws FitsException {
        char type;
        String tform = header.getStringValue("TFORM" + (col + 1));
        if (tform == null) {
            throw new FitsException("Attempt to process column " + (col + 1) + " but no TFORMn found.");
        }
        tform = tform.trim();
        String tdims = header.getStringValue("TDIM" + (col + 1));
        if (tdims != null) {
            tdims = tdims.trim();
        }
        if ((type = this.getTFORMType(tform)) == 'P' || type == 'Q') {
            int n = col;
            this.flags[n] = this.flags[n] | 1;
            if (type == 'Q') {
                int n2 = col;
                this.flags[n2] = this.flags[n2] | 0x20;
            }
            type = this.getTFORMVarType(tform);
        }
        int size = this.getTFORMLength(tform);
        if (type == 'X') {
            size = (size + 7) / 8;
            int n = col;
            this.flags[n] = this.flags[n] | 0x10;
        } else if (this.isVarCol(col)) {
            size = 2;
        }
        int bSize = size;
        int[] dims = null;
        if (tdims != null && type != 'X' && !this.isVarCol(col)) {
            dims = BinaryTable.getTDims(tdims);
        }
        if (dims == null) {
            dims = size == 1 ? new int[]{} : new int[]{size};
        }
        if (type == 'C' || type == 'M') {
            int n = col;
            this.flags[n] = this.flags[n] | 2;
        }
        Class<Number> colBase = null;
        switch (type) {
            case 'A': {
                colBase = Byte.TYPE;
                int n = col;
                this.flags[n] = this.flags[n] | 4;
                this.bases[col] = String.class;
                break;
            }
            case 'L': {
                colBase = Byte.TYPE;
                this.bases[col] = Boolean.TYPE;
                int n = col;
                this.flags[n] = this.flags[n] | 8;
                break;
            }
            case 'B': 
            case 'X': {
                colBase = Byte.TYPE;
                this.bases[col] = Byte.TYPE;
                break;
            }
            case 'I': {
                colBase = Short.TYPE;
                this.bases[col] = Short.TYPE;
                bSize *= 2;
                break;
            }
            case 'J': {
                colBase = Integer.TYPE;
                this.bases[col] = Integer.TYPE;
                bSize *= 4;
                break;
            }
            case 'K': {
                colBase = Long.TYPE;
                this.bases[col] = Long.TYPE;
                bSize *= 8;
                break;
            }
            case 'C': 
            case 'E': {
                colBase = Float.TYPE;
                this.bases[col] = Float.TYPE;
                bSize *= 4;
                break;
            }
            case 'D': 
            case 'M': {
                colBase = Double.TYPE;
                this.bases[col] = Double.TYPE;
                bSize *= 8;
                break;
            }
            default: {
                throw new FitsException("Invalid type in column:" + col);
            }
        }
        if (this.isVarCol(col)) {
            dims = new int[]{this.nRow, 2};
            colBase = Integer.TYPE;
            bSize = 8;
            if (this.isLongVary(col)) {
                colBase = Long.TYPE;
                bSize = 16;
            }
        }
        if (!this.isVarCol(col) && this.isComplex(col)) {
            int[] xdims = new int[dims.length + 1];
            System.arraycopy(dims, 0, xdims, 0, dims.length);
            xdims[dims.length] = 2;
            dims = xdims;
            bSize *= 2;
            size *= 2;
        }
        this.modelRow[col] = ArrayFuncs.newInstance(colBase, dims);
        this.dimens[col] = dims;
        this.sizes[col] = size;
        return bSize;
    }

    char getTFORMType(String tform) {
        int i = 0;
        while (i < tform.length()) {
            if (!Character.isDigit(tform.charAt(i))) {
                return tform.charAt(i);
            }
            ++i;
        }
        return '\u0000';
    }

    char getTFORMVarType(String tform) {
        int ind = tform.indexOf("P");
        if (ind < 0) {
            ind = tform.indexOf("Q");
        }
        if (tform.length() > ind + 1) {
            return tform.charAt(ind + 1);
        }
        return '\u0000';
    }

    int getTFORMLength(String tform) {
        if (Character.isDigit((tform = tform.trim()).charAt(0))) {
            return this.initialNumber(tform);
        }
        return 1;
    }

    private int initialNumber(String tform) {
        int i = 0;
        while (i < tform.length()) {
            if (!Character.isDigit(tform.charAt(i))) break;
            ++i;
        }
        return Integer.parseInt(tform.substring(0, i));
    }

    public static int[] getTDims(String tdims) {
        StringTokenizer st;
        int dim;
        int[] dims = null;
        int first = tdims.indexOf(40);
        int last = tdims.lastIndexOf(41);
        if (first >= 0 && last > first && (dim = (st = new StringTokenizer(tdims = tdims.substring(first + 1, last - first), ",")).countTokens()) > 0) {
            dims = new int[dim];
            int i = dim - 1;
            while (i >= 0) {
                dims[i] = Integer.parseInt(st.nextToken().trim());
                --i;
            }
        }
        return dims;
    }

    boolean setComplexColumn(int index) throws FitsException {
        if (index >= 0 && index < this.bases.length && (this.bases[index] == Float.TYPE || this.bases[index] == Double.TYPE) && this.dimens[index][this.dimens[index].length - 1] == 2) {
            if ((this.flags[index] & 1) != 0) {
                Object col = this.getFlattenedColumn(index);
                if (col instanceof int[]) {
                    int[] ptrs = (int[])col;
                    int i = 1;
                    while (i < ptrs.length) {
                        if (ptrs[i] % 2 != 0) {
                            return false;
                        }
                        i += 2;
                    }
                } else {
                    long[] ptrs = (long[])col;
                    int i = 1;
                    while (i < ptrs.length) {
                        if (ptrs[i] % 2L != 0L) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            int n = index;
            this.flags[n] = this.flags[n] | 2;
            return true;
        }
        return false;
    }

    @Override
    public void fillHeader(Header h) throws FitsException {
        try {
            h.setXtension("BINTABLE");
            h.setBitpix(8);
            h.setNaxes(2);
            h.setNaxis(1, this.rowLen);
            h.setNaxis(2, this.nRow);
            h.addValue("PCOUNT", this.heap.size(), "ntf::binarytable:pcount:1");
            h.addValue("GCOUNT", 1L, "ntf::binarytable:gcount:1");
            Cursor iter = h.iterator();
            iter.setKey("GCOUNT");
            iter.next();
            iter.add("TFIELDS", new HeaderCard("TFIELDS", this.modelRow.length, "ntf::binarytable:tfields:1"));
            int i = 0;
            while (i < this.modelRow.length) {
                if (i > 0) {
                    h.positionAfterIndex("TFORM", i);
                }
                this.fillForColumn(h, i, iter);
                ++i;
            }
        }
        catch (HeaderCardException e2) {
            System.err.println("Error updating BinaryTableHeader:" + e2);
        }
    }

    void pointToColumn(int col, Header hdr) throws FitsException {
        Cursor iter = hdr.iterator();
        if (col > 0) {
            hdr.positionAfterIndex("TFORM", col);
        }
        this.fillForColumn(hdr, col, iter);
    }

    void fillForColumn(Header h, int col, Cursor iter) throws FitsException {
        String tform = this.isVarCol(col) ? (this.isLongVary(col) ? "1Q" : "1P") : "" + this.sizes[col];
        if (this.bases[col] == Integer.TYPE) {
            tform = String.valueOf(tform) + "J";
        } else if (this.bases[col] == Short.TYPE || this.bases[col] == Character.TYPE) {
            tform = String.valueOf(tform) + "I";
        } else if (this.bases[col] == Byte.TYPE) {
            tform = String.valueOf(tform) + "B";
        } else if (this.bases[col] == Float.TYPE) {
            tform = this.isComplex(col) ? String.valueOf(tform) + "C" : String.valueOf(tform) + "E";
        } else if (this.bases[col] == Double.TYPE) {
            tform = this.isComplex(col) ? String.valueOf(tform) + "M" : String.valueOf(tform) + "D";
        } else if (this.bases[col] == Long.TYPE) {
            tform = String.valueOf(tform) + "K";
        } else if (this.bases[col] == Boolean.TYPE) {
            tform = String.valueOf(tform) + "L";
        } else if (this.bases[col] == String.class) {
            tform = String.valueOf(tform) + "A";
        } else {
            throw new FitsException("Invalid column data class:" + this.bases[col]);
        }
        String key = "TFORM" + (col + 1);
        iter.add(key, new HeaderCard(key, tform, "ntf::binarytable:tformN:1"));
        if (this.dimens[col].length > 0 && !this.isVarCol(col)) {
            StringBuffer tdim = new StringBuffer();
            int comma = 40;
            int i = this.dimens[col].length - 1;
            while (i >= 0) {
                tdim.append((char)comma);
                tdim.append(this.dimens[col][i]);
                comma = 44;
                --i;
            }
            tdim.append(')');
            key = "TDIM" + (col + 1);
            iter.add(key, new HeaderCard(key, new String(tdim), "ntf::headercard:tdimN:1"));
        }
    }

    private ColumnTable createTable() throws FitsException {
        ColumnTable table;
        int nfields = this.modelRow.length;
        Object[] arrCol = new Object[nfields];
        int i = 0;
        while (i < nfields) {
            arrCol[i] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[i]), this.sizes[i] * this.nRow);
            ++i;
        }
        try {
            table = new ColumnTable(arrCol, this.sizes);
        }
        catch (TableException e2) {
            throw new FitsException("Unable to create table:" + e2);
        }
        return table;
    }

    private static Object[] convertToColumns(Object[][] data) {
        Object[] row = data[0];
        int nrow = data.length;
        Object[] results = new Object[row.length];
        int col = 0;
        while (col < row.length) {
            if (row[col] instanceof String) {
                String[] sa = new String[nrow];
                int irow = 0;
                while (irow < nrow) {
                    sa[irow] = (String)data[irow][col];
                    ++irow;
                }
                results[col] = sa;
            } else {
                Class base = ArrayFuncs.getBaseClass(row[col]);
                int[] dims = ArrayFuncs.getDimensions(row[col]);
                if (dims.length > 1 || dims[0] > 1) {
                    int[] xdims = new int[dims.length + 1];
                    xdims[0] = nrow;
                    Object[] arr = (Object[])ArrayFuncs.newInstance(base, xdims);
                    int irow = 0;
                    while (irow < nrow) {
                        arr[irow] = data[irow][col];
                        ++irow;
                    }
                    results[col] = arr;
                } else {
                    Object arr = ArrayFuncs.newInstance(base, nrow);
                    int irow = 0;
                    while (irow < nrow) {
                        System.arraycopy(data[irow][col], 0, arr, irow, 1);
                        ++irow;
                    }
                    results[col] = arr;
                }
            }
            ++col;
        }
        return results;
    }

    @Override
    public Object[] getRow(int row) throws FitsException {
        if (!this.validRow(row)) {
            throw new FitsException("Invalid row");
        }
        Object[] res = this.table != null ? this.getMemoryRow(row) : this.getFileRow(row);
        return res;
    }

    private Object[] getMemoryRow(int row) throws FitsException {
        Object[] data = new Object[this.modelRow.length];
        int col = 0;
        while (col < this.modelRow.length) {
            Object o = this.table.getElement(row, col);
            o = this.columnToArray(col, o, 1);
            data[col] = this.encurl(o, col, 1);
            if (data[col] instanceof Object[]) {
                data[col] = ((Object[])data[col])[0];
            }
            ++col;
        }
        return data;
    }

    private Object[] getFileRow(int row) throws FitsException {
        Object[] data = new Object[this.nCol];
        int col = 0;
        while (col < data.length) {
            data[col] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[col]), this.sizes[col]);
            ++col;
        }
        try {
            FitsUtil.reposition(this.currInput, this.fileOffset + (long)(row * this.rowLen));
            this.currInput.readLArray(data);
        }
        catch (IOException e2) {
            throw new FitsException("Error in deferred row read");
        }
        col = 0;
        while (col < data.length) {
            data[col] = this.columnToArray(col, data[col], 1);
            data[col] = this.encurl(data[col], col, 1);
            if (data[col] instanceof Object[]) {
                data[col] = ((Object[])data[col])[0];
            }
            ++col;
        }
        return data;
    }

    @Override
    public void setRow(int row, Object[] data) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (data.length != this.getNCols()) {
            throw new FitsException("Updated row size does not agree with table");
        }
        Object[] ydata = new Object[data.length];
        int col = 0;
        while (col < data.length) {
            Object o = ArrayFuncs.flatten(data[col]);
            ydata[col] = this.arrayToColumn(col, o);
            ++col;
        }
        try {
            this.table.setRow(row, ydata);
        }
        catch (TableException e2) {
            throw new FitsException("Error modifying table: " + e2);
        }
    }

    @Override
    public void setColumn(int col, Object xcol) throws FitsException {
        xcol = this.arrayToColumn(col, xcol);
        xcol = ArrayFuncs.flatten(xcol);
        this.setFlattenedColumn(col, xcol);
    }

    public void setFlattenedColumn(int col, Object data) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        Object oldCol = this.table.getColumn(col);
        if (data.getClass() != oldCol.getClass() || Array.getLength(data) != Array.getLength(oldCol)) {
            throw new FitsException("Replacement column mismatch at column:" + col);
        }
        try {
            this.table.setColumn(col, data);
        }
        catch (TableException e2) {
            throw new FitsException("Unable to set column:" + col + " error:" + e2);
        }
    }

    @Override
    public Object getColumn(int col) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        Object res = this.getFlattenedColumn(col);
        res = this.encurl(res, col, this.nRow);
        return res;
    }

    private Object encurl(Object res, int col, int rows) {
        if (this.bases[col] != String.class) {
            if (!this.isVarCol(col) && this.dimens[col].length > 0) {
                int[] dims = new int[this.dimens[col].length + 1];
                System.arraycopy(this.dimens[col], 0, dims, 1, this.dimens[col].length);
                dims[0] = rows;
                res = ArrayFuncs.curl(res, dims);
            }
        } else if (this.dimens[col].length > 2) {
            int[] dims = new int[this.dimens[col].length];
            System.arraycopy(this.dimens[col], 0, dims, 1, this.dimens[col].length - 1);
            dims[0] = rows;
            res = ArrayFuncs.curl(res, dims);
        }
        return res;
    }

    public Object getFlattenedColumn(int col) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (!this.validColumn(col)) {
            throw new FitsException("Invalid column");
        }
        Object res = this.table.getColumn(col);
        return this.columnToArray(col, res, this.nRow);
    }

    @Override
    public Object getElement(int i, int j) throws FitsException {
        Object ele;
        if (!this.validRow(i) || !this.validColumn(j)) {
            throw new FitsException("No such element");
        }
        if (this.isVarCol(j) && this.table == null) {
            this.getData();
        }
        if (this.table == null) {
            Object[] row = this.getRow(i);
            ele = row[j];
        } else {
            ele = this.table.getElement(i, j);
            ele = this.columnToArray(j, ele, 1);
            if ((ele = this.encurl(ele, j, 1)) instanceof Object[]) {
                ele = ((Object[])ele)[0];
            }
        }
        return ele;
    }

    public Object getRawElement(int i, int j) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        return this.table.getElement(i, j);
    }

    @Override
    public int addRow(Object[] o) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (this.nCol == 0 && this.nRow == 0) {
            int i = 0;
            while (i < o.length) {
                this.addColumn(o);
                ++i;
            }
        } else {
            Object[] flatRow = new Object[this.getNCols()];
            int i = 0;
            while (i < this.getNCols()) {
                Object x = ArrayFuncs.flatten(o[i]);
                flatRow[i] = this.arrayToColumn(i, x);
                ++i;
            }
            try {
                this.table.addRow(flatRow);
            }
            catch (TableException e2) {
                throw new FitsException("Error add row to table");
            }
            ++this.nRow;
        }
        return this.nRow;
    }

    @Override
    public void deleteRows(int row, int len) throws FitsException {
        try {
            this.getData();
            this.table.deleteRows(row, len);
            this.nRow -= len;
        }
        catch (TableException e2) {
            throw new FitsException("Error deleting row block " + row + " to " + (row + len - 1) + " from table");
        }
    }

    @Override
    public int addColumn(Object o) throws FitsException {
        int primeDim = Array.getLength(o);
        this.extendArrays(this.nCol + 1);
        Class base = ArrayFuncs.getBaseClass(o);
        if (this.isVarying(o)) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 1;
            this.dimens[this.nCol] = new int[]{2};
        }
        if (this.isVaryingComp(o)) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 3;
            this.dimens[this.nCol] = new int[]{2};
        }
        if (!this.isVarCol(this.nCol)) {
            int[] allDim = ArrayFuncs.getDimensions(o);
            if (base == String.class) {
                int[] xdim = new int[allDim.length + 1];
                System.arraycopy(allDim, 0, xdim, 0, allDim.length);
                xdim[allDim.length] = -1;
                allDim = xdim;
            }
            if (allDim.length == 1) {
                this.dimens[this.nCol] = new int[0];
            } else {
                this.dimens[this.nCol] = new int[allDim.length - 1];
                System.arraycopy(allDim, 1, this.dimens[this.nCol], 0, allDim.length - 1);
                o = ArrayFuncs.flatten(o);
            }
        }
        this.addFlattenedColumn(o, this.dimens[this.nCol]);
        if (this.nRow == 0 && this.nCol == 0) {
            this.nRow = primeDim;
        }
        ++this.nCol;
        return this.getNCols();
    }

    private boolean isVaryingComp(Object o) {
        String classname = o.getClass().getName();
        if (classname.equals("[[[F")) {
            return this.checkCompVary((float[][][])o);
        }
        if (classname.equals("[[[D")) {
            return this.checkDCompVary((double[][][])o);
        }
        return false;
    }

    private boolean isVarying(Object o) {
        if (o == null) {
            return false;
        }
        String classname = o.getClass().getName();
        if (classname.length() != 3 || classname.charAt(0) != '[' || classname.charAt(1) != '[') {
            return false;
        }
        Object[] ox = (Object[])o;
        if (ox.length < 2) {
            return false;
        }
        int flen = Array.getLength(ox[0]);
        int i = 1;
        while (i < ox.length) {
            if (Array.getLength(ox[i]) != flen) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkCompVary(float[][][] o) {
        boolean varying = false;
        int len0 = o[0].length;
        int i = 0;
        while (i < o.length) {
            if (o[i].length != len0) {
                varying = true;
            }
            if (o[i].length > 0) {
                int j = 0;
                while (j < o[i].length) {
                    if (o[i][j].length != 2) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return varying;
    }

    private boolean checkDCompVary(double[][][] o) {
        boolean varying = false;
        int len0 = o[0].length;
        int i = 0;
        while (i < o.length) {
            if (o[i].length != len0) {
                varying = true;
            }
            if (o[i].length > 0) {
                int j = 0;
                while (j < o[i].length) {
                    if (o[i][j].length != 2) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return varying;
    }

    public int addFlattenedColumn(Object o, int[] dims) throws FitsException {
        int xRow;
        this.extendArrays(this.nCol + 1);
        this.bases[this.nCol] = ArrayFuncs.getBaseClass(o);
        if (this.bases[this.nCol] == Boolean.TYPE) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 8;
        } else if (this.bases[this.nCol] == String.class) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 4;
        }
        o = this.arrayToColumn(this.nCol, o);
        int size = 1;
        int dim = 0;
        while (dim < dims.length) {
            size *= dims[dim];
            ++dim;
        }
        this.sizes[this.nCol] = size;
        if (size != 0 && (xRow = Array.getLength(o) / size) > 0 && this.nCol != 0 && xRow != this.nRow) {
            throw new FitsException("Added column does not have correct row count");
        }
        if (!this.isVarCol(this.nCol)) {
            this.modelRow[this.nCol] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(o), dims);
            this.rowLen += size * ArrayFuncs.getBaseLength(o);
        } else if (this.isLongVary(this.nCol)) {
            this.modelRow[this.nCol] = new long[2];
            this.rowLen += 16;
        } else {
            this.modelRow[this.nCol] = new int[2];
            this.rowLen += 8;
        }
        this.columns[this.nCol] = o;
        try {
            if (this.table != null) {
                this.table.addColumn(o, this.sizes[this.nCol]);
            } else if (this.nCol == this.columns.length - 1) {
                this.table = new ColumnTable(this.columns, this.sizes);
            }
        }
        catch (TableException e2) {
            throw new FitsException("Error in ColumnTable:" + e2);
        }
        return this.nCol;
    }

    @Override
    public int getNRows() {
        return this.nRow;
    }

    @Override
    public int getNCols() {
        return this.nCol;
    }

    protected boolean validRow(int i) {
        return this.getNRows() > 0 && i >= 0 && i < this.getNRows();
    }

    protected boolean validColumn(int j) {
        return j >= 0 && j < this.getNCols();
    }

    @Override
    public void setElement(int i, int j, Object o) throws FitsException {
        this.getData();
        try {
            if (this.isVarCol(j)) {
                int size = Array.getLength(o);
                int offset = (int)this.heap.getSize();
                this.heap.putData(o);
                if (this.isLongVary(j)) {
                    this.table.setElement(i, j, new long[]{size, offset});
                } else {
                    this.table.setElement(i, j, new int[]{size, offset});
                }
            } else {
                this.table.setElement(i, j, ArrayFuncs.flatten(o));
            }
        }
        catch (TableException e2) {
            throw new FitsException("Error modifying table:" + e2);
        }
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        this.setFileOffset(i);
        this.currInput = i;
        if (i instanceof RandomAccess) {
            try {
                i.skipBytes(this.getTrueSize());
            }
            catch (IOException e2) {
                throw new FitsException("Unable to skip binary table HDU:" + e2);
            }
            try {
                i.skipBytes(FitsUtil.padding(this.getTrueSize()));
            }
            catch (EOFException e3) {
                throw new PaddingException("Missing padding after binary table:" + e3, this);
            }
            catch (IOException e4) {
                throw new FitsException("Error skipping padding after binary table:" + e4);
            }
        }
        if (this.table == null) {
            this.table = this.createTable();
        }
        this.readTrueData(i);
    }

    protected void readTrueData(ArrayDataInput i) throws FitsException {
        try {
            this.table.read(i);
            i.skipBytes(this.heapOffset);
            this.heap.read(i);
            this.heapReadFromStream = true;
        }
        catch (IOException e2) {
            throw new FitsException("Error reading binary table data:" + e2);
        }
        try {
            i.skipBytes(FitsUtil.padding(this.getTrueSize()));
        }
        catch (EOFException e3) {
            throw new PaddingException("Error skipping padding after binary table", this);
        }
        catch (IOException e4) {
            throw new FitsException("Error reading binary table data padding:" + e4);
        }
    }

    protected void readHeap(ArrayDataInput input) throws FitsException {
        FitsUtil.reposition(input, this.fileOffset + (long)(this.nRow * this.rowLen) + (long)this.heapOffset);
        this.heap.read(input);
        this.heapReadFromStream = true;
    }

    @Override
    public long getTrueSize() {
        long len = (long)this.nRow * (long)this.rowLen;
        if (this.heap.size() > 0) {
            len += (long)(this.heap.size() + this.heapOffset);
        }
        return len;
    }

    @Override
    public void write(ArrayDataOutput os) throws FitsException {
        this.getData();
        try {
            int len = this.table.write(os);
            if (this.heapOffset > 0) {
                int off = this.heapOffset;
                int arrSiz = 4000000;
                while (off > 0) {
                    if (arrSiz > off) {
                        arrSiz = off;
                    }
                    os.write(new byte[arrSiz]);
                    off -= arrSiz;
                }
            }
            if (this.heap.size() > 0) {
                this.heap.write(os);
            }
            FitsUtil.pad(os, this.getTrueSize());
        }
        catch (IOException e2) {
            throw new FitsException("Unable to write table:" + e2);
        }
    }

    @Override
    public Object getData() throws FitsException {
        if (this.table == null) {
            if (this.currInput == null) {
                throw new FitsException("Cannot find input for deferred read");
            }
            this.table = this.createTable();
            long currentOffset = FitsUtil.findOffset(this.currInput);
            FitsUtil.reposition(this.currInput, this.fileOffset);
            this.readTrueData(this.input);
            FitsUtil.reposition(this.currInput, currentOffset);
        }
        return this.table;
    }

    public int[][] getDimens() {
        return this.dimens;
    }

    public Class[] getBases() {
        return this.table.getBases();
    }

    public char[] getTypes() {
        if (this.table == null) {
            try {
                this.getData();
            }
            catch (FitsException fitsException) {
                // empty catch block
            }
        }
        return this.table.getTypes();
    }

    public Object[] getFlatColumns() {
        if (this.table == null) {
            try {
                this.getData();
            }
            catch (FitsException fitsException) {
                // empty catch block
            }
        }
        return this.table.getColumns();
    }

    public int[] getSizes() {
        return this.sizes;
    }

    private Object arrayToColumn(int col, Object o) throws FitsException {
        if (this.flags[col] == 0) {
            return o;
        }
        if (!this.isVarCol(col)) {
            if (this.isString(col)) {
                int[] dims = this.dimens[col];
                if (dims[dims.length - 1] < 0) {
                    dims[dims.length - 1] = FitsUtil.maxLength((String[])o);
                }
                if (o instanceof String) {
                    o = new String[]{(String)o};
                }
                o = FitsUtil.stringsToByteArray((String[])o, dims[dims.length - 1]);
            } else if (this.isBoolean(col)) {
                o = FitsUtil.booleanToByte((boolean[])o);
            }
        } else {
            if (this.isBoolean(col)) {
                if (o instanceof boolean[]) {
                    o = new boolean[][]{(boolean[])o};
                }
                boolean[][] to = (boolean[][])o;
                byte[][] xo = new byte[to.length][];
                int i = 0;
                while (i < to.length) {
                    xo[i] = FitsUtil.booleanToByte(to[i]);
                    ++i;
                }
                o = xo;
            }
            int offset = this.heap.putData(o);
            int blen = ArrayFuncs.getBaseLength(o);
            if (!(o instanceof Object[])) {
                o = new Object[]{o};
            }
            int nrow = Array.getLength(o);
            int factor = 1;
            if (this.isComplex(col)) {
                factor = 2;
            }
            if (this.isLongVary(col)) {
                long[] descrip = new long[2 * nrow];
                Object x = o;
                int i = 0;
                while (i < nrow) {
                    int len = Array.getLength(x[i]);
                    descrip[2 * i] = len;
                    descrip[2 * i + 1] = offset;
                    offset += len * blen * factor;
                    ++i;
                }
                o = descrip;
            } else {
                int[] descrip = new int[2 * nrow];
                Object x = o;
                int i = 0;
                while (i < nrow) {
                    int len;
                    descrip[2 * i] = len = Array.getLength(x[i]);
                    descrip[2 * i + 1] = offset;
                    offset += len * blen * factor;
                    ++i;
                }
                o = descrip;
            }
        }
        return o;
    }

    private Object columnToArray(int col, Object o, int rows) throws FitsException {
        if (this.flags[col] == 0) {
            return o;
        }
        if (this.isVarCol(col)) {
            Object[] res;
            int[] dims;
            int[] descrip;
            if (!this.heapReadFromStream) {
                this.readHeap(this.currInput);
            }
            if (this.isLongVary(col)) {
                if (!this.warnedOnVariableConversion) {
                    System.err.println("Warning: converting long variable array pointers to int's");
                    this.warnedOnVariableConversion = true;
                }
                descrip = (int[])ArrayFuncs.convertArray(o, Integer.TYPE);
            } else {
                descrip = (int[])o;
            }
            int nrow = descrip.length / 2;
            if (this.isComplex(col)) {
                int[] nArray = new int[3];
                nArray[0] = nrow;
                dims = nArray;
                res = (Object[])ArrayFuncs.newInstance(this.bases[col], dims);
                dims = new int[2];
                dims[1] = 2;
            } else if (this.isString(col)) {
                int[] nArray = new int[2];
                nArray[0] = nrow;
                dims = nArray;
                res = (Object[])ArrayFuncs.newInstance(Byte.TYPE, dims);
            } else {
                int[] nArray = new int[2];
                nArray[0] = nrow;
                dims = nArray;
                res = (Object[])ArrayFuncs.newInstance(this.bases[col], dims);
            }
            int i = 0;
            while (i < nrow) {
                Object row;
                int offset = descrip[2 * i + 1];
                int dim = descrip[2 * i];
                if (this.isComplex(col)) {
                    dims[0] = dim;
                    row = ArrayFuncs.newInstance(this.bases[col], dims);
                } else {
                    row = this.isString(col) ? ArrayFuncs.newInstance(Byte.TYPE, dim) : (this.isBoolean(col) ? ArrayFuncs.newInstance(Byte.TYPE, dim) : ArrayFuncs.newInstance(this.bases[col], dim));
                }
                this.heap.getData(offset, row);
                if (this.isBoolean(col)) {
                    row = FitsUtil.byteToBoolean((byte[])row);
                }
                res[i] = row;
                ++i;
            }
            o = res;
        } else if (this.isString(col)) {
            int[] dims = this.dimens[col];
            byte[] bytes = (byte[])o;
            if (bytes.length > 0) {
                o = dims.length > 0 ? FitsUtil.byteArrayToStrings(bytes, dims[dims.length - 1]) : FitsUtil.byteArrayToStrings(bytes, 1);
            } else {
                String[] str = new String[rows];
                int i = 0;
                while (i < str.length) {
                    str[i] = "";
                    ++i;
                }
                o = str;
            }
        } else if (this.isBoolean(col)) {
            o = FitsUtil.byteToBoolean((byte[])o);
        }
        return o;
    }

    private void extendArrays(int need) {
        boolean wasNull = false;
        if (this.sizes == null) {
            wasNull = true;
        } else if (this.sizes.length > need) {
            return;
        }
        int[] newSizes = new int[need];
        int[][] newDimens = new int[need][];
        int[] newFlags = new int[need];
        Object[] newModel = new Object[need];
        Object[] newColumns = new Object[need];
        Class[] newBases = new Class[need];
        if (!wasNull) {
            int len = this.sizes.length;
            System.arraycopy(this.sizes, 0, newSizes, 0, len);
            System.arraycopy(this.dimens, 0, newDimens, 0, len);
            System.arraycopy(this.flags, 0, newFlags, 0, len);
            System.arraycopy(this.modelRow, 0, newModel, 0, len);
            System.arraycopy(this.columns, 0, newColumns, 0, len);
            System.arraycopy(this.bases, 0, newBases, 0, len);
        }
        this.sizes = newSizes;
        this.dimens = newDimens;
        this.flags = newFlags;
        this.modelRow = newModel;
        this.columns = newColumns;
        this.bases = newBases;
    }

    public int getHeapSize() {
        return this.heapOffset + this.heap.size();
    }

    public int getHeapOffset() {
        return this.heapOffset;
    }

    boolean isVarCol(int col) {
        return (this.flags[col] & 1) != 0;
    }

    boolean isLongVary(int col) {
        return (this.flags[col] & 0x20) != 0;
    }

    private boolean isString(int col) {
        return (this.flags[col] & 4) != 0;
    }

    private boolean isComplex(int col) {
        return (this.flags[col] & 2) != 0;
    }

    private boolean isBoolean(int col) {
        return (this.flags[col] & 8) != 0;
    }

    private boolean isBit(int col) {
        return (this.flags[col] & 8) != 0;
    }

    @Override
    public void deleteColumns(int start, int len) throws FitsException {
        this.getData();
        try {
            this.rowLen = this.table.deleteColumns(start, len);
            this.nCol -= len;
        }
        catch (Exception e2) {
            throw new FitsException("Error deleting columns from BinaryTable:" + e2);
        }
    }

    @Override
    public void updateAfterDelete(int oldNcol, Header hdr) throws FitsException {
        hdr.addValue("NAXIS1", this.rowLen, "ntf::binarytable:naxis1:1");
    }
}

