/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.UndefinedHDU;

public class FitsFactory {
    private static boolean useAsciiTables = true;
    private static boolean useHierarch = false;
    private static boolean checkAsciiStrings = false;
    private static boolean allowTerminalJunk = false;

    public static void setUseAsciiTables(boolean flag) {
        useAsciiTables = flag;
    }

    static boolean getUseAsciiTables() {
        return useAsciiTables;
    }

    public static void setUseHierarch(boolean flag) {
        useHierarch = flag;
    }

    public static void setCheckAsciiStrings(boolean flag) {
        checkAsciiStrings = flag;
    }

    static boolean getCheckAsciiStrings() {
        return checkAsciiStrings;
    }

    public static boolean getUseHierarch() {
        return useHierarch;
    }

    public static void setAllowTerminalJunk(boolean flag) {
        allowTerminalJunk = flag;
    }

    public static boolean getAllowTerminalJunk() {
        return allowTerminalJunk;
    }

    public static Data dataFactory(Header hdr) throws FitsException {
        if (ImageHDU.isHeader(hdr)) {
            Data d2 = ImageHDU.manufactureData(hdr);
            hdr.afterExtend();
            return d2;
        }
        if (RandomGroupsHDU.isHeader(hdr)) {
            return RandomGroupsHDU.manufactureData(hdr);
        }
        if (useAsciiTables && AsciiTableHDU.isHeader(hdr)) {
            return AsciiTableHDU.manufactureData(hdr);
        }
        if (BinaryTableHDU.isHeader(hdr)) {
            return BinaryTableHDU.manufactureData(hdr);
        }
        if (UndefinedHDU.isHeader(hdr)) {
            return UndefinedHDU.manufactureData(hdr);
        }
        throw new FitsException("Unrecognizable header in dataFactory");
    }

    public static BasicHDU HDUFactory(Object o) throws FitsException {
        Data d2;
        Header h;
        if (o instanceof Header) {
            h = (Header)o;
            d2 = FitsFactory.dataFactory(h);
        } else if (ImageHDU.isData(o)) {
            d2 = ImageHDU.encapsulate(o);
            h = ImageHDU.manufactureHeader(d2);
        } else if (RandomGroupsHDU.isData(o)) {
            d2 = RandomGroupsHDU.encapsulate(o);
            h = RandomGroupsHDU.manufactureHeader(d2);
        } else if (useAsciiTables && AsciiTableHDU.isData(o)) {
            d2 = AsciiTableHDU.encapsulate(o);
            h = AsciiTableHDU.manufactureHeader(d2);
        } else if (BinaryTableHDU.isData(o)) {
            d2 = BinaryTableHDU.encapsulate(o);
            h = BinaryTableHDU.manufactureHeader(d2);
        } else if (UndefinedHDU.isData(o)) {
            d2 = UndefinedHDU.encapsulate(o);
            h = UndefinedHDU.manufactureHeader(d2);
        } else {
            throw new FitsException("Invalid data presented to HDUFactory");
        }
        return FitsFactory.HDUFactory(h, d2);
    }

    public static BasicHDU HDUFactory(Header hdr, Data d2) throws FitsException {
        if (d2 instanceof ImageData) {
            return new ImageHDU(hdr, d2);
        }
        if (d2 instanceof RandomGroupsData) {
            return new RandomGroupsHDU(hdr, d2);
        }
        if (d2 instanceof AsciiTable) {
            return new AsciiTableHDU(hdr, d2);
        }
        if (d2 instanceof BinaryTable) {
            return new BinaryTableHDU(hdr, d2);
        }
        if (d2 instanceof UndefinedData) {
            return new UndefinedHDU(hdr, d2);
        }
        return null;
    }
}

