/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.eso.cpl.gui.FrameTableModelTransferHandler;

class GUIUtils {
    GUIUtils() {
    }

    static void configureTable(JTable table) {
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setCellSelectionEnabled(false);
    }

    static void enableFileListDragDrop(JTable table) {
        table.setDragEnabled(true);
        table.setTransferHandler(new FrameTableModelTransferHandler());
    }

    static void enableFileListDragDrop(JScrollPane scroller) {
        scroller.setTransferHandler(new FrameTableModelTransferHandler());
    }

    static JScrollPane wrapInScroller(JComponent comp) {
        JScrollPane scroller = new JScrollPane(comp);
        Color bg = scroller.getViewport().getView().getBackground();
        scroller.getViewport().setBackground(bg);
        scroller.setPreferredSize(new Dimension(700, 140));
        return scroller;
    }

    static JComponent wrapInBorder(JComponent comp, String title) {
        Border baseBorder = BorderFactory.createLineBorder(Color.black);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(baseBorder, title);
        Border gapBorder = BorderFactory.createEmptyBorder(0, 1, 0, 0);
        CompoundBorder addedBorder = BorderFactory.createCompoundBorder(gapBorder, titleBorder);
        Border oldBorder = comp.getBorder();
        CompoundBorder newBorder = BorderFactory.createCompoundBorder(addedBorder, oldBorder);
        comp.setBorder(newBorder);
        return comp;
    }
}

