/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.Component;
import java.awt.Toolkit;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.eso.cpl.EnumConstraint;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;

class Renderers {
    private static JTable dummyJTable_ = new JTable();
    private static TableCellRenderer floatRenderer_ = new FloatingPointRenderer(dummyJTable_.getDefaultRenderer(Float.class));
    private static TableCellRenderer doubleRenderer_ = new FloatingPointRenderer(dummyJTable_.getDefaultRenderer(Double.class));
    private static TableCellRenderer trailingStringRenderer_ = new TrailingRenderer(dummyJTable_.getDefaultRenderer(String.class));
    private static TableCellEditor trailingStringEditor_ = new TrailingEditor(Renderers.getDefaultEditor(String.class));
    private static TableCellRenderer componentRenderer_ = new ComponentRenderer();

    Renderers() {
    }

    public static TableCellRenderer getParameterValueRenderer(Parameter param) {
        return Renderers.getDefaultRenderer(param.getType().getValueClass());
    }

    public static TableCellEditor getParameterValueEditor(Parameter param) {
        ParameterConstraint constraint = param.getConstraint();
        ParameterType ptype = param.getType();
        if (constraint instanceof EnumConstraint) {
            return Renderers.getOptionEditor(((EnumConstraint)constraint).getOptions());
        }
        final Parameter param1 = param;
        Class clazz = ptype.getValueClass();
        return new DelegateTableCellEditor(Renderers.getDefaultEditor(clazz)){

            @Override
            public boolean stopCellEditing() {
                super.stopCellEditing();
                boolean ok = Renderers.attemptSetValue(param1, this.getCellEditorValue());
                if (ok) {
                    return super.stopCellEditing();
                }
                super.cancelCellEditing();
                return false;
            }
        };
    }

    public static TableCellEditor getOptionEditor(List options) {
        Object[] opts = options.toArray();
        JComboBox<Object> optSelector = new JComboBox<Object>(opts);
        final DefaultCellEditor ed = new DefaultCellEditor(optSelector);
        optSelector.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ed.stopCellEditing();
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        return ed;
    }

    public static TableCellRenderer getTrailingStringRenderer() {
        return trailingStringRenderer_;
    }

    public static TableCellEditor getTrailingStringEditor() {
        return trailingStringEditor_;
    }

    public static TableCellRenderer getDefaultRenderer(Class clazz) {
        if (clazz == Float.class) {
            return floatRenderer_;
        }
        if (clazz == Double.class) {
            return doubleRenderer_;
        }
        TableCellRenderer rend = dummyJTable_.getDefaultRenderer(clazz);
        return rend == null ? new DefaultTableCellRenderer() : rend;
    }

    public static TableCellRenderer getComponentRenderer() {
        return componentRenderer_;
    }

    public static TableCellEditor getComponentEditor() {
        return new ComponentEditor();
    }

    public static TableCellEditor getDefaultEditor(Class clazz) {
        TableCellEditor ed = dummyJTable_.getDefaultEditor(clazz);
        if (ed == null) {
            ed = new DefaultCellEditor(new JTextField());
        }
        if (ed instanceof DefaultCellEditor) {
            ((DefaultCellEditor)ed).setClickCountToStart(1);
        }
        ed = new DelegateTableCellEditor(ed){

            @Override
            public boolean shouldSelectCell(EventObject evt) {
                return false;
            }
        };
        return ed;
    }

    private static boolean attemptSetValue(Parameter param, Object val) {
        if (val == null) {
            return false;
        }
        try {
            if (val instanceof String) {
                param.setValueFromString((String)val);
            } else {
                param.setValue(val);
            }
            return true;
        }
        catch (ParameterValueException e2) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
    }

    private static class DelegateTableCellEditor
    implements TableCellEditor {
        final TableCellEditor base_;

        DelegateTableCellEditor(TableCellEditor base) {
            this.base_ = base;
        }

        @Override
        public void addCellEditorListener(CellEditorListener listener) {
            this.base_.addCellEditorListener(listener);
        }

        @Override
        public void cancelCellEditing() {
            this.base_.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.base_.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            return this.base_.isCellEditable(evt);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener listener) {
            this.base_.removeCellEditorListener(listener);
        }

        @Override
        public boolean shouldSelectCell(EventObject evt) {
            return this.base_.shouldSelectCell(evt);
        }

        @Override
        public boolean stopCellEditing() {
            return this.base_.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int irow, int icol) {
            return this.base_.getTableCellEditorComponent(table, value, isSelected, irow, icol);
        }
    }

    private static class TrailingRenderer
    implements TableCellRenderer {
        private final TableCellRenderer base_;

        public TrailingRenderer(TableCellRenderer base) {
            this.base_ = base;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int irow, int icol) {
            Component comp = this.base_.getTableCellRendererComponent(table, value, isSelected, hasFocus, irow, icol);
            return comp;
        }
    }

    private static class TrailingEditor
    extends DelegateTableCellEditor {
        public TrailingEditor(TableCellEditor base) {
            super(base);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int irow, int icol) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, irow, icol);
            return comp;
        }
    }

    private static class FloatingPointRenderer
    implements TableCellRenderer {
        private final TableCellRenderer base_;
        private static Pattern intPattern_ = Pattern.compile("[\\+\\-]?[0-9]*");

        public FloatingPointRenderer(TableCellRenderer base) {
            this.base_ = base;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int irow, int icol) {
            JLabel label;
            String text;
            Component comp = this.base_.getTableCellRendererComponent(table, value, isSelected, hasFocus, irow, icol);
            if (comp instanceof JLabel && intPattern_.matcher(text = (label = (JLabel)comp).getText()).matches()) {
                label.setText(text + ".0");
            }
            return comp;
        }
    }

    private static class ComponentEditor
    implements TableCellEditor {
        private Component comp;

        private ComponentEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Component) {
                this.comp = (Component)value;
            }
            return this.comp;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comp;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private static class ComponentRenderer
    implements TableCellRenderer {
        private ComponentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int irow, int icol) {
            return value instanceof Component ? (Component)value : null;
        }
    }
}

