/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.eso.gasgano.GasganoDisplay;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.gui.DBTreeTableModel;
import org.eso.gasgano.gui.DFSFileTreeCellRenderer;
import org.eso.gasgano.gui.JTreeTable;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.Exec;

public class DBTreeTable
extends JTreeTable
implements ActionListener {
    private Vector selectionVector = new Vector();
    protected String selectedDir = null;
    private JPopupMenu filePopUpMenu = null;
    private JPopupMenu containerPopUpMenu = null;
    private Object popUpDBComponent = null;
    private GasganoDisplay mainDisplay = null;
    private String retrieveLabel = "Retrieve file(s)";

    public DBTreeTable(DBTreeTableModel model, GasganoDisplay mainDisplay) {
        super(model);
        this.getTree().getSelectionModel().setSelectionMode(4);
        this.getTree().setCellRenderer(new DFSFileTreeCellRenderer());
        this.getTree().addTreeExpansionListener(model);
        model.setTree(this.getTree());
        this.setIntercellSpacing(new Dimension(5, 1));
        this.setColumnWidths();
        this.setupPopUpMenu();
        this.mainDisplay = mainDisplay;
    }

    public void setColumnWidths() {
        TableColumnModel tcm = this.getColumnModel();
        TableColumn tCol = tcm.getColumn(0);
        tCol.setMinWidth(370);
    }

    public Vector getSelectedFiles() {
        Vector rc = this.selectionVector;
        rc.removeAllElements();
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof DBOBComponent)) continue;
                DBOBComponent dbobc = (DBOBComponent)obj;
                rc.addElement(dbobc.getId());
            }
        }
        return rc;
    }

    private void setupPopUpMenu() {
        this.filePopUpMenu = new JPopupMenu();
        this.containerPopUpMenu = new JPopupMenu();
        JMenuItem item = null;
        item = new JMenuItem(PropertyDB.getInstance().getProperty("MENU_CUSTOM1_LBL"));
        this.filePopUpMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem(PropertyDB.getInstance().getProperty("MENU_CUSTOM2_LBL"));
        this.filePopUpMenu.add(item);
        item.addActionListener(this);
        this.filePopUpMenu.addSeparator();
        item = new JMenuItem(this.retrieveLabel);
        this.filePopUpMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem(PropertyDB.getInstance().getProperty("MENU_CUSTOM3_LBL"));
        this.containerPopUpMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem(PropertyDB.getInstance().getProperty("MENU_CUSTOM4_LBL"));
        this.containerPopUpMenu.add(item);
        item.addActionListener(this);
    }

    public Vector getSelectedOBComponents() {
        Vector rc = this.selectionVector;
        rc.removeAllElements();
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof DBOBComponent)) continue;
                rc.addElement(obj);
            }
        }
        return rc;
    }

    public String getSelectedInstrument() {
        Vector selVect = this.getSelectedOBComponents();
        String rc = null;
        int c2 = 0;
        for (int i = 0; i < selVect.size(); ++i) {
            if (!(selVect.elementAt(i) instanceof FitsFileOBComponent)) continue;
            FitsFileOBComponent ffoc = (FitsFileOBComponent)selVect.elementAt(i);
            if (c2 == 0) {
                rc = ffoc.getInstrument();
                ++c2;
                continue;
            }
            ++c2;
            if (ffoc.getInstrument() == null || rc.equals(ffoc.getInstrument())) continue;
            rc = null;
            return rc;
        }
        return rc;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        StringBuffer commandLong = null;
        if (e2.getActionCommand().toString().equals(this.retrieveLabel)) {
            this.mainDisplay.retrieveFilesFromDb(this.getSelectedFiles().elements());
            return;
        }
        for (int i = 0; i < 4; ++i) {
            String tmpString = "MENU_CUSTOM" + String.valueOf(i + 1) + "_LBL";
            if (!e2.getActionCommand().toString().equals(PropertyDB.getInstance().getProperty(tmpString))) continue;
            String command = PropertyDB.getInstance().getProperty("MENU_CUSTOM" + String.valueOf(i + 1));
            if (i > 1) {
                System.out.println(command + " " + this.popUpDBComponent);
                Exec.runCommand(command + " " + this.popUpDBComponent);
            } else {
                commandLong = new StringBuffer(command + " ");
                Enumeration ee = this.getSelectedFiles().elements();
                while (ee.hasMoreElements()) {
                    commandLong.append(ee.nextElement().toString() + " ");
                }
                System.out.println(commandLong);
                Exec.runCommand(commandLong.toString());
            }
            return;
        }
    }
}

