/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import java.util.Vector;
import org.eso.gasgano.datamodel.OBStatusDictionary;
import org.eso.gasgano.datamodel.Observation;
import org.eso.gasgano.datamodel.ObservationDescription;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.PasswordSource;

public class ObsStatusDescription
implements ObservationDescription {
    private String currentProgram = null;
    private String password = null;
    private OBStatusDictionary obStatusDic = null;
    private PasswordSource passwordSource = null;
    private static final String NO_STATUS_INFO = "no status available";
    private final String dbTable = "obrep2..obs_blocks";
    private final String dbStatusField = "status";
    private final String dbPidField = "run_id";
    private final String dbObIdField = "ob_id";

    public ObsStatusDescription() {
        Keyword[] k = new Keyword[]{new Keyword("OBS.NAME", null)};
        FitsFileOBComponent.addToDefaultKeywordQuery(k);
        this.obStatusDic = new OBStatusDictionary();
    }

    public void setPasswordSource(PasswordSource ps) {
        this.passwordSource = ps;
    }

    private String getPassword() {
        String rc = null;
        if (this.passwordSource == null) {
            rc = new String("");
        } else {
            String userName = PropertyDB.getInstance().getProperty("DB_USER_NAME");
            rc = this.passwordSource.getPassword(userName, "Enter OB Database password", "OB_STATUS_FROM_DB_REQUIRED");
        }
        return rc;
    }

    @Override
    public void setDescription(Observation o, OBComponent obc) {
        if (obc instanceof FitsFileOBComponent) {
            FitsFileOBComponent ffob = (FitsFileOBComponent)obc;
            Keyword[] k = FitsFileOBComponent.getDefaultKeywordQuery();
            String obsId = o.getId();
            String obsName = null;
            String programId = null;
            String status = null;
            for (int i = 0; i < k.length; ++i) {
                if (k[i].getName().equals("OBS.NAME")) {
                    if (k[i].getValue() != null) {
                        obsName = k[i].getValue();
                    }
                } else if (k[i].getName().equals("OBS.PROG.ID") && k[i].getValue() != null) {
                    programId = k[i].getValue();
                }
                if (programId != null && obsName != null) break;
            }
            if (obsName == null) {
                obsName = new String("");
            }
            status = this.getStatus(programId, obsId);
            o.setDescription(new String(obsId + "    " + obsName + " " + status));
        }
    }

    private String getStatus(String programId, String obsId) {
        String rc = null;
        if (programId == null || programId.equals("Unknown Program")) {
            rc = new String("");
        } else {
            String statusDesc = null;
            if (this.currentProgram == null || !this.currentProgram.equals(programId)) {
                Vector<String> progVec = new Vector<String>(1);
                DFSDataModel dm = DFSDataModel.getDataModel();
                progVec.addElement(programId);
                this.obStatusDic.clear();
                this.currentProgram = programId;
                String userName = PropertyDB.getInstance().getProperty("DB_USER_NAME");
                String serverUrl = PropertyDB.getInstance().getProperty("DB_SERVER_URL");
                if (!this.obStatusDic.fillFromDatabase(serverUrl, userName, this.getPassword(), "obrep2..obs_blocks", "status", "run_id", "ob_id", progVec)) {
                    System.out.println("Database error: " + this.obStatusDic.getErrorMessage());
                }
            }
            rc = (rc = (String)this.obStatusDic.get(obsId)) == null ? new String("(no status available)") : ((statusDesc = this.obStatusDic.getStatusDescription(rc)) == null ? new String("(" + rc + ")") : new String("(" + statusDesc + ")"));
        }
        return rc;
    }
}

