/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.DataModelChangeListener;
import org.eso.gasgano.datamodel.DataModelChangeNotifier;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.FrameInfo;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.filesystem.DFSTextFile;
import org.eso.gasgano.datamodel.gui.DFSTextFileDisplay;
import org.eso.gasgano.datamodel.gui.FitsFileOBComponent;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class DFSTextFileOBComponent
extends OBComponent
implements DataModelChangeListener {
    private DFSTextFile myFile = null;
    private DataModelChangeNotifier eventSource = null;
    private static JLabel dataLabel = new JLabel(new ImageIcon(DFSTextFileOBComponent.class.getResource("/org/eso/gasgano/gui/icons/data.gif")), 0);

    public DFSTextFileOBComponent(String address) {
        this.myFile = new DFSTextFile(address);
        this.insertInDataModel();
        this.setPipeProduct(true);
    }

    @Override
    public DFSFile getSourceFile() {
        return this.myFile;
    }

    @Override
    public int getStatus() {
        return this.myFile.getStatus();
    }

    private OBComponent getIdentifyingComponent() {
        OBComponent rc = null;
        DFSDataModel dm = DFSDataModel.getDataModel();
        Vector dataSourceSet = dm.getObComponentByBaseName(this.myFile.getBaseName());
        if (dataSourceSet != null && !dataSourceSet.isEmpty()) {
            Enumeration e2 = dataSourceSet.elements();
            while (rc == null && e2.hasMoreElements()) {
                rc = (OBComponent)e2.nextElement();
                if (rc instanceof FitsFileOBComponent) continue;
                rc = null;
            }
        }
        return rc;
    }

    private void insertInDataModel() {
        DFSDataModel dm = DFSDataModel.getDataModel();
        String progId = null;
        String obId = null;
        String telescopeId = null;
        if (!dm.passFilter(this)) {
            this.myFile.setStatus(4);
            return;
        }
        OBComponent dataSource = this.getIdentifyingComponent();
        DataModelChangeNotifier notifier = null;
        if (dataSource == null) {
            progId = "Unknown Program";
            obId = "Unknown Observation";
            telescopeId = "Unknown Telescope";
            notifier = dm;
        } else {
            FrameInfo frameInfo = new FrameInfo();
            dm.provideFrameInfo((KeywordContainerOBComponent)dataSource, frameInfo);
            telescopeId = frameInfo.telescopeId;
            progId = frameInfo.programId;
            obId = frameInfo.obsId;
            notifier = dataSource;
        }
        if (!(this.storeProgram != null && this.storeProgram.equals(progId) && this.storeObservation != null && this.storeObservation.equals(obId) && this.storeTelescope != null && this.storeTelescope.equals(telescopeId))) {
            if (this.eventSource != null) {
                this.storeProgram = null;
                this.storeObservation = null;
                this.storeTelescope = null;
                this.removeFromDataModel();
            }
            if (this.getStatus() == 3) {
                String dir = this.myFile.getPath().getParent();
                dm.addObComponent(progId, obId, dir, telescopeId, this);
                this.storeProgram = this.storeProgram == null ? progId : this.storeProgram;
                this.storeObservation = this.storeObservation == null ? obId : this.storeObservation;
                this.storeTelescope = this.storeTelescope == null ? telescopeId : this.storeTelescope;
                this.registerToNotifier(notifier);
            }
        }
    }

    private void registerToNotifier(DataModelChangeNotifier n) {
        if (this.eventSource != n) {
            if (this.eventSource != null) {
                this.eventSource.removeDataModelChangeListener(this);
            }
            if (n != null) {
                n.addDataModelChangeListener(this);
            }
            this.eventSource = n;
        }
    }

    @Override
    public int update() {
        if (this.myFile.dataRefreshRequired()) {
            boolean inModel = this.getStatus() == 3;
            this.myFile.readData();
            this.insertInDataModel();
        }
        return this.getStatus();
    }

    @Override
    public void dataModelChanged(DataModelEvent e2) {
        if (e2.getEvent() == 0 || e2.getEvent() == 1 || e2.getEvent() == 2) {
            if (PropertyDB.getInstance().isDebug(6)) {
                System.out.println(this.getId() + " received dataModelChangeEvent.");
            }
            if (e2.getFile() != this) {
                this.insertInDataModel();
            }
        }
    }

    @Override
    public JComponent getDisplayComponent() {
        JComponent rc = null;
        if (this.myFile.readFile() == 1) {
            if (!DFSDataModel.getDataModel().isUpdating()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DFSDataModel.getDataModel().update();
                    }
                }).start();
            }
            rc = new JLabel("The file has been slyly removed from the filesystem", 0);
            return rc;
        }
        rc = new DFSTextFileDisplay(this.toString(), this.myFile.getData());
        this.myFile.freeData();
        return rc;
    }

    @Override
    public JComponent getTreeCellComponent() {
        JLabel cell = dataLabel;
        cell.setText(new String(this.toString()));
        cell.setFont(this.getLabelFont());
        return cell;
    }

    @Override
    public String getId() {
        return this.myFile.getAddress();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.registerToNotifier(null);
    }
}

