/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.dfspipeline;

import java.io.File;
import java.util.Properties;

public class DFSPipelineEnvironment {
    private static DFSPipelineEnvironment instance;
    private boolean pipelineEnvironment;

    private DFSPipelineEnvironment() {
        this.assessPipeline();
    }

    private void assessPipeline() {
        Properties environment = null;
        String redBlockDir = null;
        String reducedDataDir = null;
        String rawDataDir = null;
        boolean partlyConfigured = false;
        environment = System.getProperties();
        String osName = environment.getProperty("os.name");
        redBlockDir = environment.getProperty("pipe.redblock");
        if (redBlockDir != null) {
            System.out.println("pipe.redblock: " + redBlockDir);
            partlyConfigured = true;
        }
        if ((rawDataDir = environment.getProperty("pipe.raw")) != null) {
            System.out.println("pipe.raw: " + rawDataDir);
            partlyConfigured = true;
        }
        if ((reducedDataDir = environment.getProperty("pipe.reduced")) != null) {
            System.out.println("pipe.reduced: " + reducedDataDir);
            partlyConfigured = true;
        }
        System.getProperties().put("pipeline.dfs", "false");
        this.pipelineEnvironment = false;
        if ((osName.equals("HP-UX") || osName.equals("Solaris") || osName.equals("SunOS")) && redBlockDir != null && rawDataDir != null && reducedDataDir != null) {
            if (new File(rawDataDir).isDirectory() && new File(reducedDataDir).isDirectory() && new File(redBlockDir).isDirectory()) {
                System.getProperties().put("pipeline.dfs", "true");
                this.pipelineEnvironment = true;
                System.out.println("Running in DFS Pipeline Environment.");
            } else {
                System.out.println("A specified pipeline directory does not exist, cannot run in DFS Pipeline Environment.");
            }
        } else if (partlyConfigured) {
            System.out.println("Incomplete or invalid DFS Pipeline configuration, cannot run in DFS Pipeline Environment.");
        }
    }

    public static DFSPipelineEnvironment getInstance() {
        if (instance == null) {
            instance = new DFSPipelineEnvironment();
        }
        return instance;
    }

    public boolean isPipelineEnvironment() {
        return this.pipelineEnvironment;
    }
}

