/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Frame;
import java.util.Vector;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.gui.SwingWorker;
import org.eso.gasgano.gui.TaskDialog;

public class DataModelBuilder
extends TaskDialog {
    private DFSDataModel dataModel = DFSDataModel.getDataModel();
    private Vector vectorOfFileVectors = null;
    private int filesToDo = 0;
    private int filesDone = 0;
    private static boolean allDone = false;

    public DataModelBuilder(DFSDataModel dm, Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.dataModel = dm;
        if (dm == null) {
            System.out.println("Data Model is NULL");
            System.exit(0);
        }
    }

    @Override
    public void initTask() {
        this.filesToDo = 0;
        this.filesDone = 0;
        allDone = false;
        this.vectorOfFileVectors = this.dataModel.getFileSet();
        super.initTask();
    }

    @Override
    public void go() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new BuilderThread();
            }
        };
    }

    @Override
    public int getLengthOfTask() {
        this.filesToDo = this.dataModel.getTotalFilesInSet();
        return this.filesToDo;
    }

    @Override
    public int getCurrent() {
        this.filesDone = this.dataModel.getNumberOfFilesUpdated();
        return this.filesDone;
    }

    protected static void setDone(boolean george) {
        allDone = george;
    }

    @Override
    public String getProgressMessage() {
        return new String("Read " + this.filesDone + " of " + this.filesToDo + " files.");
    }

    @Override
    public boolean done() {
        return allDone;
    }

    class BuilderThread {
        BuilderThread() {
            DFSDataModel.getDataModel().update(DFSDataModel.getDataModel().getFileSet());
            DataModelBuilder.setDone(true);
        }
    }
}

