/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import org.eso.cpl.CPLException;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.gui.ExtensionFileFilter;
import org.eso.cpl.gui.RecipeSelector;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.gasgano.gui.GUIUtils;
import org.eso.gasgano.gui.ListAdaptor;
import org.eso.gasgano.gui.PropertyEditorSubPanel;
import org.eso.gasgano.properties.GasProp;

public class RecipePropertyPanel
extends PropertyEditorSubPanel {
    private GasProp gpi;
    private LibraryLoader loader;
    private JTable table;
    private ListAdaptor model;
    private boolean edited = false;
    private static JFileChooser chooser;
    private List data;

    public RecipePropertyPanel(GasProp gp) {
        this.gpi = gp;
        this.data = RecipePropertyPanel.getRecipeList(this.gpi);
        this.model = new ListAdaptor(this.data, "Recipe Libraries"){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    int row = RecipePropertyPanel.this.table.rowAtPoint(new Point(e2.getX(), e2.getY()));
                    LibraryDescription lib = (LibraryDescription)RecipePropertyPanel.this.data.get(row);
                    RecipePropertyPanel.this.showRecipeSelector(lib);
                }
            }
        });
        JButton removeButton = new JButton(new AbstractAction("Remove Selected"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                RecipePropertyPanel.this.edited = true;
                RecipePropertyPanel.this.deleteSelectedLibrary(RecipePropertyPanel.this.table);
            }
        });
        JButton addButton = new JButton(new AbstractAction("Add Recipe"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                RecipePropertyPanel.this.findRecipe();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(addButton);
        buttons.add(removeButton);
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setVerticalScrollBarPolicy(22);
        JPanel tablePanel = new JPanel();
        tablePanel.setBorder(new TitledBorder("Recipe Configuration"));
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)scroller, "Center");
        tablePanel.add((Component)buttons, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)tablePanel, "North");
    }

    @Override
    public void loadProperties(GasProp gp) {
        this.gpi = gp;
        this.data = RecipePropertyPanel.getRecipeList(this.gpi);
        this.model.setData(this.data);
    }

    private static List getRecipeList(GasProp gp) {
        ArrayList<LibraryDescription> rc = new ArrayList<LibraryDescription>();
        Iterator i = gp.getRecipeLibraryNames();
        while (i.hasNext()) {
            String lib = (String)i.next();
            List recNames = gp.getRecipesForLibrary(lib);
            rc.add(new LibraryDescription(lib, recNames));
        }
        return rc;
    }

    @Override
    public String saveProperties() {
        String rc = null;
        if (this.edited) {
            StringBuffer prop = new StringBuffer();
            for (LibraryDescription d2 : this.data) {
                if (prop.length() != 0) {
                    prop.append(";");
                }
                prop.append(d2.toPropertyString());
            }
            this.gpi.setProperty("RECIPE_SET", prop.toString());
        }
        return rc;
    }

    @Override
    public int restartRequired() {
        return this.edited ? 2 : 0;
    }

    private LibraryLoader getLoader() throws LTDLException {
        if (this.loader == null) {
            this.loader = new LibraryLoader();
        }
        return this.loader;
    }

    private void releaseLoader() throws LTDLException {
        if (this.loader != null) {
            this.loader.close();
            this.loader = null;
        }
    }

    public void findRecipe() {
        if (chooser == null) {
            chooser = new SwingFileChooser();
            chooser.setFileFilter(new ExtensionFileFilter(this.getDLLExtension(), "CPL recipe libraries"));
            chooser.setMultiSelectionEnabled(true);
            chooser.setFileHidingEnabled(false);
        }
        if (chooser.showDialog(this, "OK") == 0) {
            this.showRecipeSelector(chooser.getSelectedFiles(), false);
        }
    }

    private void showRecipeSelector(LibraryDescription lib) {
        File dll = new File(lib.getLibraryName());
        if (!dll.exists()) {
            this.showError("Library " + lib.getLibraryName() + " could not be found.");
        } else {
            File[] dlls = new File[]{dll};
            this.showRecipeSelector(dlls, true);
        }
    }

    private void showRecipeSelector(File[] dlls, final boolean readOnly) {
        LibraryLoader l = null;
        final RecipeLibrary[] libs = new RecipeLibrary[dlls.length];
        boolean loadError = false;
        String msg = dlls.length == 1 ? "If the selected file is not a CPL Recipe Library,\nloading it may crash Gasgano.\nDo you wish to continue?" : "If the selected files are not CPL Recipe Libraries,\nloading them may crash Gasgano.\nDo you wish to continue?";
        if (JOptionPane.showConfirmDialog(this, msg, "Warning: Library Load", 2) != 0) {
            return;
        }
        File dll = null;
        try {
            l = this.getLoader();
            for (int i = 0; i < dlls.length; ++i) {
                dll = dlls[i];
                System.out.print("Loading " + dll.getName() + ": ");
                libs[i] = l.getLibrary(dll.getAbsoluteFile().getPath());
                System.out.println("OK");
            }
        }
        catch (LTDLException e2) {
            e2.printStackTrace();
            this.showWarning("Problem loading library: " + (dll != null ? "\n" + dll.toString() + "\n" : "") + e2.getMessage());
            loadError = true;
        }
        catch (CPLException e3) {
            e3.printStackTrace();
            this.showWarning("Problem loading library: " + (dll != null ? "\n" + dll.toString() + "\n" : "") + e3.getMessage());
            loadError = true;
        }
        catch (Error e4) {
            e4.printStackTrace();
            GUIUtils.userMessage(this, "Fatal Error", e4.getMessage());
            System.exit(-1);
        }
        if (!loadError) {
            final JFrame frame = new JFrame();
            Cursor orig = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            RecipeSelector rsel = new RecipeSelector(libs, !readOnly){

                @Override
                protected void approveSelection() {
                    Recipe recipe = this.getSelectedRecipe();
                    frame.dispose();
                    if (!readOnly) {
                        for (int i = 0; i < libs.length; ++i) {
                            RecipePropertyPanel.this.addLibrary(libs[i]);
                        }
                    }
                }

                @Override
                protected void cancelSelection() {
                    frame.dispose();
                }
            };
            StringBuffer title = new StringBuffer();
            if (libs.length == 0) {
                title.append("No Libraries Selected");
            }
            if (libs.length == 1) {
                title.append("Contents of " + libs[0].getName());
            } else {
                title.append("Library Contents");
            }
            if (libs.length > 0 && libs[0].getRecipes().length > 0 && rsel.getTree().getRowCount() > 1) {
                rsel.getTree().setSelectionRow(1);
            }
            frame.setTitle(title.toString());
            frame.getContentPane().add(rsel);
            frame.pack();
            GUIUtils.center(this, frame);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    frame.dispose();
                }
            });
            frame.setVisible(true);
            this.setCursor(orig);
        }
        if (l != null) {
            try {
                this.releaseLoader();
            }
            catch (LTDLException e5) {
                e5.printStackTrace();
                this.showWarning("Problem unloading library: " + e5.getMessage());
            }
        }
    }

    private String getDLLExtension() {
        String os = System.getProperty("os.name");
        String rc = os.equals("HP-UX") ? ".sl" : ".so";
        return rc;
    }

    private void deleteSelectedLibrary(JTable table) {
        int[] selRow = table.getSelectedRows();
        if (selRow.length == 0) {
            return;
        }
        Arrays.sort(selRow);
        for (int i = selRow.length - 1; i >= 0; --i) {
            ((ListAdaptor)table.getModel()).removeRow(selRow[i]);
        }
        this.edited = true;
    }

    private void addLibrary(RecipeLibrary lib) {
        ArrayList<String> recipes = new ArrayList<String>();
        for (int i = 0; i < lib.getRecipes().length; ++i) {
            recipes.add(lib.getRecipes()[i].getName());
        }
        ((ListAdaptor)this.table.getModel()).appendRow(new LibraryDescription(lib.getLocation(), recipes));
        this.edited = true;
    }

    private void showWarning(String warning) {
        JOptionPane.showMessageDialog(this, warning, "Warning", 0);
    }

    private void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error", 0);
    }

    static class LibraryDescription {
        private String libraryName;
        private List recipes;

        public LibraryDescription(String name, List recs) {
            this.libraryName = name;
            this.recipes = recs;
        }

        public String toString() {
            String dispLibName = this.libraryName;
            if (dispLibName.length() > 60) {
                dispLibName = dispLibName.substring(0, 25) + "......" + dispLibName.substring(dispLibName.length() - 26);
            }
            StringBuffer rc = new StringBuffer(dispLibName + "      ");
            for (int x = 0; x < this.recipes.size(); ++x) {
                if (x > 0) {
                    rc.append(", ");
                }
                rc.append(((String)this.recipes.get(x)).toUpperCase());
            }
            return rc.toString();
        }

        public String toPropertyString() {
            StringBuffer rc = new StringBuffer();
            for (int i = 0; i < this.recipes.size(); ++i) {
                if (i > 0) {
                    rc.append(",");
                }
                rc.append((String)this.recipes.get(i));
            }
            rc.append("=" + this.libraryName);
            return rc.toString();
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public List getRecipes() {
            return this.recipes;
        }
    }
}

