/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.properties;

import org.eso.gasgano.properties.PropertySource;

public class PropertyDB {
    private static PropertyDB instance;
    private PropertySource source;
    private int debugLevel = 0;
    public static final int debugDataModelChange = 1;
    public static final int debugDataModelEvent = 2;
    public static final int debugExternalCommands = 3;
    public static final int debugBaseName = 4;
    public static final int debugTiming = 5;
    public static final int debugEvent = 6;
    public static final int debugExpressionAndRules = 7;
    public static final int debugDatabase = 8;
    public static final int debugAll = 9;

    private PropertyDB() {
    }

    public static PropertyDB getInstance() {
        if (instance == null) {
            instance = new PropertyDB();
        }
        return instance;
    }

    public void setPropertySource(PropertySource s) {
        this.source = s;
    }

    public String getProperty(String name) {
        String rc = null;
        if (this.source != null) {
            rc = this.source.getProperty(name);
        }
        return rc;
    }

    public void setProperty(String name, String val) {
        if (this.source != null) {
            this.source.setProperty(name, val);
        }
    }

    public boolean isDebug(int specDebug) {
        boolean rc = false;
        if (this.getDebugLevel() == specDebug || this.getDebugLevel() == 9) {
            rc = true;
        }
        return rc;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int l) {
        this.debugLevel = l;
    }
}

