/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.viewers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class SkyCatConnection {
    private InetAddress address = null;
    private int port = -1;
    private int pid = -1;
    private int timeout = 20;
    public static final String RtdPortFile = ".rtd-remote";

    public SkyCatConnection() {
    }

    public SkyCatConnection(InetAddress addr, int pt) {
        this.setAddress(addr, pt);
    }

    public void setStartUpTimeout(int s) {
        this.timeout = s;
    }

    public int getStartUpTimeout() {
        return this.timeout;
    }

    public void setAddress(InetAddress addr, int pt) {
        this.address = addr;
        this.port = pt;
    }

    public int getPort() {
        return this.port;
    }

    public int getPid() {
        return this.pid;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void startSkyCat(String startCommand) throws IOException {
        String userHome = System.getProperties().getProperty("user.home");
        if (userHome == null || userHome.length() == 0) {
            throw new IOException("Could not determine user home directory, required to launch SkyCat.");
        }
        File rtdPortFile = new File(userHome + File.separatorChar + RtdPortFile);
        long lastMod = rtdPortFile.lastModified();
        SkyCatConnection.runCommand(startCommand, true);
        boolean running = false;
        int remainingSleep = this.timeout * 1000;
        long shortSleep = 500L;
        do {
            running = lastMod != rtdPortFile.lastModified();
            try {
                Thread.sleep(shortSleep);
                remainingSleep = (int)((long)remainingSleep - shortSleep);
            }
            catch (InterruptedException e2) {
                System.out.println("Warning: Exception during thread sleep.");
            }
        } while (remainingSleep > 0 && !running);
        if (!running) {
            throw new IOException("Timeout waiting for SkyCat to launch after waiting " + this.timeout + " seconds.");
        }
    }

    private static int runCommand(String command, boolean backGround) throws IOException {
        int rc = -1;
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(command);
        try {
            if (!backGround) {
                p.waitFor();
                rc = p.exitValue();
            }
        }
        catch (InterruptedException ie) {
            System.out.println("Interrupted while executing: " + ie.toString());
            throw new IOException(ie.getMessage());
        }
        catch (IllegalThreadStateException ie) {
            System.out.println("Interrupted while executing: " + ie.toString());
            throw new IOException(ie.getMessage());
        }
        return rc;
    }

    public void setAddressFromRTDFile() throws IOException {
        String userHome = System.getProperties().getProperty("user.home");
        if (userHome == null || userHome.length() == 0) {
            throw new IOException("Could not determine user home directory");
        }
        this.setAddressFromRTDFile(userHome + File.separatorChar + RtdPortFile);
    }

    public void setAddressFromRTDFile(String filePath) throws IOException {
        File theFile = new File(filePath);
        FileReader dataSource = null;
        try {
            dataSource = new FileReader(filePath);
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found: " + filePath);
        }
        BufferedReader br = new BufferedReader(dataSource);
        String s = br.readLine();
        dataSource.close();
        if (s == null) {
            throw new IOException("Error reading file: " + filePath);
        }
        StringTokenizer st = new StringTokenizer(s);
        if (st.countTokens() < 3) {
            throw new IOException("Unexpected data in file: " + filePath);
        }
        String pidStr = st.nextToken();
        String host = st.nextToken();
        String portStr = st.nextToken();
        try {
            this.port = Integer.parseInt(portStr);
            this.pid = Integer.parseInt(pidStr);
        }
        catch (NumberFormatException e2) {
            throw new IOException("Unable to read port or pid number from file: " + filePath);
        }
        try {
            this.address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e3) {
            throw new IOException("Unknown host: " + host);
        }
    }

    public Socket connect() throws IOException {
        return new Socket(this.address, this.port);
    }

    public String sendCommand(String command) throws IOException {
        int c2;
        command = command + "\n";
        StringBuffer rc = new StringBuffer();
        Socket s = this.connect();
        OutputStream out = s.getOutputStream();
        out.write(command.getBytes());
        out.flush();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(s.getInputStream()));
        while ((c2 = rdr.read()) != -1 && c2 != 10) {
            rc.append((char)c2);
        }
        rdr.close();
        out.close();
        s.close();
        System.out.println("SkyCat Request :" + command);
        System.out.println("SkyCat Response:" + rc.toString());
        return rc.toString();
    }

    public boolean isSkyCatRunning() throws IOException {
        boolean rc = false;
        if (this.pid == -1 || this.port == -1 || this.address == null) {
            throw new IOException("Insufficient data to determine if SkyCat is running.");
        }
        if (SkyCatConnection.runCommand("/bin/ps -p " + this.pid, false) == 0) {
            try {
                Socket conn = this.connect();
                conn.close();
                rc = true;
            }
            catch (IOException e2) {
                rc = false;
            }
        }
        return rc;
    }

    public void sendFile(String fullPathToFile) throws IOException {
        this.sendCommand("config -file " + fullPathToFile);
    }

    public static void main(String[] args) {
        SkyCatConnection c2 = new SkyCatConnection();
        try {
            c2.setAddressFromRTDFile("//K:/.rtd-remote");
            System.out.println("Result from command: " + c2.sendCommand("config -file /home/nkornwei/fits/2001-02-11/r.UVES.2001-02-12T06:32:26.522_0002.fits"));
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
        }
        System.out.println("Connection: " + c2.getAddress() + " port: " + c2.getPort());
    }
}

