/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.FileEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.eso.util.archive.MimeType;
import org.eso.util.archive.NgasHost;
import org.eso.util.archive.Pair;

public abstract class PostTask
implements Callable<Pair<String, File>> {
    static final Logger logger = Logger.getLogger(PostTask.class);
    protected HttpClient httpClient;
    protected NgasHost host;
    protected File file;
    protected String command;
    protected String mimeType = MimeType.AUTO.toString();
    protected String fileId = null;
    protected Integer version = null;

    public PostTask(HttpClient httpClient, NgasHost host, File file) {
        this.httpClient = httpClient;
        this.host = host;
        this.file = file;
    }

    @Override
    public Pair<String, File> call() throws Exception {
        HttpPost post = new HttpPost("http://" + this.host.host + ":" + this.host.port + "/" + this.command);
        post.addHeader("User-Agent", "NG/AMS J-API");
        post.addHeader("Content-Type", this.mimeType.toString());
        post.addHeader("Content-Disposition", this.createContentDisposition());
        FileEntity entity = new FileEntity(this.file, this.mimeType.toString());
        post.setEntity(entity);
        logger.debug("Executing request " + post.getRequestLine());
        try {
            HttpResponse response = this.httpClient.execute(post);
            HttpEntity resEntity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            String ngasStatus = EntityUtils.toString(resEntity);
            entity.getContent().close();
            if (statusCode == 200) {
                return null;
            }
            throw new ClientProtocolException(ngasStatus);
        }
        catch (Exception e2) {
            throw new Exception("Error while archiving " + this.file.getAbsolutePath() + " to " + this.host + ". " + e2.getMessage());
        }
    }

    protected abstract String createContentDisposition() throws IOException;
}

