/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eso.util.configuration.Configuration;
import org.eso.util.configuration.ConfigurationOption;
import org.eso.util.filesystem.FileSystemOperations;
import org.eso.util.misc.WrappedString;

final class PropertyHandler {
    static final Logger logger = Logger.getLogger(PropertyHandler.class);
    private static final String classLogName = "PropertyHandler";

    private PropertyHandler() {
        String methodLogName = "PropertyHandler::PropertyHandler()";
        logger.trace("PropertyHandler::PropertyHandler()");
    }

    static boolean loadApplicationProperties(File propertyFile, Configuration configuration) throws NullPointerException {
        FileInputStream inputStream;
        String methodLogName = "PropertyHandler::loadApplicationProperties()";
        logger.trace("PropertyHandler::loadApplicationProperties()");
        if (propertyFile == null || configuration == null) {
            String message = "PropertyHandler::loadApplicationProperties() - propertyFile [" + propertyFile + "] and configuration [" + configuration + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        try {
            inputStream = new FileInputStream(propertyFile);
        }
        catch (Exception e2) {
            logger.error("PropertyHandler::loadApplicationProperties() - unable to open property file [" + propertyFile + "].");
            return false;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (Exception e3) {
            logger.error("PropertyHandler::loadApplicationProperties() - unable to load properties from file [" + propertyFile + "].");
            return false;
        }
        return PropertyHandler.loadProperties(properties, 2, propertyFile, configuration);
    }

    static boolean loadSystemProperties(Configuration configuration) throws NullPointerException {
        String methodLogName = "PropertyHandler::loadSystemProperties()";
        logger.trace("PropertyHandler::loadSystemProperties()");
        if (configuration == null) {
            String message = "PropertyHandler::loadSystemProperties() - configuration must not be null.";
            logger.fatal("PropertyHandler::loadSystemProperties() - configuration must not be null.");
            throw new NullPointerException("PropertyHandler::loadSystemProperties() - configuration must not be null.");
        }
        Properties systemProperties = System.getProperties();
        return PropertyHandler.loadProperties(systemProperties, 4, null, configuration);
    }

    static boolean loadProperties(Properties properties, Configuration configuration) throws NullPointerException {
        String methodLogName = "PropertyHandler::loadProperties(Properties, Configuration)";
        logger.trace("PropertyHandler::loadProperties(Properties, Configuration)");
        if (properties == null || configuration == null) {
            String message = "PropertyHandler::loadProperties(Properties, Configuration) - properties [" + properties + "] and configuration [" + configuration + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        return PropertyHandler.loadProperties(properties, 16, null, configuration);
    }

    private static boolean loadProperties(Properties properties, int valueSource, File propertyFile, Configuration configuration) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "PropertyHandler::loadProperties(Properties, int, File, Configuration)";
        logger.trace("PropertyHandler::loadProperties(Properties, int, File, Configuration)");
        if (properties == null || configuration == null) {
            String message = "PropertyHandler::loadProperties(Properties, int, File, Configuration) - properties [" + properties + "] and configuration [" + configuration + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        int acceptableValueSources = 22;
        if ((valueSource & 0x16) == 0 || !ConfigurationOption.isSingleDefinedValueSource(valueSource)) {
            String message = "PropertyHandler::loadProperties(Properties, int, File, Configuration) - valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] must be one of: " + ConfigurationOption.getValueSourceString(22) + ".";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        logger.debug("PropertyHandler::loadProperties(Properties, int, File, Configuration) - loading properties.");
        Map<String, ConfigurationOption> optionMap = configuration.getSelectedOptionMap(valueSource);
        Iterator<ConfigurationOption> optionIterator = optionMap.values().iterator();
        ConfigurationOption currentOption = null;
        String propertyValue = null;
        Object optionValue = null;
        while (optionIterator.hasNext()) {
            currentOption = optionIterator.next();
            if (!ConfigurationOption.canOverrideValueSource(valueSource, currentOption.getActualValueSource())) {
                logger.debug("PropertyHandler::loadProperties(Properties, int, File, Configuration) - ignoring option [" + currentOption.optionName + "] which already has a higher priority [" + ConfigurationOption.getValueSourceString(currentOption.getActualValueSource()) + "] value than [" + ConfigurationOption.getValueSourceString(valueSource) + "].");
                continue;
            }
            propertyValue = properties.getProperty(currentOption.propertyName);
            if (propertyValue == null) {
                logger.debug("PropertyHandler::loadProperties(Properties, int, File, Configuration) - these properties do not provide a value for option [" + currentOption.optionName + "].");
                continue;
            }
            propertyValue = propertyValue.trim();
            switch (currentOption.optionType) {
                case 1: {
                    optionValue = propertyValue;
                    break;
                }
                case 2: {
                    optionValue = Boolean.valueOf(propertyValue);
                    break;
                }
                case 3: {
                    try {
                        optionValue = Integer.valueOf(propertyValue);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("PropertyHandler::loadProperties(Properties, int, File, Configuration) - the value [" + propertyValue + "] specified by property [" + currentOption.propertyName + "] from source [" + ConfigurationOption.getValueSourceString(valueSource) + "] could not be parsed [" + nfe.getMessage() + "] as a value of type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] for option [" + currentOption.optionName + "].");
                        return false;
                    }
                }
                default: {
                    String message = "PropertyHandler::loadProperties(Properties, int, File, Configuration) - configuration option [" + currentOption.optionName + "] type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] not recognised.";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            logger.debug("PropertyHandler::loadProperties(Properties, int, File, Configuration) - setting option [" + currentOption.optionName + "] from property [" + currentOption.propertyName + "].");
            currentOption.setActualValue(optionValue, valueSource, propertyFile);
        }
        logger.debug("PropertyHandler::loadProperties(Properties, int, File, Configuration) - all relevant properties successfully loaded.");
        return true;
    }

    static void printSystemPropertyHelpMessage(Configuration configuration) throws NullPointerException {
        String methodLogName = "PropertyHandler::printSystemPropertyHelpMessage()";
        logger.trace("PropertyHandler::printSystemPropertyHelpMessage()");
        if (configuration == null) {
            String message = "PropertyHandler::printSystemPropertyHelpMessage() - configuration must not be null.";
            logger.fatal("PropertyHandler::printSystemPropertyHelpMessage() - configuration must not be null.");
            throw new NullPointerException("PropertyHandler::printSystemPropertyHelpMessage() - configuration must not be null.");
        }
        logger.debug("PropertyHandler::printSystemPropertyHelpMessage() - printing system property help message to standard output.");
        Map<String, ConfigurationOption> optionMap = configuration.getSelectedOptionMap(4);
        Iterator<ConfigurationOption> optionMapIterator = optionMap.values().iterator();
        TreeSet<String> mandatorySet = new TreeSet<String>();
        TreeSet<String> additionalSet = new TreeSet<String>();
        ConfigurationOption currentOption = null;
        String currentText = null;
        Object parameterTypeString = null;
        while (optionMapIterator.hasNext()) {
            currentOption = optionMapIterator.next();
            currentText = "";
            currentText = currentText + currentOption.propertyName + "=";
            switch (currentOption.optionType) {
                case 1: 
                case 3: {
                    currentText = currentText + ConfigurationOption.getTypeString(currentOption.optionType) + "\n";
                    break;
                }
                case 2: {
                    currentText = currentText + "true|false\n";
                    break;
                }
                default: {
                    String message = "PropertyHandler::printSystemPropertyHelpMessage() - configuration option [" + currentOption.optionName + "] type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] not recognised.";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            if (ConfigurationOption.isValidValueSource(1, currentOption.validValueSources)) {
                currentText = currentText + new WrappedString("  ", "Default value [" + currentOption.defaultValue + "].") + "\n";
            }
            if (!currentOption.helpText.equals("")) {
                currentText = currentText + new WrappedString("    ", currentOption.helpText) + "\n";
            }
            if (currentOption.validValueSources == 4) {
                mandatorySet.add(currentText);
                continue;
            }
            additionalSet.add(currentText);
        }
        boolean mandatoryProperties = !mandatorySet.isEmpty();
        boolean additionalProperties = !additionalSet.isEmpty();
        System.out.print("SYSTEM PROPERTIES");
        if (!mandatoryProperties && !additionalProperties) {
            System.out.print(": this application has no system properties.");
        }
        System.out.print("\n\n");
        if (mandatoryProperties) {
            System.out.print("Mandatory properties:\n\n");
            Iterator mandatoryIterator = mandatorySet.iterator();
            while (mandatoryIterator.hasNext()) {
                System.out.print((String)mandatoryIterator.next() + "\n");
            }
        }
        if (additionalProperties) {
            if (mandatoryProperties) {
                System.out.print("Additional properties:\n\n");
            }
            Iterator additionalIterator = additionalSet.iterator();
            while (additionalIterator.hasNext()) {
                System.out.print((String)additionalIterator.next() + "\n");
            }
        }
        logger.debug("PropertyHandler::printSystemPropertyHelpMessage() - successfully printed system property help message to standard output.");
    }

    static boolean createTemplatePropertyFile(File outputFile, Configuration configuration) throws NullPointerException {
        String methodLogName = "PropertyHandler::createTemplatePropertyFile()";
        logger.trace("PropertyHandler::createTemplatePropertyFile()");
        if (outputFile == null || configuration == null) {
            String message = "PropertyHandler::createTemplatePropertyFile() - outputFile [" + outputFile + "] and configuration [" + configuration + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (FileSystemOperations.exists(outputFile)) {
            logger.error("PropertyHandler::createTemplatePropertyFile() - file [" + outputFile + "] already exists.");
            return false;
        }
        logger.debug("PropertyHandler::createTemplatePropertyFile() - generating template property file [" + outputFile + "].");
        Map<String, ConfigurationOption> optionMap = configuration.getSelectedOptionMap(2);
        Iterator<ConfigurationOption> optionIterator = optionMap.values().iterator();
        TreeMap<String, String> mandatoryMap = new TreeMap<String, String>();
        TreeMap<String, String> additionalMap = new TreeMap<String, String>();
        ConfigurationOption currentOption = null;
        String currentText = null;
        while (optionIterator.hasNext()) {
            currentOption = optionIterator.next();
            currentText = "";
            if (!ConfigurationOption.isValidValueSource(2, currentOption.validValueSources)) {
                logger.debug("PropertyHandler::createTemplatePropertyFile() - ignoring non-property file option [" + currentOption.optionName + "].");
                continue;
            }
            if (!currentOption.helpText.equals("")) {
                currentText = currentText + currentOption.helpText + "\n\n";
            }
            if (ConfigurationOption.isValidValueSource(1, currentOption.validValueSources)) {
                currentText = currentText + "Default value [" + currentOption.defaultValue + "].\n\n";
            }
            currentText = currentText + currentOption.propertyName + "=";
            switch (currentOption.optionType) {
                case 1: 
                case 3: {
                    currentText = currentText + ConfigurationOption.getTypeString(currentOption.optionType);
                    break;
                }
                case 2: {
                    currentText = currentText + "true|false";
                    break;
                }
                default: {
                    String message = "PropertyHandler::createTemplatePropertyFile() - configuration option [" + currentOption.optionName + "] type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] not recognised.";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            if (currentOption.validValueSources == 2) {
                mandatoryMap.put(currentOption.propertyName, new WrappedString("# ", currentText) + "\n\n");
                continue;
            }
            additionalMap.put(currentOption.propertyName, new WrappedString("# ", currentText) + "\n\n");
        }
        boolean mandatoryProperties = !mandatoryMap.isEmpty();
        boolean additionalProperties = !additionalMap.isEmpty();
        currentText = "TEMPLATE CONFIGURATION FILE\n\n" + configuration.getString("application.name") + " version: " + configuration.getString("application.version") + "\n\n";
        currentText = currentText + "This file was generated with all properties commented out.";
        if (!configuration.getString("application.help.header.text").equals("")) {
            currentText = currentText + "\n\n" + configuration.getString("application.help.header.text");
        }
        if (!configuration.getString("application.help.footer.text").equals("")) {
            currentText = currentText + "\n\n" + configuration.getString("application.help.footer.text");
        }
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append(new WrappedString("# ", currentText) + "\n\n");
        if (mandatoryProperties) {
            templateBuffer.append(new WrappedString("# ", "MANDATORY PROPERTIES") + "\n\n");
            Iterator mandatoryIterator = mandatoryMap.values().iterator();
            while (mandatoryIterator.hasNext()) {
                templateBuffer.append((String)mandatoryIterator.next());
            }
        }
        if (additionalProperties) {
            if (mandatoryProperties) {
                templateBuffer.append(new WrappedString("# ", "ADDITIONAL PROPERTIES") + "\n\n");
            }
            Iterator additionalIterator = additionalMap.values().iterator();
            while (additionalIterator.hasNext()) {
                templateBuffer.append((String)additionalIterator.next());
            }
        }
        if (!FileSystemOperations.writeStringToFile(templateBuffer.toString(), false, outputFile)) {
            logger.error("PropertyHandler::createTemplatePropertyFile() - unable to write template property file [" + outputFile + "].");
            return false;
        }
        logger.debug("PropertyHandler::createTemplatePropertyFile() - successfully generated template property file [" + outputFile + "].");
        return true;
    }
}

