/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.NgasDisk;
import org.eso.util.dal.NgasFile;
import org.eso.util.dal.NgasFileDAOSyb;
import org.eso.util.dal.SybaseConnectionService;

public class FileIngestionService {
    static final Logger logger = Logger.getLogger(FileIngestionService.class);
    private static final String thisClass = "FileIngestionService";
    private String d_dbUrl = null;
    private String d_dbUsername = null;
    private String d_dbPassword = null;
    private String d_dbDiskTable = null;
    private String d_dbFileTable = null;

    public FileIngestionService(String dbUrl, String dbUsername, String dbPassword, String dbDiskTable, String dbFileTable) {
        this.d_dbUrl = dbUrl;
        this.d_dbUsername = dbUsername;
        this.d_dbPassword = dbPassword;
        this.d_dbDiskTable = dbDiskTable;
        this.d_dbFileTable = dbFileTable;
    }

    public void ingestIntoDb(NgasFile file, NgasDisk disk) throws DAOException {
        logger.trace("FileIngestionService::ingestionIntoDb()");
        Connection conn = null;
        try {
            conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
            logger.debug("Creating file dao syb");
            NgasFileDAOSyb fileDAO = new NgasFileDAOSyb(conn, this.d_dbFileTable);
            conn.setAutoCommit(false);
            logger.debug("ingesting file " + file.getFileName());
            fileDAO.save(file);
            conn.commit();
            logger.debug("Transaction committed");
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (SQLException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (DAOException e4) {
            try {
                conn.rollback();
                String message = "Error while ingesting file " + file.getFileId() + " on disk " + disk.getDiskId() + ": " + e4.getMessage();
                throw new DAOException(message);
            }
            catch (SQLException ex) {
                throw new DAOException(ex.getMessage());
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    SybaseConnectionService.closeConnection(conn);
                }
                catch (ConnectionServiceException ex) {
                    throw new DAOException(ex.getMessage());
                }
                catch (SQLException ex) {
                    throw new DAOException(ex.getMessage());
                }
            }
        }
    }
}

