/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.NgasFileSafe;
import org.eso.util.dal.NgasFileSafeDAO;
import org.eso.util.dal.SybaseConnectionService;

public class NgasFileSafeDAOSyb
implements NgasFileSafeDAO {
    static final Logger logger = Logger.getLogger(NgasFileSafeDAOSyb.class);
    private String d_dbUrl = null;
    private String d_dbUsername = null;
    private String d_dbPassword = null;
    private String d_dbTable = null;
    private Connection d_connection = null;

    public NgasFileSafeDAOSyb(String dbUrl, String dbUsername, String dbPassword, String dbTable) {
        this.d_dbUrl = dbUrl;
        this.d_dbUsername = dbUsername;
        this.d_dbPassword = dbPassword;
        this.d_dbTable = dbTable;
    }

    public NgasFileSafeDAOSyb(Connection connection, String dbTable) {
        this.d_connection = connection;
        this.d_dbTable = dbTable;
    }

    @Override
    public void delete(NgasFileSafe ngasFile) throws DAOException {
        throw new DAOException("Method not implemented yet");
    }

    @Override
    public List<NgasFileSafe> findAll() throws DAOException {
        throw new DAOException("Method not implemented yet");
    }

    @Override
    public List<NgasFileSafe> findByFileId(String fileId) throws DAOException {
        return this.findByFileIdAndVersion(fileId, 1);
    }

    @Override
    public List<NgasFileSafe> findByFileIdAndVersion(String fileId, Integer version) throws DAOException {
        String query = "select * from " + this.d_dbTable + " where file_id='" + fileId + "' and file_version=" + version;
        return this.executeQuery(query);
    }

    @Override
    public List<NgasFileSafe> findByFileIdIgnoreVersion(String fileId) throws DAOException {
        String query = "select * from " + this.d_dbTable + " where file_id='" + fileId + "'";
        return this.executeQuery(query);
    }

    @Override
    public void save(NgasFileSafe ngasFile) throws DAOException {
        throw new DAOException("Method not implemented yet");
    }

    @Override
    public boolean saveIfNotFound(NgasFileSafe ngasFile) throws DAOException {
        throw new DAOException("Method not implemented yet");
    }

    @Override
    public void update(NgasFileSafe ngasFile) throws DAOException {
        throw new DAOException("Method not implemented yet");
    }

    private List<NgasFileSafe> executeQuery(String query) throws DAOException {
        try {
            List<NgasFileSafe> res = null;
            if (this.d_connection == null) {
                Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                res = NgasFileSafeDAOSyb.toNgasFileSafeList(SybaseConnectionService.executeStatement(conn, query));
                SybaseConnectionService.closeConnection(conn);
            } else {
                res = NgasFileSafeDAOSyb.toNgasFileSafeList(SybaseConnectionService.executeStatement(this.d_connection, query));
            }
            return res;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    public static List<NgasFileSafe> toNgasFileSafeList(ResultSet rs) throws DAOException {
        ArrayList<NgasFileSafe> res = new ArrayList<NgasFileSafe>();
        try {
            while (rs.next()) {
                NgasFileSafe file = new NgasFileSafe();
                file.setFileId(rs.getString("file_id"));
                file.setIngestionDate(rs.getDate("ingestion_date"));
                file.setFileVersion(rs.getInt("file_version"));
                res.add(file);
            }
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return res;
    }

    public static void main(String[] args) {
        NgasFileSafeDAOSyb dao = new NgasFileSafeDAOSyb("acdbdev.hq.eso.org:6789", "ngas", "ngas_pw", "ngastst1..ngas_files_safe");
        try {
            for (NgasFileSafe f : dao.findByFileIdAndVersion("prova", 2)) {
                System.out.println(f.toString());
            }
            for (NgasFileSafe f : dao.findByFileId("prova")) {
                System.out.println(f.toString());
            }
        }
        catch (DAOException e2) {
            System.out.println(e2.getMessage());
        }
    }
}

