/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.io.File;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.dal.DefaultTransferRequestValidator;

public class TransferRequest
implements Cloneable {
    static final Logger logger = Logger.getLogger(TransferRequest.class);
    public static final String RAW_FILE_CATG = "rawfile";
    public static final String TOO_CATG = "too";
    public static final String MULTI_FILE_CATG = "multifile";
    public static final String HEADER_FILE_CATG = "header";
    public static final String TRANSFER_METHOD_DISK = "disk";
    public static final String TRANSFER_METHOD_NETWORK = "network";
    public static final String TRANSFER_METHOD_ALL = "network_disk";
    public static final String COMPRESSION_METHOD_NONE = "none";
    public static final String COMPRESSION_METHOD_UNIXCOMPRESS = "unixcompress";
    private String requestId = null;
    private String fileId = null;
    private String fileName = null;
    private String uncompressedFileName = null;
    private String transferMethod = null;
    private Integer transferPriority = null;
    private String compressionMethod = null;
    private Long size = null;
    private Long uncompressedSize = null;
    private String checksum = null;
    private String transferCatg = null;
    private String user = null;
    private String destDir = null;
    private String multiFileComponents = null;
    private Long creationTime = null;
    private Long lastUpdateTime = null;
    private Status status = null;
    private File location;

    public static String getAllCatg() {
        String trCatg = "rawfile too multifile header";
        return trCatg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUncompressedFileName() {
        return this.uncompressedFileName;
    }

    public void setUncompressedFileName(String uncompressedFileName) {
        this.uncompressedFileName = uncompressedFileName;
    }

    public String getTransferMethod() {
        return this.transferMethod;
    }

    public void setTransferMethod(String transferMethod) {
        this.transferMethod = transferMethod;
    }

    public Integer getTransferPriority() {
        return this.transferPriority;
    }

    public void setTransferPriority(Integer transferPriority) {
        this.transferPriority = transferPriority;
    }

    public String getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(String compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(Long uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getTransferCatg() {
        return this.transferCatg;
    }

    public void setTransferCatg(String transferCatg) {
        this.transferCatg = transferCatg;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getMultiFileComponents() {
        return this.multiFileComponents;
    }

    public void setMultiFileComponents(String multiFileComponents) {
        this.multiFileComponents = multiFileComponents;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public Long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String toString() {
        String res = "Transfer request instance: ";
        res = res + "\n\tfileId " + this.fileId;
        res = res + "\n\tfileName " + this.fileName;
        res = res + "\n\tuncompressedFileName " + this.uncompressedFileName;
        res = res + "\n\ttransferMethod " + this.transferMethod;
        res = res + "\n\ttransferPriority " + this.transferPriority;
        res = res + "\n\tcompressionMethod " + this.compressionMethod;
        res = res + "\n\tsize " + this.size;
        res = res + "\n\tuncompressedSize " + this.uncompressedSize;
        res = res + "\n\tchecksum " + this.checksum;
        res = res + "\n\ttransferCatg " + this.transferCatg;
        res = res + "\n\tuser " + this.user;
        res = res + "\n\tdestDir " + this.destDir;
        res = res + "\n\tmultiFileComponents " + this.multiFileComponents;
        res = res + "\n\tcreation  time " + this.creationTime;
        return res;
    }

    public TransferRequest clone() {
        TransferRequest trCopy = new TransferRequest();
        if (this.requestId != null) {
            trCopy.requestId = this.requestId;
        }
        if (this.fileId != null) {
            trCopy.fileId = this.fileId;
        }
        if (this.fileName != null) {
            trCopy.fileName = this.fileName;
        }
        if (this.uncompressedFileName != null) {
            trCopy.uncompressedFileName = this.uncompressedFileName;
        }
        if (this.transferMethod != null) {
            trCopy.transferMethod = this.transferMethod;
        }
        if (this.transferPriority != null) {
            trCopy.transferPriority = new Integer(this.transferPriority);
        }
        if (this.compressionMethod != null) {
            trCopy.compressionMethod = trCopy.compressionMethod;
        }
        if (this.size != null) {
            trCopy.size = new Long(this.size);
        }
        if (this.uncompressedSize != null) {
            trCopy.uncompressedSize = new Long(this.uncompressedSize);
        }
        if (this.checksum != null) {
            trCopy.checksum = this.checksum;
        }
        if (this.transferCatg != null) {
            trCopy.transferCatg = this.transferCatg;
        }
        if (this.user != null) {
            trCopy.user = this.user;
        }
        if (this.destDir != null) {
            trCopy.destDir = this.destDir;
        }
        if (this.multiFileComponents != null) {
            trCopy.multiFileComponents = this.multiFileComponents;
        }
        if (this.status != null) {
            trCopy.status = this.status;
        }
        if (this.creationTime != null) {
            trCopy.creationTime = new Long(this.creationTime);
        }
        return trCopy;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        DefaultTransferRequestValidator trValidator = new DefaultTransferRequestValidator();
        logger.info("Set of tests on the TransferRequest class");
        TransferRequest transferRequest = new TransferRequest();
        logger.info("Case 1 : Is transfer request without validator valid : " + trValidator.isValid(transferRequest));
        logger.info("Case 2 : Is transfer request with validator but no field set valid : " + trValidator.isValid(transferRequest));
        transferRequest.setFileId("FILEID");
        transferRequest.setFileName("FILENAME");
        transferRequest.setSize(new Long(1000L));
        logger.info("Case 3 : Is transfer request with validator and required field set valid : " + trValidator.isValid(transferRequest));
        logger.info("Transfer Request fileId " + transferRequest.getFileId() + ",filename " + transferRequest.getFileName() + ",size " + transferRequest.getSize());
        TransferRequest tr = new TransferRequest();
        tr.setFileId("FILEID");
        tr.setFileName("FILENAME");
        tr.setSize(new Long(1000L));
        TransferRequest trCopy = tr.clone();
        if (trCopy.getFileId().compareTo(tr.getFileId()) == 0 && trCopy.getFileName().compareTo(tr.getFileName()) == 0 && trCopy.getSize().compareTo(tr.getSize()) == 0) {
            logger.info("SUCCESSFUL Test clone ");
        } else {
            logger.error("FAILED testClone ");
        }
    }

    public static enum FIELDS {
        REQUEST_ID,
        FILE_ID,
        FILE_NAME,
        UNCOMPRESSED_FILE_NAME,
        TRANSFER_METHOD,
        TRANSFER_PRIORITY,
        COMPRESSION_METHOD,
        SIZE,
        UNCOMPRESSED_SIZE,
        CHECKSUM,
        TRANSFER_CATG,
        USER,
        DEST_DIR,
        MULTI_FILES_COMPONENT,
        SUBMISSION_TIME,
        CREATION_TIME,
        STATUS,
        LAST_UPDATE_TIME;

    }

    public static enum Status {
        INCOMING,
        PROCESSING,
        PROCESSED,
        REJECTED,
        SUBMITTED,
        TRANSFERRED,
        ARCHIVED,
        UNKNOWN,
        ALL;

    }
}

