/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.misc;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eso.util.misc.StreamConsumptionThread;

public class StreamConsumer {
    static final Logger logger = Logger.getLogger(StreamConsumer.class);
    private static final String classLogName = "StreamConsumer";
    private final StreamConsumptionThread thread;

    public StreamConsumer() {
        String methodLogName = "StreamConsumer::StreamConsumer()";
        logger.trace("StreamConsumer::StreamConsumer()");
        this.thread = new StreamConsumptionThread(null);
    }

    public StreamConsumer(String threadName) throws NullPointerException {
        String methodLogName = "StreamConsumer::StreamConsumer(String)";
        logger.trace("StreamConsumer::StreamConsumer(String)");
        if (threadName == null) {
            String message = "StreamConsumer::StreamConsumer(String) - threadName must not be null.";
            logger.fatal("StreamConsumer::StreamConsumer(String) - threadName must not be null.");
            throw new NullPointerException("StreamConsumer::StreamConsumer(String) - threadName must not be null.");
        }
        this.thread = new StreamConsumptionThread(threadName);
    }

    public StreamConsumer(InputStream inputStream) throws NullPointerException {
        String methodLogName = "StreamConsumer::StreamConsumer(InputStream)";
        logger.trace("StreamConsumer::StreamConsumer(InputStream)");
        this.thread = new StreamConsumptionThread(null);
        this.thread.consumeStream(inputStream);
    }

    public StreamConsumer(InputStream inputStream, String threadName) throws NullPointerException {
        String methodLogName = "StreamConsumer::StreamConsumer(InputStream, String)";
        logger.trace("StreamConsumer::StreamConsumer(InputStream, String)");
        if (threadName == null) {
            String message = "StreamConsumer::StreamConsumer(InputStream, String) - threadName must not be null.";
            logger.fatal("StreamConsumer::StreamConsumer(InputStream, String) - threadName must not be null.");
            throw new NullPointerException("StreamConsumer::StreamConsumer(InputStream, String) - threadName must not be null.");
        }
        this.thread = new StreamConsumptionThread(threadName);
        this.thread.consumeStream(inputStream);
    }

    public void consumeStream(InputStream inputStream) throws IllegalStateException, NullPointerException {
        String methodLogName = "StreamConsumer::consumeStream()";
        logger.trace("StreamConsumer::consumeStream()");
        this.thread.consumeStream(inputStream);
    }

    public boolean isConsumingStream() {
        String methodLogName = "StreamConsumer::isConsumingStream()";
        logger.trace("StreamConsumer::isConsumingStream()");
        return this.thread.isConsumingStream();
    }

    public InputStream getInputStream() {
        String methodLogName = "StreamConsumer::getInputStream()";
        logger.trace("StreamConsumer::getInputStream()");
        return this.thread.getInputStream();
    }

    public boolean good() {
        String methodLogName = "StreamConsumer::good()";
        logger.trace("StreamConsumer::good()");
        return this.thread.good();
    }

    public void awaitStreamConsumption() {
        String methodLogName = "StreamConsumer::awaitStreamConsumption()";
        logger.trace("StreamConsumer::awaitStreamConsumption()");
        this.thread.awaitStreamConsumption();
    }

    public String getConsumedString() {
        String methodLogName = "StreamConsumer::getConsumedString()";
        logger.trace("StreamConsumer::getConsumedString()");
        return this.thread.getConsumedString();
    }

    synchronized void abortStreamConsumption() {
        String methodLogName = "StreamConsumer::abortStreamConsumption()";
        logger.trace("StreamConsumer::abortStreamConsumption()");
        this.thread.abortStreamConsumption();
    }

    public void finalize() {
        String methodLogName = "StreamConsumer::finalize()";
        logger.trace("StreamConsumer::finalize()");
        logger.debug("StreamConsumer::finalize() - finalising.");
        this.thread.terminate();
    }
}

