/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.misc;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.eso.util.misc.StreamConsumer;
import org.eso.util.misc.ThreadWatchdog;

public class SystemCommand {
    static final Logger logger = Logger.getLogger(SystemCommand.class);
    private static final String classLogName = "SystemCommand";
    private boolean newSystemCommand = true;
    private volatile String commandLine = null;
    private volatile File workingDirectory = null;
    private volatile long timeout = 0L;
    private volatile boolean timeoutCounting = false;
    private volatile ThreadWatchdog.Interrupt interrupt = null;
    private volatile boolean isExecuting = false;
    private final Semaphore commandResultPermit = new Semaphore(0);
    private final StreamConsumer standardOutputConsumer;
    private String standardOutputString = "";
    private final StreamConsumer standardErrorConsumer;
    private String standardErrorString = "";
    private int exitStatus = 0;

    public SystemCommand() {
        String methodLogName = "SystemCommand::SystemCommand()";
        logger.trace("SystemCommand::SystemCommand()");
        this.standardOutputConsumer = new StreamConsumer();
        this.standardErrorConsumer = new StreamConsumer();
    }

    public SystemCommand(String commandLine) throws NullPointerException {
        String methodLogName = "SystemCommand::SystemCommand(String)";
        logger.trace("SystemCommand::SystemCommand(String)");
        this.standardOutputConsumer = new StreamConsumer();
        this.standardErrorConsumer = new StreamConsumer();
        this.setCommandLine(commandLine);
    }

    public SystemCommand(File workingDirectory, String commandLine) throws NullPointerException {
        String methodLogName = "SystemCommand::SystemCommand(File, String)";
        logger.trace("SystemCommand::SystemCommand(File, String)");
        this.standardOutputConsumer = new StreamConsumer();
        this.standardErrorConsumer = new StreamConsumer();
        this.setCommandLine(commandLine);
        this.setWorkingDirectory(workingDirectory);
    }

    public SystemCommand(File workingDirectory, String commandLine, long timeout) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "SystemCommand::SystemCommand(File, String, String)";
        logger.trace("SystemCommand::SystemCommand(File, String, String)");
        this.standardOutputConsumer = new StreamConsumer();
        this.standardErrorConsumer = new StreamConsumer();
        this.setCommandLine(commandLine);
        this.setWorkingDirectory(workingDirectory);
        this.setTimeout(timeout);
    }

    public SystemCommand(File workingDirectory, String commandLine, long timeout, String threadNamePrefix) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "SystemCommand::SystemCommand(File, String, String)";
        logger.trace("SystemCommand::SystemCommand(File, String, String)");
        if (threadNamePrefix == null) {
            String message = "SystemCommand::SystemCommand(File, String, String) - threadNamePrefix must not be null.";
            logger.fatal("SystemCommand::SystemCommand(File, String, String) - threadNamePrefix must not be null.");
            throw new NullPointerException("SystemCommand::SystemCommand(File, String, String) - threadNamePrefix must not be null.");
        }
        this.standardOutputConsumer = new StreamConsumer(threadNamePrefix + "[STDOUT]");
        this.standardErrorConsumer = new StreamConsumer(threadNamePrefix + "[STDERR]");
        this.setCommandLine(commandLine);
        this.setWorkingDirectory(workingDirectory);
        this.setTimeout(timeout);
    }

    public String getCommandLine() {
        String methodLogName = "SystemCommand::getCommandLine()";
        logger.trace("SystemCommand::getCommandLine()");
        return this.commandLine;
    }

    public synchronized void setCommandLine(String commandLine) throws NullPointerException {
        String methodLogName = "SystemCommand::setCommandLine()";
        logger.trace("SystemCommand::setCommandLine()");
        if (commandLine == null) {
            String message = "SystemCommand::setCommandLine() - commandLine must not be null.";
            logger.fatal("SystemCommand::setCommandLine() - commandLine must not be null.");
            throw new NullPointerException("SystemCommand::setCommandLine() - commandLine must not be null.");
        }
        this.commandLine = commandLine;
    }

    public File getWorkingDirectory() {
        String methodLogName = "SystemCommand::getWorkingDirectory()";
        logger.trace("SystemCommand::getWorkingDirectory()");
        return this.workingDirectory;
    }

    public synchronized void setWorkingDirectory(File workingDirectory) {
        String methodLogName = "SystemCommand::setWorkingDirectory()";
        logger.trace("SystemCommand::setWorkingDirectory()");
        this.workingDirectory = workingDirectory;
    }

    public long getTimeout() {
        String methodLogName = "SystemCommand::getTimeout()";
        logger.trace("SystemCommand::getTimeout()");
        return this.timeout;
    }

    public synchronized void setTimeout(long timeout) throws IllegalArgumentException {
        String methodLogName = "SystemCommand::setTimeout()";
        logger.trace("SystemCommand::setTimeout()");
        if (timeout < 0L) {
            String message = "SystemCommand::setTimeout() - timeout [" + timeout + "] must not be negative.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.timeout = timeout;
    }

    public synchronized int execute() throws IllegalStateException, InterruptedException, IOException, TimeoutException {
        String methodLogName = "SystemCommand::execute()";
        logger.trace("SystemCommand::execute()");
        if (this.commandLine == null) {
            String message = "SystemCommand::execute() - command line has not been set yet.";
            logger.fatal("SystemCommand::execute() - command line has not been set yet.");
            throw new IllegalStateException("SystemCommand::execute() - command line has not been set yet.");
        }
        if (this.newSystemCommand) {
            logger.debug("SystemCommand::execute() - this is a new SystemCommand.");
            this.newSystemCommand = false;
        } else {
            this.commandResultPermit.acquireUninterruptibly();
        }
        if (this.commandResultPermit.availablePermits() != 0) {
            String message = "SystemCommand::execute() - [commandResultPermit] binary semaphore violation detected.";
            logger.fatal("SystemCommand::execute() - [commandResultPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"SystemCommand::execute() - [commandResultPermit] binary semaphore violation detected.");
        }
        this.isExecuting = true;
        this.standardOutputString = "";
        this.standardErrorString = "";
        this.exitStatus = -1;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        logger.debug("SystemCommand::execute() - preparing to execute command [" + this.commandLine + "] in working directory [" + this.workingDirectory + (this.timeout > 0L ? "] with a " + this.timeout + " second timeout." : "]."));
        try {
            process = runtime.exec(this.commandLine, null, this.workingDirectory);
        }
        catch (IOException ioe) {
            logger.error("SystemCommand::execute() - I/O error [" + ioe.getMessage() + "] whilst attempting to execute command.");
            this.commandResultPermit.release();
            throw ioe;
        }
        logger.debug("SystemCommand::execute() - command execution in progress.");
        this.standardOutputConsumer.consumeStream(process.getInputStream());
        this.standardErrorConsumer.consumeStream(process.getErrorStream());
        boolean unexpectedInterrupt = Thread.interrupted();
        if (this.timeout > 0L) {
            this.interrupt = ThreadWatchdog.register(Thread.currentThread(), this.timeout, TimeUnit.SECONDS);
            this.timeoutCounting = true;
        } else {
            this.interrupt = ThreadWatchdog.register(Thread.currentThread());
            this.timeoutCounting = false;
        }
        while (true) {
            try {
                this.exitStatus = process.waitFor();
                this.interrupt.cancel();
            }
            catch (InterruptedException ie) {
                if (this.interrupt.executed()) {
                    process.destroy();
                    if (unexpectedInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                    this.standardOutputString = this.standardOutputConsumer.getConsumedString();
                    this.standardErrorString = this.standardErrorConsumer.getConsumedString();
                    this.commandResultPermit.release();
                    this.isExecuting = false;
                    if (this.timeoutCounting) {
                        String logMessage = "SystemCommand::execute() - command timeout exceeded after " + this.timeout + (this.timeout == 1L ? " second." : " seconds.") + " Command terminated.";
                        logger.error(logMessage);
                        throw new TimeoutException(logMessage);
                    }
                    String logMessage = "SystemCommand::execute() - command explicitly interrupted.";
                    logger.debug("SystemCommand::execute() - command explicitly interrupted.");
                    throw new InterruptedException("SystemCommand::execute() - command explicitly interrupted.");
                }
                logger.debug("SystemCommand::execute() - unexpected interrupt received whilst waiting for command execution to finish.");
                unexpectedInterrupt = true;
                continue;
            }
            break;
        }
        this.interrupt = null;
        if (unexpectedInterrupt) {
            Thread.currentThread().interrupt();
        }
        this.standardOutputString = this.standardOutputConsumer.getConsumedString();
        this.standardErrorString = this.standardErrorConsumer.getConsumedString();
        this.commandResultPermit.release();
        logger.debug("SystemCommand::execute() - command execution complete.");
        this.isExecuting = false;
        process.destroy();
        return this.exitStatus;
    }

    public boolean isExecuting() {
        String methodLogName = "SystemCommand::isExecuting()";
        logger.trace("SystemCommand::isExecuting()");
        return this.isExecuting;
    }

    public void interrupt() {
        String methodLogName = "SystemCommand::isExecuting()";
        logger.trace("SystemCommand::isExecuting()");
        ThreadWatchdog.Interrupt interrupt = this.interrupt;
        if (interrupt != null) {
            this.timeoutCounting = false;
            interrupt.execute();
        }
    }

    public void awaitCompletion() {
        String methodLogName = "SystemCommand::awaitCompletion()";
        logger.trace("SystemCommand::awaitCompletion()");
        this.commandResultPermit.acquireUninterruptibly();
        if (this.commandResultPermit.availablePermits() != 0) {
            String message = "SystemCommand::awaitCompletion() - [commandResultPermit] binary semaphore violation detected.";
            logger.fatal("SystemCommand::awaitCompletion() - [commandResultPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"SystemCommand::awaitCompletion() - [commandResultPermit] binary semaphore violation detected.");
        }
        this.commandResultPermit.release();
    }

    public String getStandardOutputString() {
        String methodLogName = "SystemCommand::getStandardOutputString()";
        logger.trace("SystemCommand::getStandardOutputString()");
        this.commandResultPermit.acquireUninterruptibly();
        if (this.commandResultPermit.availablePermits() != 0) {
            String message = "SystemCommand::getStandardOutputString() - [commandResultPermit] binary semaphore violation detected.";
            logger.fatal("SystemCommand::getStandardOutputString() - [commandResultPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"SystemCommand::getStandardOutputString() - [commandResultPermit] binary semaphore violation detected.");
        }
        String result = this.standardOutputString;
        this.commandResultPermit.release();
        return result;
    }

    public String getStandardErrorString() {
        String methodLogName = "SystemCommand::getStandardErrorString()";
        logger.trace("SystemCommand::getStandardErrorString()");
        this.commandResultPermit.acquireUninterruptibly();
        if (this.commandResultPermit.availablePermits() != 0) {
            String message = "SystemCommand::getStandardErrorString() - [commandResultPermit] binary semaphore violation detected.";
            logger.fatal("SystemCommand::getStandardErrorString() - [commandResultPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"SystemCommand::getStandardErrorString() - [commandResultPermit] binary semaphore violation detected.");
        }
        String result = this.standardErrorString;
        this.commandResultPermit.release();
        return result;
    }

    public int getExitStatus() {
        String methodLogName = "SystemCommand::getExitStatus()";
        logger.trace("SystemCommand::getExitStatus()");
        this.commandResultPermit.acquireUninterruptibly();
        if (this.commandResultPermit.availablePermits() != 0) {
            String message = "SystemCommand::getExitStatus() - [commandResultPermit] binary semaphore violation detected.";
            logger.fatal("SystemCommand::getExitStatus() - [commandResultPermit] binary semaphore violation detected.");
            throw new AssertionError((Object)"SystemCommand::getExitStatus() - [commandResultPermit] binary semaphore violation detected.");
        }
        int result = this.exitStatus;
        this.commandResultPermit.release();
        return result;
    }
}

