/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.stream;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eso.util.misc.DefaultDaemonThreadFactory;
import org.eso.util.stream.Message;
import org.eso.util.stream.RoutingTask;

public class DelayTask
extends RoutingTask {
    static final Logger logger = Logger.getLogger(DelayTask.class);
    private static final String classLogName = "DelayTask";
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new DefaultDaemonThreadFactory());
    private long delay;
    private TimeUnit unit;

    public DelayTask(long delay, TimeUnit unit) throws IllegalArgumentException, NullPointerException {
        super(classLogName);
        String methodLogName = "DelayTask::DelayTask() [for task DelayTask]";
        logger.trace("DelayTask::DelayTask() [for task DelayTask]");
        if (unit == null) {
            String message = "DelayTask::DelayTask() [for task DelayTask] - unit must not be null.";
            logger.fatal("DelayTask::DelayTask() [for task DelayTask] - unit must not be null.");
            throw new NullPointerException("DelayTask::DelayTask() [for task DelayTask] - unit must not be null.");
        }
        if (delay < 0L) {
            String message = "DelayTask::DelayTask() [for task DelayTask] - delay [" + delay + "] must not be negative.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.delay = delay;
        this.unit = unit;
    }

    public DelayTask(String taskName, long delay, TimeUnit unit) throws IllegalArgumentException, NullPointerException {
        super(taskName);
        String methodLogName = "DelayTask::DelayTask(String) [for task " + taskName + "]";
        logger.trace(methodLogName);
        if (unit == null) {
            String message = methodLogName + " - unit must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (delay < 0L) {
            String message = methodLogName + " - delay [" + delay + "] must not be negative.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.delay = delay;
        this.unit = unit;
    }

    @Override
    public final Message get() {
        String methodLogName = "DelayTask::get() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        return null;
    }

    @Override
    public final Message get(long timeout) {
        String methodLogName = "DelayTask::get(long) [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        return null;
    }

    @Override
    public final synchronized void put(Message message) {
        String methodLogName = "DelayTask::put(Message) [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        this.put(message, this.delay, this.unit);
    }

    public final void put(Message message, long delay, TimeUnit unit) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "DelayTask::put(Message, long, TimeUnit) [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        if (unit == null) {
            String logMessage = methodLogName + " - unit must not be null.";
            logger.fatal(logMessage);
            throw new NullPointerException(logMessage);
        }
        if (delay < 0L) {
            String logMessage = methodLogName + " - delay [" + delay + "] must not be negative.";
            logger.fatal(logMessage);
            throw new IllegalArgumentException(logMessage);
        }
        executor.schedule(new MessageForwarder(message), delay, unit);
        logger.debug(methodLogName + " - scheduled message for forwarding in [" + delay + "][" + (Object)((Object)unit) + "].");
    }

    @Override
    public final void putNext(Message message) {
        String methodLogName = "DelayTask::putNext() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        logger.debug(methodLogName + " - forwarding message to next task.");
        this.getNextTask().put(message);
    }

    public final long getDefaultDelay() {
        String methodLogName = "DelayTask::getDefaultDelay() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        return this.delay;
    }

    public final TimeUnit getDefaultUnit() {
        String methodLogName = "DelayTask::getDefaultUnit() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        return this.unit;
    }

    public final synchronized void setDefaultDelay(long delay, TimeUnit unit) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "DelayTask::setDefaultDelay() [for task " + this.getTaskName() + "]";
        logger.trace(methodLogName);
        if (unit == null) {
            String logMessage = methodLogName + " - unit must not be null.";
            logger.fatal(logMessage);
            throw new NullPointerException(logMessage);
        }
        if (delay < 0L) {
            String logMessage = methodLogName + " - delay [" + delay + "] must not be negative.";
            logger.fatal(logMessage);
            throw new IllegalArgumentException(logMessage);
        }
        this.delay = delay;
        this.unit = unit;
    }

    private class MessageForwarder
    implements Runnable {
        private final String classLogName = "MessageForwarder";
        private final Message message;

        MessageForwarder(Message message) throws NullPointerException {
            String methodLogName = "MessageForwarder::MessageForwarder() [for task " + DelayTask.this.getTaskName() + "]";
            logger.trace(methodLogName);
            if (message == null) {
                String logMessage = methodLogName + " - message must not be null.";
                logger.fatal(logMessage);
                throw new NullPointerException(logMessage);
            }
            this.message = message;
        }

        @Override
        public void run() {
            String methodLogName = "MessageForwarder::run() [for task " + DelayTask.this.getTaskName() + "]";
            logger.trace(methodLogName);
            DelayTask.this.putNext(this.message);
        }
    }
}

