// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.6
// source: sigstore_common.proto

package v1

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Only a subset of the secure hash standard algorithms are supported.
// See <https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.180-4.pdf> for more
// details.
// UNSPECIFIED SHOULD not be used, primary reason for inclusion is to force
// any proto JSON serialization to emit the used hash algorithm, as default
// option is to *omit* the default value of an enum (which is the first
// value, represented by '0'.
type HashAlgorithm int32

const (
	HashAlgorithm_HASH_ALGORITHM_UNSPECIFIED HashAlgorithm = 0
	HashAlgorithm_SHA2_256                   HashAlgorithm = 1
	HashAlgorithm_SHA2_384                   HashAlgorithm = 2
	HashAlgorithm_SHA2_512                   HashAlgorithm = 3
	HashAlgorithm_SHA3_256                   HashAlgorithm = 4
	HashAlgorithm_SHA3_384                   HashAlgorithm = 5
)

// Enum value maps for HashAlgorithm.
var (
	HashAlgorithm_name = map[int32]string{
		0: "HASH_ALGORITHM_UNSPECIFIED",
		1: "SHA2_256",
		2: "SHA2_384",
		3: "SHA2_512",
		4: "SHA3_256",
		5: "SHA3_384",
	}
	HashAlgorithm_value = map[string]int32{
		"HASH_ALGORITHM_UNSPECIFIED": 0,
		"SHA2_256":                   1,
		"SHA2_384":                   2,
		"SHA2_512":                   3,
		"SHA3_256":                   4,
		"SHA3_384":                   5,
	}
)

func (x HashAlgorithm) Enum() *HashAlgorithm {
	p := new(HashAlgorithm)
	*p = x
	return p
}

func (x HashAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HashAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_sigstore_common_proto_enumTypes[0].Descriptor()
}

func (HashAlgorithm) Type() protoreflect.EnumType {
	return &file_sigstore_common_proto_enumTypes[0]
}

func (x HashAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HashAlgorithm.Descriptor instead.
func (HashAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{0}
}

// Details of a specific public key, capturing the the key encoding method,
// and signature algorithm.
//
// PublicKeyDetails captures the public key/hash algorithm combinations
// recommended in the Sigstore ecosystem.
//
// This is modelled as a linear set as we want to provide a small number of
// opinionated options instead of allowing every possible permutation.
//
// Any changes to this enum MUST be reflected in the algorithm registry.
// See: docs/algorithm-registry.md
//
// To avoid the possibility of contradicting formats such as PKCS1 with
// ED25519 the valid permutations are listed as a linear set instead of a
// cartesian set (i.e one combined variable instead of two, one for encoding
// and one for the signature algorithm).
type PublicKeyDetails int32

const (
	PublicKeyDetails_PUBLIC_KEY_DETAILS_UNSPECIFIED PublicKeyDetails = 0
	// RSA
	//
	// Deprecated: Do not use.
	PublicKeyDetails_PKCS1_RSA_PKCS1V5 PublicKeyDetails = 1 // See RFC8017
	// Deprecated: Do not use.
	PublicKeyDetails_PKCS1_RSA_PSS PublicKeyDetails = 2 // See RFC8017
	// Deprecated: Do not use.
	PublicKeyDetails_PKIX_RSA_PKCS1V5 PublicKeyDetails = 3
	// Deprecated: Do not use.
	PublicKeyDetails_PKIX_RSA_PSS PublicKeyDetails = 4
	// RSA public key in PKIX format, PKCS#1v1.5 signature
	PublicKeyDetails_PKIX_RSA_PKCS1V15_2048_SHA256 PublicKeyDetails = 9
	PublicKeyDetails_PKIX_RSA_PKCS1V15_3072_SHA256 PublicKeyDetails = 10
	PublicKeyDetails_PKIX_RSA_PKCS1V15_4096_SHA256 PublicKeyDetails = 11
	// RSA public key in PKIX format, RSASSA-PSS signature
	PublicKeyDetails_PKIX_RSA_PSS_2048_SHA256 PublicKeyDetails = 16 // See RFC4055
	PublicKeyDetails_PKIX_RSA_PSS_3072_SHA256 PublicKeyDetails = 17
	PublicKeyDetails_PKIX_RSA_PSS_4096_SHA256 PublicKeyDetails = 18
	// ECDSA
	//
	// Deprecated: Do not use.
	PublicKeyDetails_PKIX_ECDSA_P256_HMAC_SHA_256 PublicKeyDetails = 6 // See RFC6979
	PublicKeyDetails_PKIX_ECDSA_P256_SHA_256      PublicKeyDetails = 5 // See NIST FIPS 186-4
	PublicKeyDetails_PKIX_ECDSA_P384_SHA_384      PublicKeyDetails = 12
	PublicKeyDetails_PKIX_ECDSA_P521_SHA_512      PublicKeyDetails = 13
	// Ed 25519
	PublicKeyDetails_PKIX_ED25519    PublicKeyDetails = 7 // See RFC8032
	PublicKeyDetails_PKIX_ED25519_PH PublicKeyDetails = 8
	// LMS and LM-OTS
	//
	// These keys and signatures may be used by private Sigstore
	// deployments, but are not currently supported by the public
	// good instance.
	//
	// USER WARNING: LMS and LM-OTS are both stateful signature schemes.
	// Using them correctly requires discretion and careful consideration
	// to ensure that individual secret keys are not used more than once.
	// In addition, LM-OTS is a single-use scheme, meaning that it
	// MUST NOT be used for more than one signature per LM-OTS key.
	// If you cannot maintain these invariants, you MUST NOT use these
	// schemes.
	PublicKeyDetails_LMS_SHA256   PublicKeyDetails = 14
	PublicKeyDetails_LMOTS_SHA256 PublicKeyDetails = 15
)

// Enum value maps for PublicKeyDetails.
var (
	PublicKeyDetails_name = map[int32]string{
		0:  "PUBLIC_KEY_DETAILS_UNSPECIFIED",
		1:  "PKCS1_RSA_PKCS1V5",
		2:  "PKCS1_RSA_PSS",
		3:  "PKIX_RSA_PKCS1V5",
		4:  "PKIX_RSA_PSS",
		9:  "PKIX_RSA_PKCS1V15_2048_SHA256",
		10: "PKIX_RSA_PKCS1V15_3072_SHA256",
		11: "PKIX_RSA_PKCS1V15_4096_SHA256",
		16: "PKIX_RSA_PSS_2048_SHA256",
		17: "PKIX_RSA_PSS_3072_SHA256",
		18: "PKIX_RSA_PSS_4096_SHA256",
		6:  "PKIX_ECDSA_P256_HMAC_SHA_256",
		5:  "PKIX_ECDSA_P256_SHA_256",
		12: "PKIX_ECDSA_P384_SHA_384",
		13: "PKIX_ECDSA_P521_SHA_512",
		7:  "PKIX_ED25519",
		8:  "PKIX_ED25519_PH",
		14: "LMS_SHA256",
		15: "LMOTS_SHA256",
	}
	PublicKeyDetails_value = map[string]int32{
		"PUBLIC_KEY_DETAILS_UNSPECIFIED": 0,
		"PKCS1_RSA_PKCS1V5":              1,
		"PKCS1_RSA_PSS":                  2,
		"PKIX_RSA_PKCS1V5":               3,
		"PKIX_RSA_PSS":                   4,
		"PKIX_RSA_PKCS1V15_2048_SHA256":  9,
		"PKIX_RSA_PKCS1V15_3072_SHA256":  10,
		"PKIX_RSA_PKCS1V15_4096_SHA256":  11,
		"PKIX_RSA_PSS_2048_SHA256":       16,
		"PKIX_RSA_PSS_3072_SHA256":       17,
		"PKIX_RSA_PSS_4096_SHA256":       18,
		"PKIX_ECDSA_P256_HMAC_SHA_256":   6,
		"PKIX_ECDSA_P256_SHA_256":        5,
		"PKIX_ECDSA_P384_SHA_384":        12,
		"PKIX_ECDSA_P521_SHA_512":        13,
		"PKIX_ED25519":                   7,
		"PKIX_ED25519_PH":                8,
		"LMS_SHA256":                     14,
		"LMOTS_SHA256":                   15,
	}
)

func (x PublicKeyDetails) Enum() *PublicKeyDetails {
	p := new(PublicKeyDetails)
	*p = x
	return p
}

func (x PublicKeyDetails) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicKeyDetails) Descriptor() protoreflect.EnumDescriptor {
	return file_sigstore_common_proto_enumTypes[1].Descriptor()
}

func (PublicKeyDetails) Type() protoreflect.EnumType {
	return &file_sigstore_common_proto_enumTypes[1]
}

func (x PublicKeyDetails) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicKeyDetails.Descriptor instead.
func (PublicKeyDetails) EnumDescriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{1}
}

type SubjectAlternativeNameType int32

const (
	SubjectAlternativeNameType_SUBJECT_ALTERNATIVE_NAME_TYPE_UNSPECIFIED SubjectAlternativeNameType = 0
	SubjectAlternativeNameType_EMAIL                                     SubjectAlternativeNameType = 1
	SubjectAlternativeNameType_URI                                       SubjectAlternativeNameType = 2
	// OID 1.3.6.1.4.1.57264.1.7
	// See https://github.com/sigstore/fulcio/blob/main/docs/oid-info.md#1361415726417--othername-san
	// for more details.
	SubjectAlternativeNameType_OTHER_NAME SubjectAlternativeNameType = 3
)

// Enum value maps for SubjectAlternativeNameType.
var (
	SubjectAlternativeNameType_name = map[int32]string{
		0: "SUBJECT_ALTERNATIVE_NAME_TYPE_UNSPECIFIED",
		1: "EMAIL",
		2: "URI",
		3: "OTHER_NAME",
	}
	SubjectAlternativeNameType_value = map[string]int32{
		"SUBJECT_ALTERNATIVE_NAME_TYPE_UNSPECIFIED": 0,
		"EMAIL":      1,
		"URI":        2,
		"OTHER_NAME": 3,
	}
)

func (x SubjectAlternativeNameType) Enum() *SubjectAlternativeNameType {
	p := new(SubjectAlternativeNameType)
	*p = x
	return p
}

func (x SubjectAlternativeNameType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubjectAlternativeNameType) Descriptor() protoreflect.EnumDescriptor {
	return file_sigstore_common_proto_enumTypes[2].Descriptor()
}

func (SubjectAlternativeNameType) Type() protoreflect.EnumType {
	return &file_sigstore_common_proto_enumTypes[2]
}

func (x SubjectAlternativeNameType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubjectAlternativeNameType.Descriptor instead.
func (SubjectAlternativeNameType) EnumDescriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{2}
}

// HashOutput captures a digest of a 'message' (generic octet sequence)
// and the corresponding hash algorithm used.
type HashOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Algorithm HashAlgorithm `protobuf:"varint,1,opt,name=algorithm,proto3,enum=dev.sigstore.common.v1.HashAlgorithm" json:"algorithm,omitempty"`
	// This is the raw octets of the message digest as computed by
	// the hash algorithm.
	Digest []byte `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *HashOutput) Reset() {
	*x = HashOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashOutput) ProtoMessage() {}

func (x *HashOutput) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashOutput.ProtoReflect.Descriptor instead.
func (*HashOutput) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{0}
}

func (x *HashOutput) GetAlgorithm() HashAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return HashAlgorithm_HASH_ALGORITHM_UNSPECIFIED
}

func (x *HashOutput) GetDigest() []byte {
	if x != nil {
		return x.Digest
	}
	return nil
}

// MessageSignature stores the computed signature over a message.
type MessageSignature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Message digest can be used to identify the artifact.
	// Clients MUST NOT attempt to use this digest to verify the associated
	// signature; it is intended solely for identification.
	MessageDigest *HashOutput `protobuf:"bytes,1,opt,name=message_digest,json=messageDigest,proto3" json:"message_digest,omitempty"`
	// The raw bytes as returned from the signature algorithm.
	// The signature algorithm (and so the format of the signature bytes)
	// are determined by the contents of the 'verification_material',
	// either a key-pair or a certificate. If using a certificate, the
	// certificate contains the required information on the signature
	// algorithm.
	// When using a key pair, the algorithm MUST be part of the public
	// key, which MUST be communicated out-of-band.
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *MessageSignature) Reset() {
	*x = MessageSignature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageSignature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageSignature) ProtoMessage() {}

func (x *MessageSignature) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageSignature.ProtoReflect.Descriptor instead.
func (*MessageSignature) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{1}
}

func (x *MessageSignature) GetMessageDigest() *HashOutput {
	if x != nil {
		return x.MessageDigest
	}
	return nil
}

func (x *MessageSignature) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

// LogId captures the identity of a transparency log.
type LogId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identity of the log, represented by its public key.
	KeyId []byte `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
}

func (x *LogId) Reset() {
	*x = LogId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogId) ProtoMessage() {}

func (x *LogId) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogId.ProtoReflect.Descriptor instead.
func (*LogId) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{2}
}

func (x *LogId) GetKeyId() []byte {
	if x != nil {
		return x.KeyId
	}
	return nil
}

// This message holds a RFC 3161 timestamp.
type RFC3161SignedTimestamp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Signed timestamp is the DER encoded TimeStampResponse.
	// See https://www.rfc-editor.org/rfc/rfc3161.html#section-2.4.2
	SignedTimestamp []byte `protobuf:"bytes,1,opt,name=signed_timestamp,json=signedTimestamp,proto3" json:"signed_timestamp,omitempty"`
}

func (x *RFC3161SignedTimestamp) Reset() {
	*x = RFC3161SignedTimestamp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RFC3161SignedTimestamp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RFC3161SignedTimestamp) ProtoMessage() {}

func (x *RFC3161SignedTimestamp) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RFC3161SignedTimestamp.ProtoReflect.Descriptor instead.
func (*RFC3161SignedTimestamp) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{3}
}

func (x *RFC3161SignedTimestamp) GetSignedTimestamp() []byte {
	if x != nil {
		return x.SignedTimestamp
	}
	return nil
}

type PublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DER-encoded public key, encoding method is specified by the
	// key_details attribute.
	RawBytes []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes,proto3,oneof" json:"raw_bytes,omitempty"`
	// Key encoding and signature algorithm to use for this key.
	KeyDetails PublicKeyDetails `protobuf:"varint,2,opt,name=key_details,json=keyDetails,proto3,enum=dev.sigstore.common.v1.PublicKeyDetails" json:"key_details,omitempty"`
	// Optional validity period for this key, *inclusive* of the endpoints.
	ValidFor *TimeRange `protobuf:"bytes,3,opt,name=valid_for,json=validFor,proto3,oneof" json:"valid_for,omitempty"`
}

func (x *PublicKey) Reset() {
	*x = PublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKey) ProtoMessage() {}

func (x *PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKey.ProtoReflect.Descriptor instead.
func (*PublicKey) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{4}
}

func (x *PublicKey) GetRawBytes() []byte {
	if x != nil {
		return x.RawBytes
	}
	return nil
}

func (x *PublicKey) GetKeyDetails() PublicKeyDetails {
	if x != nil {
		return x.KeyDetails
	}
	return PublicKeyDetails_PUBLIC_KEY_DETAILS_UNSPECIFIED
}

func (x *PublicKey) GetValidFor() *TimeRange {
	if x != nil {
		return x.ValidFor
	}
	return nil
}

// PublicKeyIdentifier can be used to identify an (out of band) delivered
// key, to verify a signature.
type PublicKeyIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional unauthenticated hint on which key to use.
	// The format of the hint must be agreed upon out of band by the
	// signer and the verifiers, and so is not subject to this
	// specification.
	// Example use-case is to specify the public key to use, from a
	// trusted key-ring.
	// Implementors are RECOMMENDED to derive the value from the public
	// key as described in RFC 6962.
	// See: <https://www.rfc-editor.org/rfc/rfc6962#section-3.2>
	Hint string `protobuf:"bytes,1,opt,name=hint,proto3" json:"hint,omitempty"`
}

func (x *PublicKeyIdentifier) Reset() {
	*x = PublicKeyIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublicKeyIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKeyIdentifier) ProtoMessage() {}

func (x *PublicKeyIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKeyIdentifier.ProtoReflect.Descriptor instead.
func (*PublicKeyIdentifier) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{5}
}

func (x *PublicKeyIdentifier) GetHint() string {
	if x != nil {
		return x.Hint
	}
	return ""
}

// An ASN.1 OBJECT IDENTIFIER
type ObjectIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id []int32 `protobuf:"varint,1,rep,packed,name=id,proto3" json:"id,omitempty"`
}

func (x *ObjectIdentifier) Reset() {
	*x = ObjectIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectIdentifier) ProtoMessage() {}

func (x *ObjectIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectIdentifier.ProtoReflect.Descriptor instead.
func (*ObjectIdentifier) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{6}
}

func (x *ObjectIdentifier) GetId() []int32 {
	if x != nil {
		return x.Id
	}
	return nil
}

// An OID and the corresponding (byte) value.
type ObjectIdentifierValuePair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Oid   *ObjectIdentifier `protobuf:"bytes,1,opt,name=oid,proto3" json:"oid,omitempty"`
	Value []byte            `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ObjectIdentifierValuePair) Reset() {
	*x = ObjectIdentifierValuePair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectIdentifierValuePair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectIdentifierValuePair) ProtoMessage() {}

func (x *ObjectIdentifierValuePair) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectIdentifierValuePair.ProtoReflect.Descriptor instead.
func (*ObjectIdentifierValuePair) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{7}
}

func (x *ObjectIdentifierValuePair) GetOid() *ObjectIdentifier {
	if x != nil {
		return x.Oid
	}
	return nil
}

func (x *ObjectIdentifierValuePair) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type DistinguishedName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Organization string `protobuf:"bytes,1,opt,name=organization,proto3" json:"organization,omitempty"`
	CommonName   string `protobuf:"bytes,2,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
}

func (x *DistinguishedName) Reset() {
	*x = DistinguishedName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistinguishedName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistinguishedName) ProtoMessage() {}

func (x *DistinguishedName) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistinguishedName.ProtoReflect.Descriptor instead.
func (*DistinguishedName) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{8}
}

func (x *DistinguishedName) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *DistinguishedName) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

type X509Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DER-encoded X.509 certificate.
	RawBytes []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes,proto3" json:"raw_bytes,omitempty"`
}

func (x *X509Certificate) Reset() {
	*x = X509Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509Certificate) ProtoMessage() {}

func (x *X509Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509Certificate.ProtoReflect.Descriptor instead.
func (*X509Certificate) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{9}
}

func (x *X509Certificate) GetRawBytes() []byte {
	if x != nil {
		return x.RawBytes
	}
	return nil
}

type SubjectAlternativeName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type SubjectAlternativeNameType `protobuf:"varint,1,opt,name=type,proto3,enum=dev.sigstore.common.v1.SubjectAlternativeNameType" json:"type,omitempty"`
	// Types that are assignable to Identity:
	//
	//	*SubjectAlternativeName_Regexp
	//	*SubjectAlternativeName_Value
	Identity isSubjectAlternativeName_Identity `protobuf_oneof:"identity"`
}

func (x *SubjectAlternativeName) Reset() {
	*x = SubjectAlternativeName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubjectAlternativeName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubjectAlternativeName) ProtoMessage() {}

func (x *SubjectAlternativeName) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubjectAlternativeName.ProtoReflect.Descriptor instead.
func (*SubjectAlternativeName) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{10}
}

func (x *SubjectAlternativeName) GetType() SubjectAlternativeNameType {
	if x != nil {
		return x.Type
	}
	return SubjectAlternativeNameType_SUBJECT_ALTERNATIVE_NAME_TYPE_UNSPECIFIED
}

func (m *SubjectAlternativeName) GetIdentity() isSubjectAlternativeName_Identity {
	if m != nil {
		return m.Identity
	}
	return nil
}

func (x *SubjectAlternativeName) GetRegexp() string {
	if x, ok := x.GetIdentity().(*SubjectAlternativeName_Regexp); ok {
		return x.Regexp
	}
	return ""
}

func (x *SubjectAlternativeName) GetValue() string {
	if x, ok := x.GetIdentity().(*SubjectAlternativeName_Value); ok {
		return x.Value
	}
	return ""
}

type isSubjectAlternativeName_Identity interface {
	isSubjectAlternativeName_Identity()
}

type SubjectAlternativeName_Regexp struct {
	// A regular expression describing the expected value for
	// the SAN.
	Regexp string `protobuf:"bytes,2,opt,name=regexp,proto3,oneof"`
}

type SubjectAlternativeName_Value struct {
	// The exact value to match against.
	Value string `protobuf:"bytes,3,opt,name=value,proto3,oneof"`
}

func (*SubjectAlternativeName_Regexp) isSubjectAlternativeName_Identity() {}

func (*SubjectAlternativeName_Value) isSubjectAlternativeName_Identity() {}

// A collection of X.509 certificates.
//
// This "chain" can be used in multiple contexts, such as providing a root CA
// certificate within a TUF root of trust or multiple untrusted certificates for
// the purpose of chain building.
type X509CertificateChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more DER-encoded certificates.
	//
	// In some contexts (such as `VerificationMaterial.x509_certificate_chain`), this sequence
	// has an imposed order. Unless explicitly specified, there is otherwise no
	// guaranteed order.
	Certificates []*X509Certificate `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
}

func (x *X509CertificateChain) Reset() {
	*x = X509CertificateChain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509CertificateChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509CertificateChain) ProtoMessage() {}

func (x *X509CertificateChain) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509CertificateChain.ProtoReflect.Descriptor instead.
func (*X509CertificateChain) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{11}
}

func (x *X509CertificateChain) GetCertificates() []*X509Certificate {
	if x != nil {
		return x.Certificates
	}
	return nil
}

// The time range is closed and includes both the start and end times,
// (i.e., [start, end]).
// End is optional to be able to capture a period that has started but
// has no known end.
type TimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Start *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End   *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *TimeRange) Reset() {
	*x = TimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sigstore_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeRange) ProtoMessage() {}

func (x *TimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_sigstore_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeRange.ProtoReflect.Descriptor instead.
func (*TimeRange) Descriptor() ([]byte, []int) {
	return file_sigstore_common_proto_rawDescGZIP(), []int{12}
}

func (x *TimeRange) GetStart() *timestamppb.Timestamp {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *TimeRange) GetEnd() *timestamppb.Timestamp {
	if x != nil {
		return x.End
	}
	return nil
}

var File_sigstore_common_proto protoreflect.FileDescriptor

var file_sigstore_common_proto_rawDesc = []byte{
	0x0a, 0x15, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x69, 0x0a, 0x0a, 0x48, 0x61, 0x73, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x43, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x25, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x80, 0x01, 0x0a,
	0x10, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x12, 0x49, 0x0a, 0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x64, 0x65, 0x76, 0x2e,
	0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22,
	0x23, 0x0a, 0x05, 0x4c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6b,
	0x65, 0x79, 0x49, 0x64, 0x22, 0x48, 0x0a, 0x16, 0x52, 0x46, 0x43, 0x33, 0x31, 0x36, 0x31, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2e,
	0x0a, 0x10, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0xd9,
	0x01, 0x0a, 0x09, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x20, 0x0a, 0x09,
	0x72, 0x61, 0x77, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48,
	0x00, 0x52, 0x08, 0x72, 0x61, 0x77, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x49,
	0x0a, 0x0b, 0x6b, 0x65, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0a, 0x6b,
	0x65, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x09, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x64,
	0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x01, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x46, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x42, 0x0c,
	0x0a, 0x0a, 0x5f, 0x72, 0x61, 0x77, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x22, 0x29, 0x0a, 0x13, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x68, 0x69, 0x6e, 0x74, 0x22, 0x27, 0x0a, 0x10, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x22, 0x6d,
	0x0a, 0x19, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x12, 0x3a, 0x0a, 0x03, 0x6f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73,
	0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x03, 0x6f, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x58, 0x0a,
	0x11, 0x44, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x65, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x33, 0x0a, 0x0f, 0x58, 0x35, 0x30, 0x39, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x72, 0x61,
	0x77, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x72, 0x61, 0x77, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x9e, 0x01, 0x0a,
	0x16, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x18, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x65, 0x78, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x06, 0x72, 0x65, 0x67, 0x65, 0x78, 0x70, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x0a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x63, 0x0a,
	0x14, 0x58, 0x35, 0x30, 0x39, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x4b, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x64, 0x65,
	0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x22, 0x78, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x30, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x12, 0x31, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x03, 0x65, 0x6e,
	0x64, 0x88, 0x01, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x2a, 0x75, 0x0a, 0x0d,
	0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1e, 0x0a,
	0x1a, 0x48, 0x41, 0x53, 0x48, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x48, 0x41, 0x32, 0x5f, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x48, 0x41, 0x32, 0x5f, 0x33, 0x38, 0x34, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x48, 0x41,
	0x32, 0x5f, 0x35, 0x31, 0x32, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x48, 0x41, 0x33, 0x5f,
	0x32, 0x35, 0x36, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x48, 0x41, 0x33, 0x5f, 0x33, 0x38,
	0x34, 0x10, 0x05, 0x2a, 0xa7, 0x04, 0x0a, 0x10, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x55, 0x42, 0x4c,
	0x49, 0x43, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x11,
	0x50, 0x4b, 0x43, 0x53, 0x31, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x56,
	0x35, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x15, 0x0a, 0x0d, 0x50, 0x4b, 0x43, 0x53, 0x31,
	0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x18,
	0x0a, 0x10, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31,
	0x56, 0x35, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x14, 0x0a, 0x0c, 0x50, 0x4b, 0x49, 0x58,
	0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x21,
	0x0a, 0x1d, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31,
	0x56, 0x31, 0x35, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10,
	0x09, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x4b,
	0x43, 0x53, 0x31, 0x56, 0x31, 0x35, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32,
	0x35, 0x36, 0x10, 0x0a, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x52, 0x53, 0x41,
	0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x56, 0x31, 0x35, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53,
	0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x0b, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x4b, 0x49, 0x58, 0x5f,
	0x52, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x32, 0x30, 0x34, 0x38, 0x5f, 0x53, 0x48, 0x41,
	0x32, 0x35, 0x36, 0x10, 0x10, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x52, 0x53,
	0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x33, 0x30, 0x37, 0x32, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35,
	0x36, 0x10, 0x11, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x52, 0x53, 0x41, 0x5f,
	0x50, 0x53, 0x53, 0x5f, 0x34, 0x30, 0x39, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10,
	0x12, 0x12, 0x24, 0x0a, 0x1c, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f,
	0x50, 0x32, 0x35, 0x36, 0x5f, 0x48, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x5f, 0x32, 0x35,
	0x36, 0x10, 0x06, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4b, 0x49, 0x58, 0x5f,
	0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x5f, 0x32,
	0x35, 0x36, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x45, 0x43, 0x44,
	0x53, 0x41, 0x5f, 0x50, 0x33, 0x38, 0x34, 0x5f, 0x53, 0x48, 0x41, 0x5f, 0x33, 0x38, 0x34, 0x10,
	0x0c, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f,
	0x50, 0x35, 0x32, 0x31, 0x5f, 0x53, 0x48, 0x41, 0x5f, 0x35, 0x31, 0x32, 0x10, 0x0d, 0x12, 0x10,
	0x0a, 0x0c, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39, 0x10, 0x07,
	0x12, 0x13, 0x0a, 0x0f, 0x50, 0x4b, 0x49, 0x58, 0x5f, 0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39,
	0x5f, 0x50, 0x48, 0x10, 0x08, 0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x4d, 0x53, 0x5f, 0x53, 0x48, 0x41,
	0x32, 0x35, 0x36, 0x10, 0x0e, 0x12, 0x10, 0x0a, 0x0c, 0x4c, 0x4d, 0x4f, 0x54, 0x53, 0x5f, 0x53,
	0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x0f, 0x22, 0x04, 0x08, 0x13, 0x10, 0x32, 0x2a, 0x6f, 0x0a,
	0x1a, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x29, 0x53,
	0x55, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x54, 0x49,
	0x56, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x4d,
	0x41, 0x49, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x55, 0x52, 0x49, 0x10, 0x02, 0x12, 0x0e,
	0x0a, 0x0a, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x42, 0x7c,
	0x0a, 0x1c, 0x64, 0x65, 0x76, 0x2e, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x0b,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x73, 0x69, 0x67, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2d, 0x73, 0x70, 0x65, 0x63,
	0x73, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x62, 0x2d, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2f, 0x76, 0x31, 0xea, 0x02, 0x14, 0x53, 0x69, 0x67, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sigstore_common_proto_rawDescOnce sync.Once
	file_sigstore_common_proto_rawDescData = file_sigstore_common_proto_rawDesc
)

func file_sigstore_common_proto_rawDescGZIP() []byte {
	file_sigstore_common_proto_rawDescOnce.Do(func() {
		file_sigstore_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_sigstore_common_proto_rawDescData)
	})
	return file_sigstore_common_proto_rawDescData
}

var file_sigstore_common_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_sigstore_common_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_sigstore_common_proto_goTypes = []interface{}{
	(HashAlgorithm)(0),                // 0: dev.sigstore.common.v1.HashAlgorithm
	(PublicKeyDetails)(0),             // 1: dev.sigstore.common.v1.PublicKeyDetails
	(SubjectAlternativeNameType)(0),   // 2: dev.sigstore.common.v1.SubjectAlternativeNameType
	(*HashOutput)(nil),                // 3: dev.sigstore.common.v1.HashOutput
	(*MessageSignature)(nil),          // 4: dev.sigstore.common.v1.MessageSignature
	(*LogId)(nil),                     // 5: dev.sigstore.common.v1.LogId
	(*RFC3161SignedTimestamp)(nil),    // 6: dev.sigstore.common.v1.RFC3161SignedTimestamp
	(*PublicKey)(nil),                 // 7: dev.sigstore.common.v1.PublicKey
	(*PublicKeyIdentifier)(nil),       // 8: dev.sigstore.common.v1.PublicKeyIdentifier
	(*ObjectIdentifier)(nil),          // 9: dev.sigstore.common.v1.ObjectIdentifier
	(*ObjectIdentifierValuePair)(nil), // 10: dev.sigstore.common.v1.ObjectIdentifierValuePair
	(*DistinguishedName)(nil),         // 11: dev.sigstore.common.v1.DistinguishedName
	(*X509Certificate)(nil),           // 12: dev.sigstore.common.v1.X509Certificate
	(*SubjectAlternativeName)(nil),    // 13: dev.sigstore.common.v1.SubjectAlternativeName
	(*X509CertificateChain)(nil),      // 14: dev.sigstore.common.v1.X509CertificateChain
	(*TimeRange)(nil),                 // 15: dev.sigstore.common.v1.TimeRange
	(*timestamppb.Timestamp)(nil),     // 16: google.protobuf.Timestamp
}
var file_sigstore_common_proto_depIdxs = []int32{
	0,  // 0: dev.sigstore.common.v1.HashOutput.algorithm:type_name -> dev.sigstore.common.v1.HashAlgorithm
	3,  // 1: dev.sigstore.common.v1.MessageSignature.message_digest:type_name -> dev.sigstore.common.v1.HashOutput
	1,  // 2: dev.sigstore.common.v1.PublicKey.key_details:type_name -> dev.sigstore.common.v1.PublicKeyDetails
	15, // 3: dev.sigstore.common.v1.PublicKey.valid_for:type_name -> dev.sigstore.common.v1.TimeRange
	9,  // 4: dev.sigstore.common.v1.ObjectIdentifierValuePair.oid:type_name -> dev.sigstore.common.v1.ObjectIdentifier
	2,  // 5: dev.sigstore.common.v1.SubjectAlternativeName.type:type_name -> dev.sigstore.common.v1.SubjectAlternativeNameType
	12, // 6: dev.sigstore.common.v1.X509CertificateChain.certificates:type_name -> dev.sigstore.common.v1.X509Certificate
	16, // 7: dev.sigstore.common.v1.TimeRange.start:type_name -> google.protobuf.Timestamp
	16, // 8: dev.sigstore.common.v1.TimeRange.end:type_name -> google.protobuf.Timestamp
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_sigstore_common_proto_init() }
func file_sigstore_common_proto_init() {
	if File_sigstore_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sigstore_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageSignature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RFC3161SignedTimestamp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublicKeyIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectIdentifierValuePair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistinguishedName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubjectAlternativeName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509CertificateChain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sigstore_common_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_sigstore_common_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_sigstore_common_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*SubjectAlternativeName_Regexp)(nil),
		(*SubjectAlternativeName_Value)(nil),
	}
	file_sigstore_common_proto_msgTypes[12].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sigstore_common_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sigstore_common_proto_goTypes,
		DependencyIndexes: file_sigstore_common_proto_depIdxs,
		EnumInfos:         file_sigstore_common_proto_enumTypes,
		MessageInfos:      file_sigstore_common_proto_msgTypes,
	}.Build()
	File_sigstore_common_proto = out.File
	file_sigstore_common_proto_rawDesc = nil
	file_sigstore_common_proto_goTypes = nil
	file_sigstore_common_proto_depIdxs = nil
}
