// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetBucketAbacInput {
    /// <p>The name of the general purpose bucket.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Web Services account ID of the general purpose bucket's owner.</p>
    pub expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl GetBucketAbacInput {
    /// <p>The name of the general purpose bucket.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the general purpose bucket's owner.</p>
    pub fn expected_bucket_owner(&self) -> ::std::option::Option<&str> {
        self.expected_bucket_owner.as_deref()
    }
}
impl GetBucketAbacInput {
    /// Creates a new builder-style object to manufacture [`GetBucketAbacInput`](crate::operation::get_bucket_abac::GetBucketAbacInput).
    pub fn builder() -> crate::operation::get_bucket_abac::builders::GetBucketAbacInputBuilder {
        crate::operation::get_bucket_abac::builders::GetBucketAbacInputBuilder::default()
    }
}

/// A builder for [`GetBucketAbacInput`](crate::operation::get_bucket_abac::GetBucketAbacInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetBucketAbacInputBuilder {
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl GetBucketAbacInputBuilder {
    /// <p>The name of the general purpose bucket.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the general purpose bucket.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The name of the general purpose bucket.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>The Amazon Web Services account ID of the general purpose bucket's owner.</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expected_bucket_owner = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Web Services account ID of the general purpose bucket's owner.</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expected_bucket_owner = input;
        self
    }
    /// <p>The Amazon Web Services account ID of the general purpose bucket's owner.</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        &self.expected_bucket_owner
    }
    /// Consumes the builder and constructs a [`GetBucketAbacInput`](crate::operation::get_bucket_abac::GetBucketAbacInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::get_bucket_abac::GetBucketAbacInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::get_bucket_abac::GetBucketAbacInput {
            bucket: self.bucket,
            expected_bucket_owner: self.expected_bucket_owner,
        })
    }
}
