// tracker.c -- example robot for C++Robots
//
// Copyright (c) 1997-2003,2006, Richard Rognlie <rrognlie@gamerz.net>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
// 
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
// 
//     * Neither the name of Gamerz.NET Enterprises nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
// 
//     * If you do make any modifications, please drop Richard a note so
//       that he can incorporate interesting patches into the baseline.
// 
// This software is provided by the copyright holders and contributors
// "AS IS" and any express or implied warranties, including, but not
// limited to, the implied warranties of MERCHANTABILITY and FITNESS FOR
// A PARTICULAR PURPOSE are disclaimed.  In no event shall the copyright
// owner or contributors be liable for any direct, indirect, incidental,
// special, exemplary, or consequential damages (including, but not limited
// to, procurement of substitute goods or services; loss of use, data, or
// profits; or business interruption) however caused and on any theory of
// liability, whether in contract, strict liability, or tort (including
// negligence or otherwise) arising in any way out of the use of this
// software, even if advised of the possibility of such damage.

//=========================================================================
// 1) Move around the arena in a box pattern.  Full speed.  staying
//    about 2000 units inside from the wall.
// 2) Scan for a target, and shoot it.  If you had seen a target, and
//    have lost sight, back up the scan a bit and continue scanning.
//=========================================================================

#include "robots.h"

#define BORDER 2000

/* Current position */
static int cx=0;
static int cy=0;

// Shoot at a target if its in range (<= 7000 units) *and* its far
// enough away that we will only be slightly damaged (>200 units) by the
// resulting explosion.
inline void shoot(int dir,int range)
{
    if (range <= 7000 && range > 200) {
		printlog("cannon(%d,%d)",dir,range);
		cannon(dir,range);
	}
}

int main()
{
    int sdir=0;     /* current scan direction */
    int dir=0;      /* current movement direction */
    int range;      /* range to opponent */
    int hadfix=0;   /* did I have a fix on my opponent from the last scan? */
			
    drive(dir,100);  /* start moving right away.  Do not *ever* sit still! */
    
    while (1) {
	int tdir=dir;    /* save current direction */
	cx = loc_x();
	cy = loc_y();
	
	/* do we need to change direction?  (e.g.  are we approaching a wall?) */
	if (cx > 10000-BORDER)
	    if (cy < 10000-BORDER)
		tdir = 90;              /* approaching east wall */
	    else
		tdir = 180;             /* approaching northeast corner */
	else if (cx < BORDER)
	    if (cy < BORDER)
		tdir = 0;               /* approaching southwest corner */
	    else
		tdir = 270;             /* approaching west wall */
	else if (cy > 10000-BORDER)
	    tdir = 180;                 /* approaching north wall */
	else if (cy < BORDER)
	    tdir = 0;                   /* approaching south wall */
	
	/* if speed() == 0,    restart the drive unit... */
	/* if dir != tdir,     we need to change direction... */
	if (!speed() || dir != tdir)
	    drive(dir=tdir,100);
	
	cx = loc_x();
	cy = loc_y();
	if ((range=scan(sdir,10))) {   /* scan for a target... */
	    shoot(sdir,range);         /*   got one.  shoot it! */
	    hadfix=1;                  /*   remember we saw a target */
	}
	else if (hadfix) {             /*   did we lose a target? */
	    sdir += 40;                /*        back up the scan */
	    hadfix=0;                  /*        forget we had a target */
	}
	else
	    sdir -= 20;                 /*   increment the scan */
    }
}
