"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateModels = exports.updateLegacySessionModel = exports.validateModel = void 0;
const validate_1 = require("../kernel/validate");
const validate_2 = require("../validate");
/**
 * Validate an `Session.IModel` object.
 */
function validateModel(data) {
    validate_2.validateProperty(data, 'id', 'string');
    validate_2.validateProperty(data, 'type', 'string');
    validate_2.validateProperty(data, 'name', 'string');
    validate_2.validateProperty(data, 'path', 'string');
    validate_2.validateProperty(data, 'kernel', 'object');
    validate_1.validateModel(data.kernel);
}
exports.validateModel = validateModel;
/**
 * Update model from legacy session data.
 */
function updateLegacySessionModel(data) {
    if (data.path === undefined && data.notebook !== undefined) {
        data.path = data.notebook.path;
        data.type = 'notebook';
        data.name = '';
    }
}
exports.updateLegacySessionModel = updateLegacySessionModel;
/**
 * Validate an array of `Session.IModel` objects.
 */
function validateModels(models) {
    if (!Array.isArray(models)) {
        throw new Error('Invalid session list');
    }
    models.forEach(d => validateModel(d));
}
exports.validateModels = validateModels;
//# sourceMappingURL=validate.js.map