#ifndef MSGLINE_H
#define MSGLINE_H

#include <sys/types.h>
#include <stdarg.h> /* required by some curses.h implementations */
#ifdef NEED_NCURSES
#ifdef HAVE_NCURSES_NCURSES_H
#include <ncurses/ncurses.h>
#else
#include <ncurses.h>
#endif
#else
#include <curses.h>
#endif

#define HISTORY_LEN 16

typedef struct
{
  chtype c;
  const char *str;
} MenuChoice;

void showmsg(const char *fmt, ...);
char *editline(const char *prompt, const char *preset, char *history[HISTORY_LEN]);
int menuline(const char *prompt, const MenuChoice *choice, int curx);
int ok(const char *prompt, int curx);

#endif
