/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.gui.gradient;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import net.gcalc.calc.gui.gradient.Gradient;
import net.gcalc.calc.gui.gradient.Marker;
import net.gcalc.calc.gui.gradient.SimpleGradient;

public class CompoundGradient
extends Gradient
implements Observer {
    private Collection markerCollection = new TreeSet();
    private boolean sorted;
    private Marker[] markers;

    public CompoundGradient() {
        this(Color.black, Color.black);
    }

    public CompoundGradient(Color l, Color r) {
        this(l, r, 0);
    }

    public CompoundGradient(Color l, Color r, int mode) {
        super(mode);
        this.markerCollection.add(new Marker(0.0, r, l, l));
        this.markerCollection.add(new Marker(1.0, r, r, l));
        this.sorted = false;
    }

    public void addMarker(Marker m) {
        this.markerCollection.add(m);
        m.addObserver(this);
        this.sorted = false;
    }

    public void removeMarker(Marker m) {
        this.markerCollection.remove(m);
        m.deleteObserver(this);
        this.sorted = false;
    }

    public Marker[] getMarkers() {
        Marker[] m = new Marker[this.markers.length];
        System.arraycopy(this.markers, 0, m, 0, this.markers.length);
        return this.markers;
    }

    public void compact() {
        Marker[] m = this.getMarkers();
        int i = 0;
        while (i < m.length) {
            double p = m[i].getPosition();
            if (p < 0.0 || p > 1.0) {
                this.removeMarker(m[i]);
            }
            ++i;
        }
        this.sorted = false;
    }

    public Color getColor(double d) {
        if (!this.sorted) {
            this.markers = new Marker[this.markerCollection.size()];
            this.markerCollection.toArray(this.markers);
            Arrays.sort(this.markers);
            this.sorted = true;
        }
        if (d == 1.0) {
            return this.markers[this.markers.length - 1].getCenter();
        }
        if (d == 0.0) {
            return this.markers[0].getCenter();
        }
        int idx = Arrays.binarySearch(this.markers, new Marker(d));
        if (idx >= 0) {
            return this.markers[idx].getCenter();
        }
        idx = -(idx + 1);
        double p = this.markers[idx].getPosition();
        double q = this.markers[idx - 1].getPosition();
        int mode = 1;
        SimpleGradient gradient = new SimpleGradient(this.markers[idx - 1].getRight(), this.markers[idx].getLeft(), mode);
        return gradient.getColor((d - q) / (p - q));
    }

    public void update(Observable m, Object o) {
        this.sorted = false;
    }

    public String toString() {
        return this.markerCollection.toString();
    }
}

