/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.math.functions.UnaryOperation;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.VariableToken;

public class TaylorApproximation
extends UnaryOperation {
    private Function f;
    private double x0;
    private int order;
    private double[] taylorCoeff;

    public TaylorApproximation(ParseTree pt) {
        super(pt);
        SymbolTable st = new SymbolTable();
        ValueTable vt = new ValueTable();
        try {
            this.f = FunctionFactory.getFunction(this.getArg(0));
            this.x0 = FunctionFactory.getFunction(this.getArg(1)).evaluate(st, vt);
            this.order = (int)FunctionFactory.getFunction(this.getArg(2)).evaluate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace(System.out);
            return;
        }
        Function D = this.f;
        this.taylorCoeff = new double[this.order + 1];
        vt.setValue(VariableToken.X_VAR, this.x0);
        int i = 0;
        while (i <= this.order) {
            this.taylorCoeff[i] = D.evaluate(st, vt);
            int j = 2;
            while (j <= i) {
                this.taylorCoeff[i] = this.taylorCoeff[i] / (double)j;
                ++j;
            }
            D = D.derivative(VariableToken.X_VAR);
            ++i;
        }
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        double x = vt.getValue(VariableToken.X_VAR);
        double val = 0.0;
        int i = this.taylorCoeff.length - 1;
        while (i >= 0) {
            val = val * (x - this.x0) + this.taylorCoeff[i];
            --i;
        }
        return val;
    }

    public Function derivative(Vector vars) {
        return NOT_A_NUMBER;
    }
}

