/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.RungeKutta;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.model.IVPModel;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.View;

public class DirectionFieldGraph
extends CartesianGraph
implements MouseListener {
    private Function F;
    private Function G;

    public DirectionFieldGraph(AbstractCartesianGraphPlugin plugin) {
        super(plugin);
        this.getProperties().put(GraphProperties.V_TITLE_STRING, "y");
        this.addMouseListener(this);
    }

    protected Vector makeZoomsVector() {
        Vector v = super.makeZoomsVector();
        int i = v.size() - 1;
        while (i >= 0) {
            if (v.elementAt(i) instanceof CartesianGraph.FitZoom) {
                v.removeElementAt(i);
            }
            --i;
        }
        return v;
    }

    public void setDefaultGraphElements() {
        boolean b = true;
        this.properties.initDefault(GraphProperties.H_AXIS, b);
        this.properties.initDefault(GraphProperties.H_GRID, b);
        this.properties.initDefault(GraphProperties.H_SCALE, b);
        this.properties.initDefault(GraphProperties.V_AXIS, b);
        this.properties.initDefault(GraphProperties.V_GRID, b);
        this.properties.initDefault(GraphProperties.V_SCALE, b);
        this.properties.initDefault(GraphProperties.V_TITLE, b);
        this.properties.initDefault(GraphProperties.H_TITLE, b);
        this.properties.initDefault(GraphProperties.V_LABEL, b);
        this.properties.initDefault(GraphProperties.H_LABEL, b);
        this.properties.initDefault(GraphProperties.INTERACTIVE_ZOOM, b);
    }

    public void drawBackgroundComponents() {
        super.drawBackgroundComponents();
        if (this.F != null && this.G != null) {
            this.drawSystem(this.F, this.G);
        }
    }

    protected void drawSystem(Function f, Function g) {
        Color lightBlue = new Color(200, 200, 255);
        ValueTable vt = new ValueTable();
        View view = this.properties.getViewProperty(GraphProperties.VIEW);
        double xw = view.getRange(0).getWidth();
        double yw = view.getRange(1).getWidth();
        int step = 15;
        int i = 0;
        while (i < this.getWidth()) {
            int j = 0;
            while (j < this.getHeight()) {
                int sx = i + step / 2;
                int sy = j + step / 2;
                double x0 = this.screenXtoCartesian(sx);
                double y0 = this.screenYtoCartesian(sy);
                vt.setValue(VariableToken.X_VAR, x0);
                vt.setValue(VariableToken.Y_VAR, y0);
                double t1 = f.evaluate(vt);
                double t2 = g.evaluate(vt);
                t1 = t1 * (double)this.getWidth() * yw;
                t2 = t2 * (double)this.getHeight() * xw;
                double d = Math.sqrt(t1 * t1 + t2 * t2);
                int dx = (int)((double)(step - 2) * (t1 /= d) / 2.0);
                int dy = -((int)((double)(step - 2) * (t2 /= d) / 2.0));
                this.gr.setColor(lightBlue);
                this.gr.drawLine(sx + dx, sy + dy, sx - dx, sy - dy);
                this.gr.fillRect(sx + dx - 1, sy + dy - 1, 3, 3);
                j += step;
            }
            i += step;
        }
    }

    public void drawSystem(Model model) {
        this.F = model.getFunction(0);
        this.G = model.getFunction(1);
        ModelList modelList = (ModelList)this.properties.get(GraphProperties.MODEL_LIST);
        modelList.removeAllModels();
        this.redrawAll();
    }

    public void draw(RenderableModel model) {
        if (!(model instanceof IVPModel)) {
            return;
        }
        IVPModel ivpModel = (IVPModel)model;
        if (ivpModel.getImage() != null) {
            this.gr.drawImage((Image)ivpModel.getImage(), 0, 0, null);
        } else {
            Point2D.Double p = ivpModel.getPoint();
            BufferedImage modelImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
            this.rungeKuttaMethod(((Point2D)p).getX(), ((Point2D)p).getY(), modelImage.getGraphics(), ivpModel.getColor());
            this.gr.drawImage((Image)modelImage, 0, 0, null);
            ivpModel.setImage(modelImage);
        }
        ivpModel.setDrawn(true);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.F != null && this.G != null) {
            double x0 = this.screenXtoCartesian(e.getX());
            double y0 = this.screenYtoCartesian(e.getY());
            IVPModel model = new IVPModel(new Function[]{this.F, this.G}, new String[]{this.F.toInfix(), this.G.toInfix()}, x0, y0, Color.BLACK);
            ModelList modelList = (ModelList)this.properties.get(GraphProperties.MODEL_LIST);
            modelList.add(model);
            this.redrawAll();
        }
    }

    private void rungeKuttaMethod(double x, double y, double h0, double tmax, Graphics g, Color color) {
        ValueTable vt = new ValueTable();
        SymbolTable st = new SymbolTable();
        int rx = this.cartesianXtoScreen(x);
        int ry = this.cartesianYtoScreen(y);
        double xn = x;
        double yn = y;
        double h = h0;
        double[] u = new double[2];
        double[] v = new double[2];
        g.setColor(Color.orange);
        g.fillRect(rx - 2, ry - 2, 5, 5);
        RungeKutta rk = new RungeKutta();
        int i = 0;
        while ((double)i < tmax) {
            double error = -4.0;
            h = h0;
            do {
                u = rk.oneStep(this.F, this.G, xn, yn, h, vt, st, u);
                v = rk.oneStep(this.F, this.G, xn, yn, h / 2.0, vt, st, v);
                v = rk.oneStep(this.F, this.G, xn, yn, h / 2.0, vt, st, v);
                double dx = Math.abs(u[0] - v[0]);
                double dy = Math.abs(u[1] - v[1]);
                error = Math.max(dx, dy);
                if (Math.abs(h) < 0.01) break;
                if (!(error > 1.0E-7)) continue;
                h *= 0.1;
            } while (error > 1.0E-15);
            xn = v[0];
            yn = v[1];
            int sx = this.cartesianXtoScreen(xn);
            int sy = this.cartesianYtoScreen(yn);
            g.setColor(color);
            if (rx > 0 && ry > 0) {
                g.drawLine(rx, ry, sx, sy);
            }
            rx = sx;
            ry = sy;
            if (rx < 0 || rx >= this.getWidth() || ry < 0 || ry >= this.getHeight()) break;
            ++i;
        }
    }

    private synchronized void rungeKuttaMethod(double x, double y, Graphics gr, Color color) {
        double h = 1.0;
        double tmax = 10000.0;
        this.rungeKuttaMethod(x, y, h, tmax, gr, color);
        this.rungeKuttaMethod(x, y, -h, tmax, gr, color);
        this.repaint();
    }
}

