/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.plugin.plane.gui.ViewTextField;
import net.gcalc.plugin.plane.gui.ZoomIOPanel;
import net.gcalc.plugin.plane.gui.ZoomPanel;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.plugin.properties.Range;
import net.gcalc.plugin.properties.View;

public class ViewPanel
extends JPanel
implements ActionListener {
    private GraphProperties properties;
    private ViewTextField[][] textfields;

    public ViewPanel(GraphProperties gp) {
        this(gp, true);
    }

    public ViewPanel(GraphProperties gp, boolean zooms) {
        this.properties = gp;
        View view = gp.getViewProperty(GraphProperties.VIEW);
        int n = view.getDimension();
        String[] varnames = view.getVarNames();
        JPanel rangePanel = new JPanel(new GridLayout(3 * n, 2));
        this.textfields = new ViewTextField[n][3];
        int i = 0;
        while (i < n) {
            rangePanel.add(new JLabel(String.valueOf(varnames[i]) + " Min"));
            ViewTextField viewTextField = this.makeViewTextField(i, 0);
            this.textfields[i][0] = viewTextField;
            rangePanel.add(viewTextField);
            rangePanel.add(new JLabel(String.valueOf(varnames[i]) + " Max"));
            ViewTextField viewTextField2 = this.makeViewTextField(i, 1);
            this.textfields[i][1] = viewTextField2;
            rangePanel.add(viewTextField2);
            rangePanel.add(new JLabel(String.valueOf(varnames[i]) + " Scale"));
            ViewTextField viewTextField3 = this.makeViewTextField(i, 2);
            this.textfields[i][2] = viewTextField3;
            rangePanel.add(viewTextField3);
            ++i;
        }
        JButton set = new JButton("Set");
        JButton revert = new JButton("Restore");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(set);
        buttonBox.add(revert);
        set.addActionListener(this);
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < 3) {
                revert.addActionListener(this.textfields[i2][j]);
                ++j;
            }
            ++i2;
        }
        Box rangeBox = Box.createVerticalBox();
        rangeBox.add(rangePanel);
        rangeBox.add(buttonBox);
        Box box = Box.createVerticalBox();
        box.add(SwingGUI.wrapTitledBorder(rangeBox, "Ranges"));
        if (zooms) {
            if (this.properties.get(GraphProperties.ZOOMS) != null) {
                box.add(SwingGUI.wrapTitledBorder(new ZoomPanel(this.properties), "Predefined Zooms"));
            }
            box.add(SwingGUI.wrapTitledBorder(new ZoomIOPanel(this.properties), "Zoom In/Out"));
        }
        box.add(Box.createVerticalGlue());
        this.add(box);
        this.properties.setPropertyChanged(GraphProperties.VIEW);
    }

    private ViewTextField makeViewTextField(int var, int field) {
        ViewTextField tf = new ViewTextField(this.properties, var, field);
        tf.addActionListener(this);
        return tf;
    }

    public void actionPerformed(ActionEvent event) {
        double[][] values = new double[this.textfields.length][3];
        Range[] ranges = new Range[this.textfields.length];
        int i = this.textfields.length - 1;
        while (i >= 0) {
            int j = 0;
            while (j < 3) {
                values[i][j] = this.textfields[i][j].getValue();
                if (Double.isNaN(values[i][j])) {
                    this.textfields[i][j].requestFocus();
                    return;
                }
                ++j;
            }
            try {
                ranges[i] = new Range(values[i][0], values[i][1], values[i][2]);
            }
            catch (IllegalArgumentException e) {
                this.textfields[i][0].requestFocus();
                return;
            }
            --i;
        }
        this.properties.put(GraphProperties.VIEW, new View(ranges));
    }
}

