/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.ResourceBundleControlProvider;
import java.util.spi.ResourceBundleProvider;
import sun.util.locale.BaseLocale;
import sun.util.locale.LocaleObjectCache;

public abstract class ResourceBundle {
    private static final int INITIAL_CACHE_SIZE = 32;
    private static final ResourceBundle NONEXISTENT_BUNDLE;
    private static final ConcurrentMap<CacheKey, BundleReference> cacheList;
    private static final ReferenceQueue<Object> referenceQueue;
    protected ResourceBundle parent;
    private Locale locale;
    private String name;
    private volatile boolean expired;
    private volatile CacheKey cacheKey;
    private volatile Set<String> keySet;
    private static final List<ResourceBundleControlProvider> providers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getBaseBundleName() {
        return null;
    }

    public final String getString(String string) {
        return null;
    }

    public final String[] getStringArray(String string) {
        return null;
    }

    public final Object getObject(String string) {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    protected void setParent(ResourceBundle resourceBundle) {
    }

    public static final ResourceBundle getBundle(String string) {
        return null;
    }

    public static final ResourceBundle getBundle(String string, Control control) {
        return null;
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return null;
    }

    public static final ResourceBundle getBundle(String string, Locale locale, Control control) {
        return null;
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        return null;
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, Control control) {
        return null;
    }

    public static final void clearCache() {
    }

    public static final void clearCache(ClassLoader classLoader) {
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    public boolean containsKey(String string) {
        return false;
    }

    public Set<String> keySet() {
        return null;
    }

    protected Set<String> handleKeySet() {
        return null;
    }

    private static final class NoFallbackControl
    extends SingleFormatControl {
        private static final Control NO_FALLBACK = new NoFallbackControl(FORMAT_DEFAULT);
        private static final Control PROPERTIES_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_CLASS);

        protected NoFallbackControl(List<String> formats) {
            super(formats);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class SingleFormatControl
    extends Control {
        private static final Control PROPERTIES_ONLY = new SingleFormatControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY = new SingleFormatControl(FORMAT_CLASS);
        private final List<String> formats;

        protected SingleFormatControl(List<String> formats) {
            this.formats = formats;
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return this.formats;
        }
    }

    public static class Control {
        public static final List<String> FORMAT_DEFAULT;
        public static final List<String> FORMAT_CLASS;
        public static final List<String> FORMAT_PROPERTIES;
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control INSTANCE;
        private static final CandidateListCache CANDIDATES_CACHE;

        protected Control() {
        }

        public static final Control getControl(List<String> list) {
            return null;
        }

        public static final Control getNoFallbackControl(List<String> list) {
            return null;
        }

        public List<String> getFormats(String string) {
            return null;
        }

        public List<Locale> getCandidateLocales(String string, Locale locale) {
            return null;
        }

        public Locale getFallbackLocale(String string, Locale locale) {
            return null;
        }

        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            return null;
        }

        public long getTimeToLive(String string, Locale locale) {
            return 0L;
        }

        public boolean needsReload(String string, Locale locale, String string2, ClassLoader classLoader, ResourceBundle resourceBundle, long l) {
            return false;
        }

        public String toBundleName(String string, Locale locale) {
            return null;
        }

        public final String toResourceName(String string, String string2) {
            return null;
        }

        private static class CandidateListCache
        extends LocaleObjectCache<BaseLocale, List<Locale>> {
            private CandidateListCache() {
            }

            @Override
            protected List<Locale> createObject(BaseLocale base) {
                String language = base.getLanguage();
                String script = base.getScript();
                String region = base.getRegion();
                String variant = base.getVariant();
                boolean isNorwegianBokmal = false;
                boolean isNorwegianNynorsk = false;
                if (language.equals("no")) {
                    if (region.equals("NO") && variant.equals("NY")) {
                        variant = "";
                        isNorwegianNynorsk = true;
                    } else {
                        isNorwegianBokmal = true;
                    }
                }
                if (language.equals("nb") || isNorwegianBokmal) {
                    List<Locale> tmpList = CandidateListCache.getDefaultList("nb", script, region, variant);
                    ArrayList<Locale> bokmalList = new ArrayList<Locale>();
                    for (Locale l_nb : tmpList) {
                        boolean isRoot = l_nb.getLanguage().isEmpty();
                        Locale l_no = Locale.getInstance((String)(isRoot ? "" : "no"), (String)l_nb.getScript(), (String)l_nb.getCountry(), (String)l_nb.getVariant(), null);
                        bokmalList.add(isNorwegianBokmal ? l_no : l_nb);
                        if (isRoot) break;
                        bokmalList.add(isNorwegianBokmal ? l_nb : l_no);
                    }
                    return bokmalList;
                }
                if (language.equals("nn") || isNorwegianNynorsk) {
                    List<Locale> nynorskList = CandidateListCache.getDefaultList("nn", script, region, variant);
                    int idx = nynorskList.size() - 1;
                    nynorskList.add(idx++, Locale.getInstance((String)"no", (String)"NO", (String)"NY"));
                    nynorskList.add(idx++, Locale.getInstance((String)"no", (String)"NO", (String)""));
                    nynorskList.add(idx++, Locale.getInstance((String)"no", (String)"", (String)""));
                    return nynorskList;
                }
                if (language.equals("zh") && script.isEmpty() && !region.isEmpty()) {
                    switch (region) {
                        case "TW": 
                        case "HK": 
                        case "MO": {
                            script = "Hant";
                            break;
                        }
                        case "CN": 
                        case "SG": {
                            script = "Hans";
                        }
                    }
                }
                return CandidateListCache.getDefaultList(language, script, region, variant);
            }

            private static List<Locale> getDefaultList(String language, String script, String region, String variant) {
                ArrayList<String> variants = null;
                if (!variant.isEmpty()) {
                    variants = new ArrayList<String>();
                    int idx = variant.length();
                    while (idx != -1) {
                        variants.add(variant.substring(0, idx));
                        --idx;
                        idx = variant.lastIndexOf(95, idx);
                    }
                }
                ArrayList<Locale> list = new ArrayList<Locale>();
                if (variants != null) {
                    for (String v : variants) {
                        list.add(Locale.getInstance((String)language, (String)script, (String)region, (String)v, null));
                    }
                }
                if (!region.isEmpty()) {
                    list.add(Locale.getInstance((String)language, (String)script, (String)region, (String)"", null));
                }
                if (!script.isEmpty()) {
                    list.add(Locale.getInstance((String)language, (String)script, (String)"", (String)"", null));
                    if (language.equals("zh") && region.isEmpty()) {
                        switch (script) {
                            case "Hans": {
                                region = "CN";
                                break;
                            }
                            case "Hant": {
                                region = "TW";
                            }
                        }
                    }
                    if (variants != null) {
                        for (String v : variants) {
                            list.add(Locale.getInstance((String)language, (String)"", (String)region, (String)v, null));
                        }
                    }
                    if (!region.isEmpty()) {
                        list.add(Locale.getInstance((String)language, (String)"", (String)region, (String)"", null));
                    }
                }
                if (!language.isEmpty()) {
                    list.add(Locale.getInstance((String)language, (String)"", (String)"", (String)"", null));
                }
                list.add(Locale.ROOT);
                return list;
            }
        }
    }

    private static class BundleReference
    extends SoftReference<ResourceBundle>
    implements CacheKeyReference {
        private final CacheKey cacheKey;

        BundleReference(ResourceBundle referent, ReferenceQueue<Object> q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static interface CacheKeyReference {
        public CacheKey getCacheKey();
    }

    private static final class CacheKey {
        private final String name;
        private volatile Locale locale;
        private final KeyElementReference<Module> moduleRef;
        private final KeyElementReference<Module> callerRef;
        private final int modulesHash;
        private volatile String format;
        private volatile long loadTime;
        private volatile long expirationTime;
        private volatile Throwable cause;
        private volatile ServiceLoader<ResourceBundleProvider> providers;
        private volatile boolean providersChecked;
        private volatile Boolean callerHasProvider;

        CacheKey(String baseName, Locale locale, Module module, Module caller) {
            Objects.requireNonNull(module);
            Objects.requireNonNull(caller);
            this.name = baseName;
            this.locale = locale;
            this.moduleRef = new KeyElementReference<Module>(module, referenceQueue, this);
            this.callerRef = new KeyElementReference<Module>(caller, referenceQueue, this);
            this.modulesHash = module.hashCode() ^ caller.hashCode();
        }

        CacheKey(CacheKey src) {
            this.moduleRef = new KeyElementReference<Module>(Objects.requireNonNull(src.getModule()), referenceQueue, this);
            this.callerRef = new KeyElementReference<Module>(Objects.requireNonNull(src.getCallerModule()), referenceQueue, this);
            this.name = src.name;
            this.locale = src.locale;
            this.modulesHash = src.modulesHash;
            this.format = src.format;
            this.loadTime = src.loadTime;
            this.expirationTime = src.expirationTime;
        }

        String getName() {
            return this.name;
        }

        Locale getLocale() {
            return this.locale;
        }

        CacheKey setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        Module getModule() {
            return (Module)this.moduleRef.get();
        }

        Module getCallerModule() {
            return (Module)this.callerRef.get();
        }

        ServiceLoader<ResourceBundleProvider> getProviders() {
            if (!this.providersChecked) {
                this.providers = ResourceBundle.getServiceLoader((Module)this.getModule(), (String)this.name);
                this.providersChecked = true;
            }
            return this.providers;
        }

        boolean hasProviders() {
            return this.getProviders() != null;
        }

        boolean callerHasProvider() {
            return this.callerHasProvider == Boolean.TRUE;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                CacheKey otherEntry = (CacheKey)other;
                if (this.modulesHash != otherEntry.modulesHash) {
                    return false;
                }
                if (!this.name.equals(otherEntry.name)) {
                    return false;
                }
                if (!this.locale.equals(otherEntry.locale)) {
                    return false;
                }
                Module module = this.getModule();
                Module caller = this.getCallerModule();
                return module != null && module.equals(otherEntry.getModule()) && caller != null && caller.equals(otherEntry.getCallerModule());
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        public int hashCode() {
            return this.name.hashCode() << 3 ^ this.locale.hashCode() ^ this.modulesHash;
        }

        String getFormat() {
            return this.format;
        }

        void setFormat(String format) {
            this.format = format;
        }

        private void setCause(Throwable cause) {
            if (this.cause == null) {
                this.cause = cause;
            } else if (this.cause instanceof ClassNotFoundException) {
                this.cause = cause;
            }
        }

        private Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            String l = this.locale.toString();
            if (l.isEmpty()) {
                l = !this.locale.getVariant().isEmpty() ? "__" + this.locale.getVariant() : "\"\"";
            }
            return "CacheKey[" + this.name + ", locale=" + l + ", module=" + this.getModule() + ", callerModule=" + this.getCallerModule() + ", format=" + this.format + "]";
        }
    }
}

