// DO NOT EDIT: This file is autogenerated via the builtin command.

package http

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 95,
					Line:   38,
				},
				File:   "http_endpoint_test.flux",
				Source: "package http_test\n\nimport \"testing\"\nimport \"http\"\nimport \"json\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n\"\n\nendpoint = http.endpoint(url:\"http://localhost:7777\")\n\npost = (table=<-) =>\n    table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> endpoint(mapFn:(r) => ({data: json.encode(v: r)}))()\n\ntest _post = () =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   7,
						},
						File:   "http_endpoint_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "http_endpoint_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   7,
							},
							File:   "http_endpoint_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   7,
								},
								File:   "http_endpoint_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   7,
									},
									File:   "http_endpoint_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   7,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   7,
					},
					File:   "http_endpoint_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   17,
					},
					File:   "http_endpoint_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "http_endpoint_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   17,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "http_endpoint_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   19,
						},
						File:   "http_endpoint_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   19,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   19,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true,true\n#default,_result,,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path,_sent\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/,true\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/,true\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 54,
						Line:   29,
					},
					File:   "http_endpoint_test.flux",
					Source: "endpoint = http.endpoint(url:\"http://localhost:7777\")",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   29,
						},
						File:   "http_endpoint_test.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   29,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   29,
							},
							File:   "http_endpoint_test.flux",
							Source: "url:\"http://localhost:7777\"",
							Start: ast.Position{
								Column: 26,
								Line:   29,
							},
						},
					},
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   29,
								},
								File:   "http_endpoint_test.flux",
								Source: "url:\"http://localhost:7777\"",
								Start: ast.Position{
									Column: 26,
									Line:   29,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   29,
									},
									File:   "http_endpoint_test.flux",
									Source: "url",
									Start: ast.Position{
										Column: 26,
										Line:   29,
									},
								},
							},
							Name: "url",
						},
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   29,
									},
									File:   "http_endpoint_test.flux",
									Source: "\"http://localhost:7777\"",
									Start: ast.Position{
										Column: 30,
										Line:   29,
									},
								},
							},
							Value: "http://localhost:7777",
						},
					}},
					With: nil,
				}},
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   29,
						},
						File:   "http_endpoint_test.flux",
						Source: "http.endpoint(url:\"http://localhost:7777\")",
						Start: ast.Position{
							Column: 12,
							Line:   29,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   29,
							},
							File:   "http_endpoint_test.flux",
							Source: "http.endpoint",
							Start: ast.Position{
								Column: 12,
								Line:   29,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   29,
								},
								File:   "http_endpoint_test.flux",
								Source: "http",
								Start: ast.Position{
									Column: 12,
									Line:   29,
								},
							},
						},
						Name: "http",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   29,
								},
								File:   "http_endpoint_test.flux",
								Source: "endpoint",
								Start: ast.Position{
									Column: 17,
									Line:   29,
								},
							},
						},
						Name: "endpoint",
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 64,
						Line:   35,
					},
					File:   "http_endpoint_test.flux",
					Source: "post = (table=<-) =>\n    table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> endpoint(mapFn:(r) => ({data: json.encode(v: r)}))()",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   31,
						},
						File:   "http_endpoint_test.flux",
						Source: "post",
						Start: ast.Position{
							Column: 1,
							Line:   31,
						},
					},
				},
				Name: "post",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 64,
							Line:   35,
						},
						File:   "http_endpoint_test.flux",
						Source: "(table=<-) =>\n    table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> endpoint(mapFn:(r) => ({data: json.encode(v: r)}))()",
						Start: ast.Position{
							Column: 8,
							Line:   31,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   32,
										},
										File:   "http_endpoint_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 5,
											Line:   32,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   33,
									},
									File:   "http_endpoint_test.flux",
									Source: "table\n        |> range(start:2018-05-22T00:00:00Z)",
									Start: ast.Position{
										Column: 5,
										Line:   32,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   33,
											},
											File:   "http_endpoint_test.flux",
											Source: "start:2018-05-22T00:00:00Z",
											Start: ast.Position{
												Column: 18,
												Line:   33,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   33,
												},
												File:   "http_endpoint_test.flux",
												Source: "start:2018-05-22T00:00:00Z",
												Start: ast.Position{
													Column: 18,
													Line:   33,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   33,
													},
													File:   "http_endpoint_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 18,
														Line:   33,
													},
												},
											},
											Name: "start",
										},
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   33,
													},
													File:   "http_endpoint_test.flux",
													Source: "2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 24,
														Line:   33,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   33,
										},
										File:   "http_endpoint_test.flux",
										Source: "range(start:2018-05-22T00:00:00Z)",
										Start: ast.Position{
											Column: 12,
											Line:   33,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   33,
											},
											File:   "http_endpoint_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 12,
												Line:   33,
											},
										},
									},
									Name: "range",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   34,
								},
								File:   "http_endpoint_test.flux",
								Source: "table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 5,
									Line:   32,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   34,
										},
										File:   "http_endpoint_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 17,
											Line:   34,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   34,
											},
											File:   "http_endpoint_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 17,
												Line:   34,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   34,
												},
												File:   "http_endpoint_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   34,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   34,
												},
												File:   "http_endpoint_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 26,
													Line:   34,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 27,
														Line:   34,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   34,
													},
													File:   "http_endpoint_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 37,
														Line:   34,
													},
												},
											},
											Value: "_stop",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   34,
									},
									File:   "http_endpoint_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 12,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   34,
										},
										File:   "http_endpoint_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 12,
											Line:   34,
										},
									},
								},
								Name: "drop",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   35,
							},
							File:   "http_endpoint_test.flux",
							Source: "table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> endpoint(mapFn:(r) => ({data: json.encode(v: r)}))()",
							Start: ast.Position{
								Column: 5,
								Line:   32,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   35,
								},
								File:   "http_endpoint_test.flux",
								Source: "endpoint(mapFn:(r) => ({data: json.encode(v: r)}))()",
								Start: ast.Position{
									Column: 12,
									Line:   35,
								},
							},
						},
						Callee: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   35,
										},
										File:   "http_endpoint_test.flux",
										Source: "mapFn:(r) => ({data: json.encode(v: r)})",
										Start: ast.Position{
											Column: 21,
											Line:   35,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   35,
											},
											File:   "http_endpoint_test.flux",
											Source: "mapFn:(r) => ({data: json.encode(v: r)})",
											Start: ast.Position{
												Column: 21,
												Line:   35,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   35,
												},
												File:   "http_endpoint_test.flux",
												Source: "mapFn",
												Start: ast.Position{
													Column: 21,
													Line:   35,
												},
											},
										},
										Name: "mapFn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   35,
												},
												File:   "http_endpoint_test.flux",
												Source: "(r) => ({data: json.encode(v: r)})",
												Start: ast.Position{
													Column: 27,
													Line:   35,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   35,
													},
													File:   "http_endpoint_test.flux",
													Source: "({data: json.encode(v: r)})",
													Start: ast.Position{
														Column: 34,
														Line:   35,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   35,
														},
														File:   "http_endpoint_test.flux",
														Source: "{data: json.encode(v: r)}",
														Start: ast.Position{
															Column: 35,
															Line:   35,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   35,
															},
															File:   "http_endpoint_test.flux",
															Source: "data: json.encode(v: r)",
															Start: ast.Position{
																Column: 36,
																Line:   35,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   35,
																},
																File:   "http_endpoint_test.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 36,
																	Line:   35,
																},
															},
														},
														Name: "data",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   35,
																	},
																	File:   "http_endpoint_test.flux",
																	Source: "v: r",
																	Start: ast.Position{
																		Column: 54,
																		Line:   35,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																		File:   "http_endpoint_test.flux",
																		Source: "v: r",
																		Start: ast.Position{
																			Column: 54,
																			Line:   35,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   35,
																			},
																			File:   "http_endpoint_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 54,
																				Line:   35,
																			},
																		},
																	},
																	Name: "v",
																},
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   35,
																			},
																			File:   "http_endpoint_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 57,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   35,
																},
																File:   "http_endpoint_test.flux",
																Source: "json.encode(v: r)",
																Start: ast.Position{
																	Column: 42,
																	Line:   35,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   35,
																	},
																	File:   "http_endpoint_test.flux",
																	Source: "json.encode",
																	Start: ast.Position{
																		Column: 42,
																		Line:   35,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   35,
																		},
																		File:   "http_endpoint_test.flux",
																		Source: "json",
																		Start: ast.Position{
																			Column: 42,
																			Line:   35,
																		},
																	},
																},
																Name: "json",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   35,
																		},
																		File:   "http_endpoint_test.flux",
																		Source: "encode",
																		Start: ast.Position{
																			Column: 47,
																			Line:   35,
																		},
																	},
																},
																Name: "encode",
															},
														},
													},
												}},
												With: nil,
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   35,
													},
													File:   "http_endpoint_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 28,
														Line:   35,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   35,
														},
														File:   "http_endpoint_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 28,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   35,
									},
									File:   "http_endpoint_test.flux",
									Source: "endpoint(mapFn:(r) => ({data: json.encode(v: r)}))",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   35,
										},
										File:   "http_endpoint_test.flux",
										Source: "endpoint",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Name: "endpoint",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   31,
							},
							File:   "http_endpoint_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 9,
								Line:   31,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   31,
								},
								File:   "http_endpoint_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 9,
									Line:   31,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   31,
							},
							File:   "http_endpoint_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 15,
								Line:   31,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 95,
							Line:   38,
						},
						File:   "http_endpoint_test.flux",
						Source: "_post = () =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   37,
							},
							File:   "http_endpoint_test.flux",
							Source: "_post",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_post",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   38,
							},
							File:   "http_endpoint_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
							Start: ast.Position{
								Column: 14,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   38,
								},
								File:   "http_endpoint_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
								Start: ast.Position{
									Column: 5,
									Line:   38,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   38,
									},
									File:   "http_endpoint_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post}",
									Start: ast.Position{
										Column: 6,
										Line:   38,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   38,
										},
										File:   "http_endpoint_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 7,
											Line:   38,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   38,
											},
											File:   "http_endpoint_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   38,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   38,
												},
												File:   "http_endpoint_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 34,
													Line:   38,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   38,
													},
													File:   "http_endpoint_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 34,
														Line:   38,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   38,
														},
														File:   "http_endpoint_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   38,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   38,
														},
														File:   "http_endpoint_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 39,
															Line:   38,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   38,
											},
											File:   "http_endpoint_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 14,
												Line:   38,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   38,
												},
												File:   "http_endpoint_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   38,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   38,
													},
													File:   "http_endpoint_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   38,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   38,
													},
													File:   "http_endpoint_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   38,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   38,
										},
										File:   "http_endpoint_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 48,
											Line:   38,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   38,
											},
											File:   "http_endpoint_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 48,
												Line:   38,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   38,
												},
												File:   "http_endpoint_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 70,
													Line:   38,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   38,
													},
													File:   "http_endpoint_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 70,
														Line:   38,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   38,
														},
														File:   "http_endpoint_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 70,
															Line:   38,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   38,
														},
														File:   "http_endpoint_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 75,
															Line:   38,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   38,
											},
											File:   "http_endpoint_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 54,
												Line:   38,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   38,
												},
												File:   "http_endpoint_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 54,
													Line:   38,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   38,
													},
													File:   "http_endpoint_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 54,
														Line:   38,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   38,
													},
													File:   "http_endpoint_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 62,
														Line:   38,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 93,
											Line:   38,
										},
										File:   "http_endpoint_test.flux",
										Source: "fn: post",
										Start: ast.Position{
											Column: 85,
											Line:   38,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   38,
											},
											File:   "http_endpoint_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 85,
												Line:   38,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 93,
												Line:   38,
											},
											File:   "http_endpoint_test.flux",
											Source: "post",
											Start: ast.Position{
												Column: 89,
												Line:   38,
											},
										},
									},
									Name: "post",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 95,
						Line:   38,
					},
					File:   "http_endpoint_test.flux",
					Source: "test _post = () =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: post})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "http_endpoint_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "http_endpoint_test.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "http_endpoint_test.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "http_endpoint_test.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "http_endpoint_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "http_endpoint_test.flux",
					Source: "package http_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "http_endpoint_test.flux",
						Source: "http_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "http_test",
			},
		},
	}},
	Package: "http_test",
	Path:    "http",
}}
