// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/servicecontrol/v1/service_controller.proto

package servicecontrol

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for the Check method.
type CheckRequest struct {
	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See
	// [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
	// for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The operation to be checked.
	Operation *Operation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// Specifies which version of service configuration should be used to process
	// the request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId      string   `protobuf:"bytes,4,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckRequest) Reset()         { *m = CheckRequest{} }
func (m *CheckRequest) String() string { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()    {}
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{0}
}

func (m *CheckRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckRequest.Unmarshal(m, b)
}
func (m *CheckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckRequest.Marshal(b, m, deterministic)
}
func (m *CheckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckRequest.Merge(m, src)
}
func (m *CheckRequest) XXX_Size() int {
	return xxx_messageInfo_CheckRequest.Size(m)
}
func (m *CheckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckRequest proto.InternalMessageInfo

func (m *CheckRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *CheckRequest) GetOperation() *Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CheckRequest) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

// Response message for the Check method.
type CheckResponse struct {
	// The same operation_id value used in the
	// [CheckRequest][google.api.servicecontrol.v1.CheckRequest]. Used for logging
	// and diagnostics purposes.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// The current service rollout id used to process the request.
	ServiceRolloutId string `protobuf:"bytes,11,opt,name=service_rollout_id,json=serviceRolloutId,proto3" json:"service_rollout_id,omitempty"`
	// Indicate the decision of the check.
	//
	// If no check errors are present, the service should process the operation.
	// Otherwise the service should use the list of errors to determine the
	// appropriate action.
	CheckErrors []*CheckError `protobuf:"bytes,2,rep,name=check_errors,json=checkErrors,proto3" json:"check_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,5,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
	// Feedback data returned from the server during processing a Check request.
	CheckInfo            *CheckResponse_CheckInfo `protobuf:"bytes,6,opt,name=check_info,json=checkInfo,proto3" json:"check_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CheckResponse) Reset()         { *m = CheckResponse{} }
func (m *CheckResponse) String() string { return proto.CompactTextString(m) }
func (*CheckResponse) ProtoMessage()    {}
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{1}
}

func (m *CheckResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckResponse.Unmarshal(m, b)
}
func (m *CheckResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckResponse.Marshal(b, m, deterministic)
}
func (m *CheckResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse.Merge(m, src)
}
func (m *CheckResponse) XXX_Size() int {
	return xxx_messageInfo_CheckResponse.Size(m)
}
func (m *CheckResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse proto.InternalMessageInfo

func (m *CheckResponse) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *CheckResponse) GetServiceRolloutId() string {
	if m != nil {
		return m.ServiceRolloutId
	}
	return ""
}

func (m *CheckResponse) GetCheckErrors() []*CheckError {
	if m != nil {
		return m.CheckErrors
	}
	return nil
}

func (m *CheckResponse) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

func (m *CheckResponse) GetCheckInfo() *CheckResponse_CheckInfo {
	if m != nil {
		return m.CheckInfo
	}
	return nil
}

type CheckResponse_CheckInfo struct {
	// Consumer info of this check.
	ConsumerInfo         *CheckResponse_ConsumerInfo `protobuf:"bytes,2,opt,name=consumer_info,json=consumerInfo,proto3" json:"consumer_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *CheckResponse_CheckInfo) Reset()         { *m = CheckResponse_CheckInfo{} }
func (m *CheckResponse_CheckInfo) String() string { return proto.CompactTextString(m) }
func (*CheckResponse_CheckInfo) ProtoMessage()    {}
func (*CheckResponse_CheckInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{1, 0}
}

func (m *CheckResponse_CheckInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckResponse_CheckInfo.Unmarshal(m, b)
}
func (m *CheckResponse_CheckInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckResponse_CheckInfo.Marshal(b, m, deterministic)
}
func (m *CheckResponse_CheckInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse_CheckInfo.Merge(m, src)
}
func (m *CheckResponse_CheckInfo) XXX_Size() int {
	return xxx_messageInfo_CheckResponse_CheckInfo.Size(m)
}
func (m *CheckResponse_CheckInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse_CheckInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse_CheckInfo proto.InternalMessageInfo

func (m *CheckResponse_CheckInfo) GetConsumerInfo() *CheckResponse_ConsumerInfo {
	if m != nil {
		return m.ConsumerInfo
	}
	return nil
}

// `ConsumerInfo` provides information about the consumer project.
type CheckResponse_ConsumerInfo struct {
	// The Google cloud project number, e.g. 1234567890. A value of 0 indicates
	// no project number is found.
	ProjectNumber        int64    `protobuf:"varint,1,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckResponse_ConsumerInfo) Reset()         { *m = CheckResponse_ConsumerInfo{} }
func (m *CheckResponse_ConsumerInfo) String() string { return proto.CompactTextString(m) }
func (*CheckResponse_ConsumerInfo) ProtoMessage()    {}
func (*CheckResponse_ConsumerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{1, 1}
}

func (m *CheckResponse_ConsumerInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckResponse_ConsumerInfo.Unmarshal(m, b)
}
func (m *CheckResponse_ConsumerInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckResponse_ConsumerInfo.Marshal(b, m, deterministic)
}
func (m *CheckResponse_ConsumerInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse_ConsumerInfo.Merge(m, src)
}
func (m *CheckResponse_ConsumerInfo) XXX_Size() int {
	return xxx_messageInfo_CheckResponse_ConsumerInfo.Size(m)
}
func (m *CheckResponse_ConsumerInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse_ConsumerInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse_ConsumerInfo proto.InternalMessageInfo

func (m *CheckResponse_ConsumerInfo) GetProjectNumber() int64 {
	if m != nil {
		return m.ProjectNumber
	}
	return 0
}

// Request message for the Report method.
type ReportRequest struct {
	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See
	// [google.api.Service](https://cloud.google.com/service-management/reference/rpc/google.api#google.api.Service)
	// for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Operations to be reported.
	//
	// Typically the service should report one operation per request.
	// Putting multiple operations into a single request is allowed, but should
	// be used only when multiple operations are natually available at the time
	// of the report.
	//
	// If multiple operations are in a single request, the total request size
	// should be no larger than 1MB. See
	// [ReportResponse.report_errors][google.api.servicecontrol.v1.ReportResponse.report_errors]
	// for partial failure behavior.
	Operations []*Operation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// Specifies which version of service config should be used to process the
	// request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId      string   `protobuf:"bytes,3,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportRequest) Reset()         { *m = ReportRequest{} }
func (m *ReportRequest) String() string { return proto.CompactTextString(m) }
func (*ReportRequest) ProtoMessage()    {}
func (*ReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{2}
}

func (m *ReportRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportRequest.Unmarshal(m, b)
}
func (m *ReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportRequest.Marshal(b, m, deterministic)
}
func (m *ReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportRequest.Merge(m, src)
}
func (m *ReportRequest) XXX_Size() int {
	return xxx_messageInfo_ReportRequest.Size(m)
}
func (m *ReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportRequest proto.InternalMessageInfo

func (m *ReportRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ReportRequest) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ReportRequest) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

// Response message for the Report method.
type ReportResponse struct {
	// Partial failures, one for each `Operation` in the request that failed
	// processing. There are three possible combinations of the RPC status:
	//
	// 1. The combination of a successful RPC status and an empty `report_errors`
	//    list indicates a complete success where all `Operations` in the
	//    request are processed successfully.
	// 2. The combination of a successful RPC status and a non-empty
	//    `report_errors` list indicates a partial success where some
	//    `Operations` in the request succeeded. Each
	//    `Operation` that failed processing has a corresponding item
	//    in this list.
	// 3. A failed RPC status indicates a general non-deterministic failure.
	//    When this happens, it's impossible to know which of the
	//    'Operations' in the request succeeded or failed.
	ReportErrors []*ReportResponse_ReportError `protobuf:"bytes,1,rep,name=report_errors,json=reportErrors,proto3" json:"report_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,2,opt,name=service_config_id,json=serviceConfigId,proto3" json:"service_config_id,omitempty"`
	// The current service rollout id used to process the request.
	ServiceRolloutId     string   `protobuf:"bytes,4,opt,name=service_rollout_id,json=serviceRolloutId,proto3" json:"service_rollout_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportResponse) Reset()         { *m = ReportResponse{} }
func (m *ReportResponse) String() string { return proto.CompactTextString(m) }
func (*ReportResponse) ProtoMessage()    {}
func (*ReportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{3}
}

func (m *ReportResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportResponse.Unmarshal(m, b)
}
func (m *ReportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportResponse.Marshal(b, m, deterministic)
}
func (m *ReportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportResponse.Merge(m, src)
}
func (m *ReportResponse) XXX_Size() int {
	return xxx_messageInfo_ReportResponse.Size(m)
}
func (m *ReportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportResponse proto.InternalMessageInfo

func (m *ReportResponse) GetReportErrors() []*ReportResponse_ReportError {
	if m != nil {
		return m.ReportErrors
	}
	return nil
}

func (m *ReportResponse) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

func (m *ReportResponse) GetServiceRolloutId() string {
	if m != nil {
		return m.ServiceRolloutId
	}
	return ""
}

// Represents the processing error of one
// [Operation][google.api.servicecontrol.v1.Operation] in the request.
type ReportResponse_ReportError struct {
	// The
	// [Operation.operation_id][google.api.servicecontrol.v1.Operation.operation_id]
	// value from the request.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Details of the error when processing the
	// [Operation][google.api.servicecontrol.v1.Operation].
	Status               *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ReportResponse_ReportError) Reset()         { *m = ReportResponse_ReportError{} }
func (m *ReportResponse_ReportError) String() string { return proto.CompactTextString(m) }
func (*ReportResponse_ReportError) ProtoMessage()    {}
func (*ReportResponse_ReportError) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f215053b51b20e0, []int{3, 0}
}

func (m *ReportResponse_ReportError) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportResponse_ReportError.Unmarshal(m, b)
}
func (m *ReportResponse_ReportError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportResponse_ReportError.Marshal(b, m, deterministic)
}
func (m *ReportResponse_ReportError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportResponse_ReportError.Merge(m, src)
}
func (m *ReportResponse_ReportError) XXX_Size() int {
	return xxx_messageInfo_ReportResponse_ReportError.Size(m)
}
func (m *ReportResponse_ReportError) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportResponse_ReportError.DiscardUnknown(m)
}

var xxx_messageInfo_ReportResponse_ReportError proto.InternalMessageInfo

func (m *ReportResponse_ReportError) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *ReportResponse_ReportError) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*CheckRequest)(nil), "google.api.servicecontrol.v1.CheckRequest")
	proto.RegisterType((*CheckResponse)(nil), "google.api.servicecontrol.v1.CheckResponse")
	proto.RegisterType((*CheckResponse_CheckInfo)(nil), "google.api.servicecontrol.v1.CheckResponse.CheckInfo")
	proto.RegisterType((*CheckResponse_ConsumerInfo)(nil), "google.api.servicecontrol.v1.CheckResponse.ConsumerInfo")
	proto.RegisterType((*ReportRequest)(nil), "google.api.servicecontrol.v1.ReportRequest")
	proto.RegisterType((*ReportResponse)(nil), "google.api.servicecontrol.v1.ReportResponse")
	proto.RegisterType((*ReportResponse_ReportError)(nil), "google.api.servicecontrol.v1.ReportResponse.ReportError")
}

func init() {
	proto.RegisterFile("google/api/servicecontrol/v1/service_controller.proto", fileDescriptor_8f215053b51b20e0)
}

var fileDescriptor_8f215053b51b20e0 = []byte{
	// 645 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0x4d, 0x6e, 0xd3, 0x40,
	0x14, 0xd6, 0x38, 0x6d, 0xa4, 0x3c, 0x3b, 0x85, 0xce, 0x02, 0x22, 0xab, 0x8b, 0xd4, 0x12, 0x34,
	0x4a, 0x83, 0xad, 0x16, 0x55, 0x42, 0x65, 0x45, 0xab, 0xaa, 0x0a, 0x48, 0xa5, 0x72, 0x59, 0x21,
	0xaa, 0xc8, 0x9d, 0x4c, 0x8d, 0x4b, 0x32, 0x63, 0xc6, 0x4e, 0x37, 0x88, 0x0d, 0x07, 0x60, 0x51,
	0x6e, 0x80, 0x90, 0x7a, 0x06, 0xae, 0x01, 0x57, 0xe0, 0x10, 0x2c, 0x91, 0x67, 0xc6, 0xae, 0x2b,
	0x8c, 0x49, 0x76, 0x99, 0xf7, 0xf7, 0x7d, 0xef, 0xbd, 0xcf, 0x2f, 0xb0, 0x13, 0x72, 0x1e, 0x4e,
	0xa8, 0x17, 0xc4, 0x91, 0x97, 0x50, 0x71, 0x19, 0x11, 0x4a, 0x38, 0x4b, 0x05, 0x9f, 0x78, 0x97,
	0x5b, 0xb9, 0x65, 0xa4, 0x4d, 0x13, 0x2a, 0xdc, 0x58, 0xf0, 0x94, 0xe3, 0x35, 0x95, 0xe6, 0x06,
	0x71, 0xe4, 0xde, 0x4e, 0x73, 0x2f, 0xb7, 0xec, 0xb5, 0x52, 0xd1, 0x80, 0x31, 0x9e, 0x06, 0x69,
	0xc4, 0x59, 0xa2, 0x72, 0x6d, 0xb7, 0x16, 0x92, 0xbc, 0xa5, 0xe4, 0xdd, 0x88, 0x0a, 0xc1, 0x35,
	0x96, 0x3d, 0xa8, 0x8d, 0xe7, 0x31, 0x15, 0xb2, 0xbc, 0x8e, 0xbe, 0xaf, 0xa3, 0x45, 0x4c, 0xbc,
	0x24, 0x0d, 0xd2, 0x99, 0x86, 0x75, 0xbe, 0x21, 0xb0, 0xf6, 0xb3, 0xe2, 0x3e, 0x7d, 0x3f, 0xa3,
	0x49, 0x8a, 0xd7, 0xc1, 0xca, 0xfb, 0x63, 0xc1, 0x94, 0x76, 0x50, 0x17, 0xf5, 0x5a, 0xbe, 0xa9,
	0x6d, 0x47, 0xc1, 0x94, 0xe2, 0x03, 0x68, 0x15, 0xf5, 0x3b, 0x46, 0x17, 0xf5, 0xcc, 0xed, 0x0d,
	0xb7, 0xae, 0x75, 0xf7, 0x65, 0x1e, 0xee, 0xdf, 0x64, 0xe2, 0x3e, 0xac, 0x96, 0x26, 0x79, 0x1e,
	0x85, 0xa3, 0x68, 0xdc, 0x59, 0x92, 0x70, 0x77, 0xb4, 0x63, 0x5f, 0xda, 0x87, 0x63, 0xe7, 0x47,
	0x03, 0xda, 0x9a, 0x66, 0x12, 0x73, 0x96, 0xd0, 0x8c, 0x67, 0x51, 0x2a, 0x4b, 0xd4, 0x3c, 0x0b,
	0xdb, 0x70, 0x8c, 0x07, 0x80, 0x73, 0x80, 0x6c, 0x4d, 0x7c, 0x96, 0x66, 0x81, 0xa6, 0x0c, 0xbc,
	0xab, 0x3d, 0xbe, 0x72, 0x0c, 0xc7, 0xf8, 0x05, 0x58, 0xa5, 0x29, 0x27, 0x1d, 0xa3, 0xdb, 0xe8,
	0x99, 0xdb, 0xbd, 0xfa, 0xc6, 0x24, 0xa7, 0x83, 0x2c, 0xc1, 0x37, 0x49, 0xf1, 0x3b, 0xa9, 0xee,
	0x6d, 0xb9, 0xb2, 0x37, 0xfc, 0x0a, 0x40, 0x01, 0x47, 0xec, 0x9c, 0x77, 0x9a, 0x72, 0x9e, 0x3b,
	0x73, 0xc0, 0xe6, 0xa3, 0x50, 0xaf, 0x21, 0x3b, 0xe7, 0x7e, 0x8b, 0xe4, 0x3f, 0xed, 0x0b, 0x68,
	0x15, 0x76, 0x7c, 0x0a, 0x6d, 0xc2, 0x59, 0x32, 0x9b, 0x52, 0xa1, 0x50, 0xd4, 0xd6, 0x9e, 0x2c,
	0x84, 0xa2, 0x0b, 0x48, 0x20, 0x8b, 0x94, 0x5e, 0xf6, 0x0e, 0x58, 0x65, 0x2f, 0x7e, 0x00, 0x2b,
	0xb1, 0xe0, 0x17, 0x94, 0xa4, 0x23, 0x36, 0x9b, 0x9e, 0x51, 0x21, 0xb7, 0xd3, 0xf0, 0xdb, 0xda,
	0x7a, 0x24, 0x8d, 0xce, 0x35, 0x82, 0xb6, 0x4f, 0x63, 0x2e, 0xd2, 0x05, 0xc4, 0x77, 0x08, 0x50,
	0xec, 0x38, 0x5f, 0xd2, 0xdc, 0xea, 0x2b, 0xa5, 0x56, 0xaf, 0xa8, 0x51, 0x2d, 0xbf, 0x6b, 0x03,
	0x56, 0x72, 0xa6, 0x5a, 0x7f, 0xa7, 0xd0, 0x16, 0xd2, 0x92, 0xeb, 0x05, 0x49, 0x2a, 0xff, 0x19,
	0xe9, 0xed, 0x22, 0xfa, 0xa9, 0xf4, 0x63, 0x89, 0x9b, 0xc7, 0x3f, 0xd8, 0x19, 0xd5, 0x02, 0xaa,
	0xd6, 0xf9, 0x52, 0xb5, 0xce, 0xed, 0x37, 0x60, 0x96, 0x60, 0xe7, 0xf9, 0x8e, 0xfa, 0xd0, 0x54,
	0x37, 0x43, 0xcb, 0x06, 0xe7, 0x3d, 0x8a, 0x98, 0xb8, 0x27, 0xd2, 0xe3, 0xeb, 0x88, 0xed, 0xef,
	0x06, 0xac, 0x9e, 0x14, 0xfc, 0xf4, 0x79, 0xc4, 0x9f, 0x11, 0x2c, 0x4b, 0x35, 0xe1, 0xfe, 0x5c,
	0x92, 0x93, 0x6a, 0xb0, 0x37, 0x17, 0x90, 0xa7, 0x33, 0xf8, 0xf4, 0xf3, 0xd7, 0x17, 0xe3, 0xa1,
	0xb3, 0x5e, 0xba, 0xd0, 0x89, 0xf7, 0xa1, 0x2c, 0xa7, 0x8f, 0xbb, 0xf2, 0xf3, 0xd8, 0x45, 0x7d,
	0x7c, 0x85, 0xa0, 0xa9, 0xa6, 0x80, 0x37, 0xe7, 0xdb, 0x98, 0xa2, 0x34, 0x58, 0x64, 0xbd, 0xce,
	0x23, 0xc9, 0x69, 0xc3, 0x71, 0xea, 0x38, 0xa9, 0xb5, 0xef, 0xa2, 0xfe, 0xde, 0x15, 0x82, 0x2e,
	0xe1, 0xd3, 0x5a, 0x88, 0xbd, 0x7b, 0x7f, 0x4d, 0xf7, 0x38, 0x3b, 0xe4, 0xc7, 0xe8, 0xf5, 0x73,
	0x9d, 0x17, 0xf2, 0x49, 0xc0, 0x42, 0x97, 0x8b, 0xd0, 0x0b, 0x29, 0x93, 0x67, 0xde, 0x53, 0xae,
	0x20, 0x8e, 0x92, 0xea, 0x3f, 0x8c, 0xa7, 0xb7, 0x2d, 0xbf, 0x11, 0xfa, 0x6a, 0x2c, 0x1d, 0x3e,
	0x3b, 0xd9, 0x3f, 0x6b, 0xca, 0x02, 0x8f, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x2b, 0x33, 0x19,
	0x2a, 0x13, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ServiceControllerClient is the client API for ServiceController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceControllerClient interface {
	// Checks an operation with Google Service Control to decide whether
	// the given operation should proceed. It should be called before the
	// operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// 60 seconds. In case of server errors, the client can rely on the cached
	// results for longer time.
	//
	// NOTE: the [CheckRequest][google.api.servicecontrol.v1.CheckRequest] has the
	// size limit of 64KB.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Reports operation results to Google Service Control, such as logs and
	// metrics. It should be called after an operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5
	// seconds to reduce API traffic. Limiting aggregation to 5 seconds is to
	// reduce data loss during client crashes. Clients should carefully choose
	// the aggregation time window to avoid data loss risk more than 0.01%
	// for business and compliance reasons.
	//
	// NOTE: the [ReportRequest][google.api.servicecontrol.v1.ReportRequest] has
	// the size limit of 1MB.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error)
}

type serviceControllerClient struct {
	cc *grpc.ClientConn
}

func NewServiceControllerClient(cc *grpc.ClientConn) ServiceControllerClient {
	return &serviceControllerClient{cc}
}

func (c *serviceControllerClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Check", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceControllerClient) Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error) {
	out := new(ReportResponse)
	err := c.cc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Report", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceControllerServer is the server API for ServiceController service.
type ServiceControllerServer interface {
	// Checks an operation with Google Service Control to decide whether
	// the given operation should proceed. It should be called before the
	// operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// 60 seconds. In case of server errors, the client can rely on the cached
	// results for longer time.
	//
	// NOTE: the [CheckRequest][google.api.servicecontrol.v1.CheckRequest] has the
	// size limit of 64KB.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Reports operation results to Google Service Control, such as logs and
	// metrics. It should be called after an operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5
	// seconds to reduce API traffic. Limiting aggregation to 5 seconds is to
	// reduce data loss during client crashes. Clients should carefully choose
	// the aggregation time window to avoid data loss risk more than 0.01%
	// for business and compliance reasons.
	//
	// NOTE: the [ReportRequest][google.api.servicecontrol.v1.ReportRequest] has
	// the size limit of 1MB.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(context.Context, *ReportRequest) (*ReportResponse, error)
}

// UnimplementedServiceControllerServer can be embedded to have forward compatible implementations.
type UnimplementedServiceControllerServer struct {
}

func (*UnimplementedServiceControllerServer) Check(ctx context.Context, req *CheckRequest) (*CheckResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Check not implemented")
}
func (*UnimplementedServiceControllerServer) Report(ctx context.Context, req *ReportRequest) (*ReportResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Report not implemented")
}

func RegisterServiceControllerServer(s *grpc.Server, srv ServiceControllerServer) {
	s.RegisterService(&_ServiceController_serviceDesc, srv)
}

func _ServiceController_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceController_Report_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Report(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Report",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Report(ctx, req.(*ReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicecontrol.v1.ServiceController",
	HandlerType: (*ServiceControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Check",
			Handler:    _ServiceController_Check_Handler,
		},
		{
			MethodName: "Report",
			Handler:    _ServiceController_Report_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/servicecontrol/v1/service_controller.proto",
}
