/*
	file automatically generated by make_test_files.pl
	Tue Apr 19 14:01:03 2011
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for STRINGPARSER
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_stringparser_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */
int unur_ssr_set_pedantic( struct unur_par *par, int pedantic );

#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */




/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
UNUR_GEN   *gen = NULL;
   distr = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,46,(gen = unur_str2gen( NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,46,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,49,(distr = unur_str2distr( NULL )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,49,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,52,(gen = unur_makegen_ssu(NULL,NULL,NULL)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,52,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid distribution block */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,59,(gen = unur_str2gen( "xxxx" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,59,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,63,(gen = unur_str2gen( "method = xxxx" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,63,UNUR_ERR_STR_SYNTAX)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,67,(gen = unur_str2gen( "normal; xxxx=1" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,67,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,71,(gen = unur_str2gen( "normal; pv=(1,2,3)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,71,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,75,(gen = unur_str2gen( "normal,(1,2)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,75,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,79,(gen = unur_str2gen( "beta" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,79,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,83,(gen = unur_str2gen( "beta()" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,83,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,87,(gen = unur_str2gen( "beta(1)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,87,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
gen = unur_str2gen( "beta(1,2,3)" );
n_tests_failed += (check_errorcode(TESTLOG,91,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
gen = unur_str2gen( "beta(1,2,3,4,5)" );
n_tests_failed += (check_errorcode(TESTLOG,95,UNUR_ERR_DISTR_NPARAMS)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,99,(gen = unur_str2gen( "gamma(-0.5)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,99,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,103,(gen = unur_str2gen( "normal(); domain" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,103,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid other block */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,110,(gen = unur_str2gen( "normal() & xxxx = arou" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,110,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,114,(gen = unur_str2gen( "normal() & distr=gamma(2)" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,114,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid method block */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
gen = unur_str2gen( "normal() & method = arou; c = 0" );
n_tests_failed += (check_errorcode(TESTLOG,121,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
n_tests_failed += (check_expected_NULL(TESTLOG,125,(gen = unur_str2gen( "normal() & method = xxx" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,125,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid urng block */
UNUR_GEN   *gen = NULL;
    gen = NULL; 


unur_reset_errno();
gen = unur_str2gen( "normal & urng = xxx" );
n_tests_failed += (check_errorcode(TESTLOG,132,UNUR_ERR_STR)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
#ifdef UNURAN_SUPPORTS_PRNG
gen = unur_str2gen( "normal & urng = mt19937(123); xxx = 1" );
n_tests_failed += (check_errorcode(TESTLOG,137,UNUR_ERR_STR_UNKNOWN)==UNUR_SUCCESS)?0:1;
#endif
unur_free(gen);
}

{ /* invalid data */
UNUR_GEN   *gen = NULL;
   gen = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,146,(gen = unur_str2gen( "gamma(0.5) & method = tdr" )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,146,UNUR_ERR_GEN_DATA)==UNUR_SUCCESS)?0:1;
unur_free(gen);
}

{ /* invalid data */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   struct unur_slist *mlist = NULL;
   distr = NULL;
   par = NULL;
   gen = NULL; 

distr = unur_str2distr("normal()");
par = _unur_str2par(distr, "tdr", &mlist);
gen = unur_init(par); 
_unur_slist_free(mlist);
unur_distr_free(distr);
unur_free(gen);
}

{ /* invalid distribution block */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,169,(distr = unur_str2distr("cont; pdf='exp'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,169,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,174,(distr = unur_str2distr("cont; pdf='abc(x)'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,174,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,179,(distr = unur_str2distr("cont; pdf='exp(x*y)'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,179,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,183,(distr = unur_str2distr("cont; pdf='exp(x'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,183,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,186,(distr = unur_str2distr("cont; pdf='exp((x)'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,186,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,189,(distr = unur_str2distr("cont; pdf='exp(x))'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,189,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,193,(distr = unur_str2distr("cont; pdf='x^'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,193,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,197,(distr = unur_str2distr("cont; pdf='exp(x)x'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,197,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,200,(distr = unur_str2distr("cont; pdf='2x'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,200,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,203,(distr = unur_str2distr("cont; pdf='x***2'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,203,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,206,(distr = unur_str2distr("cont; pdf='x*exp(x^(x*y))'")))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,206,UNUR_ERR_STR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare function parser - cont */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpm[10];
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_normal(NULL,0); 
par = unur_srou_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,232,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; pdf = \"(1/sqrt(2*pi)*exp(-x^2/2))\"; mode = 0; pdfarea = 1 & \
	             method = srou" );
n_tests_failed += (compare_sequence_gen(TESTLOG,238,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1 & \
	             method = srou" );
n_tests_failed += (compare_sequence_gen(TESTLOG,244,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1", \
	             "method = srou", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,250,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1", \
	             "srou", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,256,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_str2distr("cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1");
gen = unur_makegen_dsu( distr, "srou", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,263,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_normal(NULL,0); 
par = unur_ssr_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,272,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; pdf = \"(1/sqrt(2*pi)*exp(-x^2/2))\"; mode = 0; pdfarea = 1 & \
	             method = ssr" );
n_tests_failed += (compare_sequence_gen(TESTLOG,279,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_normal(NULL,0); 
par = unur_utdr_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,288,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; pdf = \"(1/sqrt(2*pi)*exp(-x^2/2))\"; mode = 0; pdfarea = 1 & \
	             method = utdr" );
n_tests_failed += (compare_sequence_gen(TESTLOG,294,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1 & \
	             method = utdr" );
n_tests_failed += (compare_sequence_gen(TESTLOG,300,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_normal(NULL,0); 
par = unur_tdr_new(distr);
unur_tdr_set_cpoints(par,8,NULL);
unur_tdr_set_max_sqhratio(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,311,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; pdf = \"(1/sqrt(2*pi)*exp(-x^2/2))\"; mode = 0; pdfarea = 1 & \
	             method = tdr; cpoints = 8; max_sqhratio = 0." );
n_tests_failed += (compare_sequence_gen(TESTLOG,317,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1 & \
	             method = tdr; cpoints = 8; max_sqhratio = 0." );
n_tests_failed += (compare_sequence_gen(TESTLOG,323,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1", \
	             "method = tdr; cpoints = 8; max_sqhratio = 0.", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,329,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "cont; logpdf = \"-x^2/2-0.5*log(2*pi)\"; mode = 0; pdfarea = 1", \
	             "tdr; cpoints = 8; max_sqhratio = 0.", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,335,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_normal(NULL,0); 
par = unur_arou_new(distr);
unur_arou_set_cpoints(par,8,NULL);
unur_arou_set_max_sqhratio(par,0.);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,346,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; pdf = \"(1/sqrt(2*pi)*exp(-x^2/2))\"; mode = 0; pdfarea = 1 & \
	             method = arou; cpoints = 8; max_sqhratio = 0." );
n_tests_failed += (compare_sequence_gen(TESTLOG,352,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_cont_new();
unur_distr_cont_set_cdfstr(distr,"1-exp(-x)");
par = unur_ninv_new(distr);
unur_ninv_set_usenewton(par);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,363,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; cdf = \"1-exp(-x)\"; domain = (0,inf)& \
	             method = ninv; usenewton" );
n_tests_failed += (compare_sequence_gen(TESTLOG,369,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_cont_new();
unur_distr_cont_set_hrstr(distr,"1/(1+x)");
par = unur_hrb_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,379,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "cont; hr = \"1/(1+x)\"; domain = (0,inf)& \
	             method = hrb" );
n_tests_failed += (compare_sequence_gen(TESTLOG,385,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_normal(NULL,0);
par = unur_auto_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,394,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "normal() & method=auto" );
n_tests_failed += (compare_sequence_gen(TESTLOG,399,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal()", "method=auto", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,404,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal()", "auto", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,409,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal()", "", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,414,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal()", NULL, NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,419,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal", NULL, NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,424,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
fpm[0] = 1.;
fpm[1] = 2.;
distr = unur_distr_normal(fpm,2);
par = unur_auto_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,435,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "normal(1.,2.) & method=auto" );
n_tests_failed += (compare_sequence_gen(TESTLOG,440,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal(1,2)", "method=auto", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,445,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal(1,2.)", "auto", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,450,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal(1.,2)", "", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,455,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_makegen_ssu( "normal(1,2)", NULL, NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,460,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
fpm[0] = 1.;
fpm[1] = 2.;
distr = unur_distr_normal(fpm,2);
gen = unur_makegen_dsu( distr, "method=auto", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,468,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
fpm[0] = 1.;
fpm[1] = 2.;
distr = unur_distr_normal(fpm,2);
gen = unur_makegen_dsu( distr, "auto", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,476,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
fpm[0] = 1.;
fpm[1] = 2.;
distr = unur_distr_normal(fpm,2);
gen = unur_makegen_dsu( distr, "", NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,484,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
fpm[0] = 1.;
fpm[1] = 2.;
distr = unur_distr_normal(fpm,2);
gen = unur_makegen_dsu( distr, NULL, NULL );
n_tests_failed += (compare_sequence_gen(TESTLOG,492,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare function parser - discr */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {0.4};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_geometric(fpar,1); 
par = unur_dsrou_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,511,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "discr; pmf = \"0.4 * (1-0.4)^k\"; domain = (0,inf); mode = 0; pmfsum = 1 & \
	             method = dsrou" );
n_tests_failed += (compare_sequence_gen(TESTLOG,517,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_geometric(fpar,1); 
par = unur_dau_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,525,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "discr; pmf = \"0.4 * (1-0.4)^k\"; domain = (0,inf); mode = 0; pmfsum = 1 & \
	             method = dau" );
n_tests_failed += (compare_sequence_gen(TESTLOG,531,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_geometric(fpar,1); 
par = unur_dgt_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,539,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "discr; pmf = \"0.4 * (1-0.4)^k\"; domain = (0,inf); mode = 0; pmfsum = 1 & \
	             method = dgt" );
n_tests_failed += (compare_sequence_gen(TESTLOG,545,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
distr = unur_distr_geometric(fpar,1); 
par = unur_dari_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,553,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "discr; pmf = \"0.4 * (1-0.4)^k\"; domain = (0,inf); mode = 0; pmfsum = 1 & \
	             method = dari" );
n_tests_failed += (compare_sequence_gen(TESTLOG,560,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_stringparser_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_stringparser_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_stringparser_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_stringparser_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 259225;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 259225;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("stringparser: ");

	/* run tests */
test_new();
test_init();
test_sample();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

