/*
	file automatically generated by make_test_files.pl
	Tue Apr 19 14:01:03 2011
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for TEST
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_test_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */
double HR_increasing_gm31(double x, const UNUR_DISTR *distr);

#define COMPARE_SAMPLE_SIZE  (500)
#define VIOLATE_SAMPLE_SIZE   (20)

/* we need marginal distributions for the chi2 tests */
#define unur_distr_multinormal  unur_distr_multinormal_w_marginals




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */



double HR_increasing_gm31(double x, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
     /* example with increasing hazard rate: gamma (alpha=3,beta=1) */
{ return (x*x)/(x*x+2.*x+2.); }

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* run_tests for AUTO */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   distr = unur_distr_normal(NULL,0); 
   par = NULL; 


unur_reset_errno();
par = unur_auto_new(distr);
unur_run_tests(par,~0u,TESTLOG);
n_tests_failed += (check_errorcode(TESTLOG,56,UNUR_SUCCESS)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* run_tests for AUTO */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpm[1] = {0.5};
   distr = unur_distr_geometric(fpm,1); 
   par = NULL; 


unur_reset_errno();
par = unur_auto_new(distr);
unur_run_tests(par,~0u,TESTLOG);
n_tests_failed += (check_errorcode(TESTLOG,66,UNUR_SUCCESS)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* run_tests for AUTO */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double data[] = {1.,2.,3.,4.,5.,6.,7.,8.,9.};
   distr = unur_distr_cemp_new();
   unur_distr_cemp_set_data(distr,data,9);
   par = NULL; 


unur_reset_errno();
par = unur_auto_new(distr);
unur_run_tests(par,~0u,TESTLOG);
n_tests_failed += (check_errorcode(TESTLOG,77,UNUR_SUCCESS)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* run_tests for AUTO */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   distr = unur_distr_multinormal( dim, mean, covar );
   par = NULL; 


unur_reset_errno();
par = unur_auto_new(distr);
unur_run_tests(par,~0u,TESTLOG);
n_tests_failed += (check_errorcode(TESTLOG,89,UNUR_SUCCESS)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [special] */

void test_special (void)
{
	/* set boolean to FALSE */
	int FAILED = 0;





  int samplesize = 10000;
  double fpm[10];
  double Rsq, time_setup, time_marginal;

  UNUR_DISTR *distr;
  UNUR_PAR   *par;
  UNUR_GEN   *gen;

/* start test */
printf("[special "); fflush(stdout);
fprintf(TESTLOG,"\n[special]\n");

/* set stop watch */
stopwatch_lap(&watch);



  /* unur_test_par_count_pdf() */

  distr = unur_distr_normal(NULL,0);
  par = unur_tdr_new(distr);
  unur_tdr_set_usedars(par,0);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  distr = unur_distr_normal_wo_logpdf(NULL,0);
  par = unur_tdr_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  distr = unur_distr_normal(NULL,0);
  par = unur_ninv_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  distr = unur_distr_normal(NULL,0);
  par = unur_hinv_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  distr = unur_distr_cont_new();
  unur_distr_set_name(distr,"HR");
  unur_distr_cont_set_hr(distr,HR_increasing_gm31);
  par = unur_hri_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  fpm[0] = 0.5;
  distr = unur_distr_geometric(fpm,1);
  par = unur_dgt_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  fpm[0] = 0.5;
  distr = unur_distr_geometric(fpm,1);
  par = unur_dari_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  distr = unur_distr_multinormal(3,NULL,NULL);
  par = unur_vnrou_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  distr = unur_distr_multinormal_wo_logpdf(3,NULL,NULL);
  par = unur_vnrou_new(distr);
  unur_test_par_count_pdf(par,samplesize,1,TESTLOG);
  gen = unur_init(par);
  unur_test_count_pdf(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);

  /* unur_test_count_urng() */

  distr = unur_distr_normal(NULL,0);
  par = unur_tdr_new(distr);
  unur_tdr_set_usedars(par,0);
  gen = unur_init(par);
  unur_test_count_urn(gen,samplesize,1,TESTLOG);
  unur_free(gen);
  unur_distr_free(distr);


  /* test timing routines */

  Rsq = unur_test_timing_R(NULL,NULL,NULL,5,&time_setup,&time_marginal);
  fprintf(TESTLOG,"\nR^2 = %g, setup time = %g, marginal generation time = %g\n",
	  Rsq, time_setup, time_marginal);

  Rsq = unur_test_timing_R(NULL,"cont","pinv",5,&time_setup,&time_marginal);
  fprintf(TESTLOG,"\nR^2 = %g, setup time = %g, marginal generation time = %g\n",
	  Rsq, time_setup, time_marginal);

  distr = unur_distr_normal(NULL,0);
  par = unur_tdr_new(distr);
  Rsq = unur_test_timing_R(par,NULL,NULL,5,&time_setup,&time_marginal);
  unur_distr_free(distr);
  fprintf(TESTLOG,"\nR^2 = %g, setup time = %g, marginal generation time = %g\n",
	  Rsq, time_setup, time_marginal);

  Rsq = unur_test_timing_R(NULL,"normal","pinv",5,&time_setup,&time_marginal);
  fprintf(TESTLOG,"\nR^2 = %g, setup time = %g, marginal generation time = %g\n",
	  Rsq, time_setup, time_marginal);


  /* test finished */
  FAILED = 0;



	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (FAILED) ? 0 : 1;
	(FAILED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_special() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_test_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_test_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_unur_tests_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_unur_tests_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 160867;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 160867;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("test: ");

	/* run tests */
test_new();
test_sample();
test_special();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

