/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

public class StringPrivateKeySupplier
implements Supplier<InputStream> {
    private final String privateKey;

    @ConstructorProperties(value={"privateKey"})
    public StringPrivateKeySupplier(String privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public InputStream get() {
        return new ByteArrayInputStream(this.privateKey.getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return "StringPrivateKeySupplier(privateKey=<redacted>)";
    }
}

