# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.14.0

EAPI=8

RUST_MIN_VER="1.84.0"

inherit cargo desktop shell-completion xdg

DESCRIPTION="A terminal workspace with batteries included"
HOMEPAGE="
	https://zellij.dev/
	https://github.com/zellij-org/zellij
"
SRC_URI="https://github.com/zellij-org/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz"
SRC_URI+=" https://github.com/gentoo-crate-dist/zellij/releases/download/v${PV}/${P}-crates.tar.xz"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD CC0-1.0 ISC MIT
	MPL-2.0 Unicode-DFS-2016 WTFPL-2 ZLIB
"
SLOT="0"
KEYWORDS="~amd64 ~riscv"
IUSE="man system-sqlite"

# libnghttp2 still bundled
# https://github.com/alexcrichton/nghttp2-rs/pull/5
RDEPEND="
	system-sqlite? ( >=dev-db/sqlite-3.45.3:3 )
	net-misc/curl
"
DEPEND="${RDEPEND}"
BDEPEND="
	man? ( dev-go/go-md2man )
	virtual/pkgconfig
"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/${PN}"
QA_PRESTRIPPED="usr/bin/${PN}"

DOCS=(
	CHANGELOG.md
	CODE_OF_CONDUCT.md
	CONTRIBUTING.md
	GOVERNANCE.md
	README.md
	docs/
)

pkg_setup() {
	# libsqlite3-sys https://wiki.gentoo.org/wiki/Project:Rust/sys_crates
	use system-sqlite && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1
	rust_pkg_setup
}

src_configure() {
	local myfeatures=(
		plugins_from_target
		web_server_capability
	)
	# disable vendored_curl
	cargo_src_configure --no-default-features
}

src_compile() {
	cargo_src_compile
	pushd ${PN}-utils 2>/dev/null || die
	cargo_src_compile
	popd 2>/dev/null || die

	if use man; then
		go-md2man -in docs/MANPAGE.md -out ${PN}.1 || die
	fi

	"$(cargo_target_dir)"/zellij setup --generate-completion bash > zellij.bash || die
	"$(cargo_target_dir)"/zellij setup --generate-completion fish > zellij.fish || die
	"$(cargo_target_dir)"/zellij setup --generate-completion zsh > zellij.zsh || die
}

src_install() {
	cargo_src_install

	dodoc example/*.*

	insinto /usr/share/zellij
	doins -r example/{themes,layouts}
	doins -r ${PN}-utils/assets/{layouts,plugins,config,shell} \
		${PN}-utils/assets/*.wasm ${PN}-utils/assets/README.md

	use man && doman ${PN}.1

	domenu assets/zellij.desktop
	newicon assets/logo.png zellij.png

	newbashcomp zellij.bash zellij
	newfishcomp zellij.fish zellij.fish
	newzshcomp zellij.zsh _zellij
}
