searchData={"items":[{"type":"module","title":"edoc","doc":"EDoc - the Erlang program documentation generator. This module provides the main user interface to EDoc. EDoc User Manual Running EDoc","ref":"edoc.html"},{"type":"function","title":"edoc.application/1","doc":"Equivalent to  application(Application, []) .","ref":"edoc.html#application/1"},{"type":"function","title":"edoc.application/2","doc":"Run EDoc on an application in its default app-directory. See  application/3  for details. See also:  application/1 .","ref":"edoc.html#application/2"},{"type":"function","title":"edoc.application/3","doc":"Run EDoc on an application located in the specified directory. Tries to automatically set up good defaults. Unless the user specifies otherwise: The  doc  subdirectory will be used as the target directory, if it exists; otherwise the application directory is used. The source code is assumed to be located in the  src  subdirectory, if it exists, or otherwise in the application directory itself. The  subpackages  option is turned on. All found source files will be processed. The  include  subdirectory is automatically added to the include path. (Only important if  preprocessing  is turned on.) See  run/2  for details, including options. See also:  application/2 .","ref":"edoc.html#application/3"},{"type":"type","title":"edoc.comment/0","doc":"","ref":"edoc.html#t:comment/0"},{"type":"type","title":"edoc.edoc_module/0","doc":"The EDoc documentation data for a module, expressed as an XML document in  XMerL  format. See the file  edoc.dtd  for details.","ref":"edoc.html#t:edoc_module/0"},{"type":"type","title":"edoc.entry/0","doc":"Module Entries (one per function, plus module header and footer).","ref":"edoc.html#t:entry/0"},{"type":"type","title":"edoc.entry_data/0","doc":"","ref":"edoc.html#t:entry_data/0"},{"type":"type","title":"edoc.env/0","doc":"Environment information needed by EDoc for generating references.","ref":"edoc.html#t:env/0"},{"type":"function","title":"edoc.file/1","doc":"Equivalent to  file(Name, []) .","ref":"edoc.html#file/1"},{"type":"function","title":"edoc.file/2","doc":"Reads a source code file and outputs formatted documentation to a corresponding file. Options: {dir,  filename() } Specifies the output directory for the created file. (By default, the output is written to the directory of the source file.) {source_suffix, string()} Specifies the expected suffix of the input file. The default value is  \".erl\" . {file_suffix, string()} Specifies the suffix for the created file. The default value is  \".html\" . See  get_doc/2  and  layout/2  for further options. For running EDoc from a Makefile or similar, see  edoc_run:file/1 . See also:  read/2 .","ref":"edoc.html#file/2"},{"type":"type","title":"edoc.filename/0","doc":"","ref":"edoc.html#t:filename/0"},{"type":"function","title":"edoc.files/1","doc":"","ref":"edoc.html#files/1"},{"type":"function","title":"edoc.files/2","doc":"Equivalent to  run(Files, Options) . Runs EDoc on a given set of source files. See  run/2  for details, including options.","ref":"edoc.html#files/2"},{"type":"type","title":"edoc.function_name/0","doc":"","ref":"edoc.html#t:function_name/0"},{"type":"function","title":"edoc.get_doc/1","doc":"Equivalent to  get_doc(File, []) .","ref":"edoc.html#get_doc/1"},{"type":"function","title":"edoc.get_doc/2","doc":"Reads a source code file and extracts EDoc documentation data. Note that without an environment parameter (see  get_doc/3 ), hypertext links may not be correct. Options: {def, Macros} Macros  =  Macro | [Macro] Macro  =  {Name::atom(), Text::string() | MacroFun} MacroFun  =  fun((MacroArgument::string(), Line :: integer(), edoc_lib:edoc_env()) -> (Text::string())) Specifies a set of user-defined EDoc macros. The text substituted for macro calls is specified as either a  string()  or a  function() . The function is called with the macro argument text, the current line number, and the current environment. The fun is to return a  string() . See  Macro expansion  for details. {hidden, boolean()} If the value is  true , documentation of hidden functions will also be included. The default value is  false . {private, boolean()} If the value is  true , documentation of private functions will also be included. The default value is  false . {todo, boolean()} If the value is  true , To-Do notes written using  @todo  or  @TODO  tags will be included in the documentation. The default value is  false . See  read_source/2 ,  read_comments/2  and  edoc_lib:get_doc_env/3  for further options. See also:  get_doc/3 ,  layout/2 ,  read/2 ,  run/2 ,  edoc_extract:source/5 .","ref":"edoc.html#get_doc/2"},{"type":"function","title":"edoc.get_doc/3","doc":"Like  get_doc/2 , but for a given environment parameter.  Env  is an environment created by  edoc_lib:get_doc_env/3 .","ref":"edoc.html#get_doc/3"},{"type":"function","title":"edoc.layout/1","doc":"Equivalent to  layout(Doc, []) .","ref":"edoc.html#layout/1"},{"type":"function","title":"edoc.layout/2","doc":"Transforms EDoc module documentation data to text. The default layout creates an HTML document. Options: {layout, Module::atom()} Specifies a callback module to be used for formatting. The module must export a function  module(Doc, Options) . The default callback module is  edoc_layout ; see  edoc_layout:module/2  for layout-specific options. See also:  file/2 ,  layout/1 ,  read/2 ,  run/2 .","ref":"edoc.html#layout/2"},{"type":"type","title":"edoc.module_meta/0","doc":"Module information.","ref":"edoc.html#t:module_meta/0"},{"type":"type","title":"edoc.ordset/1","doc":"","ref":"edoc.html#t:ordset/1"},{"type":"type","title":"edoc.proplist/0","doc":"","ref":"edoc.html#t:proplist/0"},{"type":"function","title":"edoc.read/1","doc":"Equivalent to  read(File, []) .","ref":"edoc.html#read/1"},{"type":"function","title":"edoc.read/2","doc":"Reads and processes a source file and returns the resulting EDoc-text as a string. See  get_doc/2  and  layout/2  for options. See also:  file/2 .","ref":"edoc.html#read/2"},{"type":"function","title":"edoc.read_comments/1","doc":"Equivalent to  read_comments(File, []) .","ref":"edoc.html#read_comments/1"},{"type":"function","title":"edoc.read_comments/2","doc":"Extracts comments from an Erlang source code file. See the module  erl_comment_scan  for details on the representation of comments. Currently, no options are available.","ref":"edoc.html#read_comments/2"},{"type":"function","title":"edoc.read_source/1","doc":"Equivalent to  read_source(File, []) .","ref":"edoc.html#read_source/1"},{"type":"function","title":"edoc.read_source/2","doc":"Reads an Erlang source file and returns the list of \"source code form\" syntax trees. Options: {preprocess, boolean()} If the value is  true , the source file will be read via the Erlang preprocessor ( epp ). The default value is  false .  no_preprocess  is an alias for  {preprocess, false} . Normally, preprocessing is not necessary for EDoc to work, but if a file contains too exotic definitions or uses of macros, it will not be possible to read it without preprocessing.  Note: comments in included files will not be available to EDoc, even with this option enabled. {includes, Path::[string()]} Specifies a list of directory names to be searched for include files, if the  preprocess  option is turned on. Also used with the  @headerfile  tag. The default value is the empty list. The directory of the source file is always automatically appended to the search path. {macros, [{atom(), term()}]} Specifies a list of pre-defined Erlang preprocessor ( epp ) macro definitions, used if the  preprocess  option is turned on. The default value is the empty list. {report_missing_types, boolean()} If the value is  true , warnings are issued for missing types. The default value is  false .  no_report_missing_types  is an alias for  {report_missing_types, false} . {link_predefined_types, boolean()} If the value is  true , all predefined data types will have a link to the erlang module. This option is to be used when generating documentation for the Erlang/OTP docs. The default value is  false .  no_link_predefined_types  is an alias for  {link_predefined_types, false} . See also:  //syntax_tools/erl_syntax ,  get_doc/2 .","ref":"edoc.html#read_source/2"},{"type":"function","title":"edoc.run/2","doc":"Runs EDoc on a given set of source files. Note that the doclet plugin module has its own particular options; see the  doclet  option below. Also see  layout/2  for layout-related options, and  get_doc/2  for options related to reading source files. Options: {app_default, string()} Specifies the default base URI for unknown applications. {application, App::atom()} Specifies that the generated documentation describes the application  App . This mainly affects generated references. {dir,  filename() } Specifies the target directory for the generated documentation. {doc_path, [string()]} Specifies a list of file system paths pointing to directories that contain EDoc-generated documentation. All paths for applications in the code path are automatically added. {doclet, Module::atom()} Specifies a callback module to be used for creating the documentation. The module must export a function  run(Cmd, Ctxt) . The default doclet module is  edoc_doclet ; see  edoc_doclet:run/2  for doclet-specific options. {file_suffix, string()} Specifies the suffix used for output files. The default value is  \".html\" . Note that this also affects generated references. {new, boolean()} If the value is  true , any existing  edoc-info  file in the target directory will be ignored and overwritten. The default value is  false . {source_path, [ filename() ]} Specifies a list of file system paths used to locate the source code for packages. {source_suffix, string()} Specifies the expected suffix of input files. The default value is  \".erl\" . {subpackages, boolean()} If the value is  true , all subpackages of specified packages will also be included in the documentation. The default value is  false .  no_subpackages  is an alias for  {subpackages, false} . Subpackage source files are found by recursively searching for source code files in subdirectories of the known source code root directories. (Also see the  source_path  option.) Directory names must begin with a lowercase letter and contain only alphanumeric characters and underscore, or they will be ignored. (For example, a subdirectory named  test-files  will not be searched.) See also:  application/2 ,  files/2 .","ref":"edoc.html#run/2"},{"type":"type","title":"edoc.syntaxTree/0","doc":"","ref":"edoc.html#t:syntaxTree/0"},{"type":"type","title":"edoc.tag/0","doc":"Generic tag information.  #tag.form  is only defined if  #tag.origin  is  code , that is the  #tag{}  represents a code fragment, not a doc comment tag.","ref":"edoc.html#t:tag/0"},{"type":"behaviour","title":"edoc_doclet","doc":"Standard doclet module for EDoc. See also:  edoc .","ref":"edoc_doclet.html"},{"type":"type","title":"edoc_doclet.command/0","doc":"Doclet commands.","ref":"edoc_doclet.html#t:command/0"},{"type":"type","title":"edoc_doclet.context/0","doc":"Context for doclets.","ref":"edoc_doclet.html#t:context/0"},{"type":"type","title":"edoc_doclet.doclet_gen/0","doc":"Doclet command.","ref":"edoc_doclet.html#t:doclet_gen/0"},{"type":"type","title":"edoc_doclet.doclet_toc/0","doc":"Doclet command.","ref":"edoc_doclet.html#t:doclet_toc/0"},{"type":"callback","title":"edoc_doclet.run/2","doc":"Doclet entrypoint.","ref":"edoc_doclet.html#c:run/2"},{"type":"function","title":"edoc_doclet.run/2","doc":"Main doclet entry point. See the file  edoc_doclet.hrl  for the data structures used for passing parameters. Also see  edoc:layout/2  for layout-related options, and  edoc:get_doc/2  for options related to reading source files. Options: {file_suffix, string()} Specifies the suffix used for output files. The default value is  \".html\" . {hidden, boolean()} If the value is  true , documentation of hidden modules and functions will also be included. The default value is  false . {overview,  edoc:filename() } Specifies the name of the overview-file. By default, this doclet looks for a file  \"overview.edoc\"  in the target directory. {private, boolean()} If the value is  true , documentation of private modules and functions will also be included. The default value is  false . {stylesheet, string()} Specifies the URI used for referencing the stylesheet. The default value is  \"stylesheet.css\" . If an empty string is specified, no stylesheet reference will be generated. {stylesheet_file,  edoc:filename() } Specifies the name of the stylesheet file. By default, this doclet uses the file  \"stylesheet.css\"  in the  priv  subdirectory of the EDoc installation directory. The named file will be copied to the target directory. {title, string()} Specifies the title of the overview-page.","ref":"edoc_doclet.html#run/2"},{"type":"module","title":"edoc_doclet_chunks","doc":"Doclet generating standalone  EEP-48  doc chunk files. Section  Using the EDoc API  in the EDoc User's Guide shows an example of using this module. See also:  edoc_layout_chunks ,  //stdlib/shell_docs .","ref":"edoc_doclet_chunks.html"},{"type":"function","title":"edoc_doclet_chunks.run/2","doc":"Main doclet entry point. This doclet is tightly coupled with  edoc_layout_chunks  and should be used together with it. The only option this doclet accepts is  dir , which controls where the  chunks  subdirectory and the EEP-48 chunk files will be placed.","ref":"edoc_doclet_chunks.html#run/2"},{"type":"module","title":"edoc_doclet_markdown","doc":"Doclet converting an edoc application to use  EEP-59  and Markdown. This doclet has to be used together with  edoc_layout_chunks . Example: <span class=\"w\"> </span><span class=\"mi\">1</span><span class=\"o\">&gt;</span><span class=\"w\"> </span><span class=\"nc\">edoc</span><span class=\"p\">:</span><span class=\"nf\">application</span><span class=\"p\" data-group-id=\"0413032977-1\">(</span><span class=\"ss\">example</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"p\" data-group-id=\"0413032977-2\">[</span><span class=\"p\" data-group-id=\"0413032977-3\">{</span><span class=\"ss\">preprocess</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"ss\">true</span><span class=\"p\" data-group-id=\"0413032977-3\">}</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"p\" data-group-id=\"0413032977-4\">{</span><span class=\"ss\">doclet</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"ss\">edoc_doclet_markdown</span><span class=\"p\" data-group-id=\"0413032977-4\">}</span><span class=\"p\">,</span><span class=\"w\">\n       </span><span class=\"p\" data-group-id=\"0413032977-5\">{</span><span class=\"ss\">layout</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"ss\">edoc_layout_chunks</span><span class=\"p\" data-group-id=\"0413032977-5\">}</span><span class=\"p\" data-group-id=\"0413032977-2\">]</span><span class=\"p\" data-group-id=\"0413032977-1\">)</span><span class=\"p\">.</span> It will convert the overview to Markdown and any module documentation to use  -doc  attributes and Markdown. Any XHTML tags in the edoc documentation that are not part of the tags supported by  Erlang Documentation Format  will be added as HTML tags in the Markdown. It does not delete the old edoc documentation. See also:  edoc_layout_chunks .","ref":"edoc_doclet_markdown.html"},{"type":"function","title":"edoc_doclet_markdown.run/2","doc":"Main doclet entry point. This doclet is tightly coupled with  edoc_layout_chunks  and should be used together with it.","ref":"edoc_doclet_markdown.html#run/2"},{"type":"module","title":"edoc_extract","doc":"EDoc documentation extraction. See also:  edoc .","ref":"edoc_extract.html"},{"type":"type","title":"edoc_extract.context/0","doc":"","ref":"edoc_extract.html#t:context/0"},{"type":"function","title":"edoc_extract.file/4","doc":"Reads a text file and returns the list of tags in the file. Any lines of text before the first tag are ignored.  Env  is an environment created by  edoc_lib:get_doc_env/3 . Upon error,  Reason  is an atom returned from the call to  file:read_file/1  or the atom 'invalid_unicode'. See  text/4  for options.","ref":"edoc_extract.html#file/4"},{"type":"type","title":"edoc_extract.filename/0","doc":"","ref":"edoc_extract.html#t:filename/0"},{"type":"function","title":"edoc_extract.header/3","doc":"Similar to  header/5 , but reads the syntax tree and the comments from the specified file. See also:  header/4 ,  edoc:read_comments/2 ,  edoc:read_source/2 .","ref":"edoc_extract.html#header/3"},{"type":"function","title":"edoc_extract.header/4","doc":"Extracts EDoc documentation from commented header file syntax trees. Similar to  source/5 , but ignores any documentation that occurs before a module declaration or a function definition. (Warning messages are printed if content may be ignored.)  Env  is assumed to already be set up with a suitable module context. See also:  //syntax_tools/erl_recomment ,  header/5 .","ref":"edoc_extract.html#header/4"},{"type":"function","title":"edoc_extract.header/5","doc":"Similar to  header/4 , but first inserts the given comments in the syntax trees. The syntax trees must contain valid position information. (Cf.  edoc:read_comments/2 .) See also:  //syntax_tools/erl_recomment ,  header/3 ,  header/4 .","ref":"edoc_extract.html#header/5"},{"type":"type","title":"edoc_extract.proplist/0","doc":"","ref":"edoc_extract.html#t:proplist/0"},{"type":"function","title":"edoc_extract.source/3","doc":"Like  source/5 , but reads the syntax tree and the comments from the specified file. See also:  source/4 ,  edoc:read_comments/2 ,  edoc:read_source/2 .","ref":"edoc_extract.html#source/3"},{"type":"function","title":"edoc_extract.source/4","doc":"Extracts EDoc documentation from commented source code syntax trees. The given  Forms  must be a single syntax tree of type  form_list , or a list of syntax trees representing \"program forms\" (cf.  edoc:read_source/2 .  Env  is an environment created by  edoc_lib:get_doc_env/3 . The  File  argument is used for error reporting and output file name generation only. See  edoc:get_doc/2  for descriptions of the  def ,  hidden ,  private , and  todo  options. See also:  //syntax_tools/erl_recomment ,  source/5 ,  edoc:read_comments/2 ,  edoc:read_source/2 .","ref":"edoc_extract.html#source/4"},{"type":"function","title":"edoc_extract.source/5","doc":"Like  source/4 , but first inserts the given comments in the syntax trees. The syntax trees must contain valid position information. (Cf.  edoc:read_comments/2 .) See also:  //syntax_tools/erl_recomment ,  source/3 ,  source/4 ,  edoc:read_comments/2 ,  edoc:read_source/2 .","ref":"edoc_extract.html#source/5"},{"type":"function","title":"edoc_extract.text/4","doc":"Returns the list of tags in the text. Any lines of text before the first tag are ignored.  Env  is an environment created by  edoc_lib:get_doc_env/3 . See  source/4  for a description of the  def  option.","ref":"edoc_extract.html#text/4"},{"type":"module","title":"edoc_html_to_markdown","doc":"This module can convert application/html+erlang style documentation to markdown.","ref":"edoc_html_to_markdown.html"},{"type":"function","title":"edoc_html_to_markdown.convert_html/3","doc":"Convert  application/html+erlang  ( shell_docs:chunk_element() ) to Markdown suitable for usage with ExDoc. The  Application  and  Module  argument are used to correctly generate links.","ref":"edoc_html_to_markdown.html#convert_html/3"},{"type":"behaviour","title":"edoc_layout","doc":"The standard HTML layout module for EDoc. See the  edoc  module for details on usage. See also:  edoc .","ref":"edoc_layout.html"},{"type":"callback","title":"edoc_layout.module/2","doc":"Layout entrypoint.","ref":"edoc_layout.html#c:module/2"},{"type":"function","title":"edoc_layout.module/2","doc":"The layout function. Options to the standard layout: {index_columns, integer()} Specifies the number of column pairs used for the function index tables. The default value is 1. {pretty_printer, atom()} Specifies how types and specifications are pretty printed. If the value  erl_pp  is specified the Erlang pretty printer (the module  erl_pp ) will be used. The default is to do no pretty printing which implies that lines can be very long. {stylesheet, string()} Specifies the URI used for referencing the stylesheet. The default value is  \"stylesheet.css\" . If an empty string is specified, no stylesheet reference will be generated. {sort_functions, boolean()} If  true , the detailed function descriptions are listed by name, otherwise they are listed in the order of occurrence in the source file. The default value is  true . {xml_export, Module::atom()} Specifies an  xmerl  callback module to be used for exporting the documentation. See  xmerl:export_simple/3  for details. See also:  edoc:layout/2 .","ref":"edoc_layout.html#module/2"},{"type":"type","title":"edoc_layout.options/0","doc":"","ref":"edoc_layout.html#t:options/0"},{"type":"function","title":"edoc_layout.overview/2","doc":"","ref":"edoc_layout.html#overview/2"},{"type":"function","title":"edoc_layout.type/1","doc":"","ref":"edoc_layout.html#type/1"},{"type":"module","title":"edoc_layout_chunks","doc":"Convert EDoc module documentation to an  EEP-48 docs_v1  chunk. This layout is only expected to work with  edoc_doclet_chunks . Section  Using the EDoc API  in the EDoc User's Guide shows an example of using this module. This module breaks the convention stated in  edoc_doclet  to not rely on  edoc.hrl  in doclets and layouts. It uses  #entry{}  records directly to recover information that is not otherwise available to layouts. See also:  edoc_doclet_chunks ,  //stdlib/shell_docs .","ref":"edoc_layout_chunks.html"},{"type":"type","title":"edoc_layout_chunks.beam_language/0","doc":"","ref":"edoc_layout_chunks.html#t:beam_language/0"},{"type":"type","title":"edoc_layout_chunks.doc/0","doc":"","ref":"edoc_layout_chunks.html#t:doc/0"},{"type":"type","title":"edoc_layout_chunks.doc_language/0","doc":"","ref":"edoc_layout_chunks.html#t:doc_language/0"},{"type":"type","title":"edoc_layout_chunks.doc_string/0","doc":"","ref":"edoc_layout_chunks.html#t:doc_string/0"},{"type":"type","title":"edoc_layout_chunks.docs_v1/0","doc":"The Docs v1 chunk according to EEP 48.","ref":"edoc_layout_chunks.html#t:docs_v1/0"},{"type":"type","title":"edoc_layout_chunks.docs_v1_entry/0","doc":"A tuple equivalent to the  #docs_v1_entry{}  record, but with the record name field skipped.","ref":"edoc_layout_chunks.html#t:docs_v1_entry/0"},{"type":"type","title":"edoc_layout_chunks.metadata/0","doc":"","ref":"edoc_layout_chunks.html#t:metadata/0"},{"type":"type","title":"edoc_layout_chunks.mime_type/0","doc":"","ref":"edoc_layout_chunks.html#t:mime_type/0"},{"type":"function","title":"edoc_layout_chunks.module/2","doc":"Convert EDoc module documentation to an EEP-48 style doc chunk.","ref":"edoc_layout_chunks.html#module/2"},{"type":"function","title":"edoc_layout_chunks.overview/2","doc":"","ref":"edoc_layout_chunks.html#overview/2"},{"type":"type","title":"edoc_layout_chunks.signature/0","doc":"","ref":"edoc_layout_chunks.html#t:signature/0"},{"type":"type","title":"edoc_layout_chunks.xmerl_attribute/0","doc":"","ref":"edoc_layout_chunks.html#t:xmerl_attribute/0"},{"type":"type","title":"edoc_layout_chunks.xmerl_doc_node/0","doc":"Subtype of  xmerl_xpath:nodeEntity() . It corresponds to  #xmlElement.content  as defined by  xmerl.hrl , sans the  #xmlDecl{} .","ref":"edoc_layout_chunks.html#t:xmerl_doc_node/0"},{"type":"type","title":"edoc_layout_chunks.xpath/0","doc":"","ref":"edoc_layout_chunks.html#t:xpath/0"},{"type":"module","title":"edoc_lib","doc":"Utility functions for EDoc. See also:  edoc .","ref":"edoc_lib.html"},{"type":"type","title":"edoc_lib.err/0","doc":"","ref":"edoc_lib.html#t:err/0"},{"type":"type","title":"edoc_lib.filename/0","doc":"","ref":"edoc_lib.html#t:filename/0"},{"type":"function","title":"edoc_lib.get_doc_env/3","doc":"Creates an environment data structure used by parts of EDoc for generating references, etc. See  edoc:run/2  for a description of the options  file_suffix ,  app_default  and  doc_path . See also:  edoc:get_doc/3 ,  edoc_extract:source/4 .","ref":"edoc_lib.html#get_doc_env/3"},{"type":"function","title":"edoc_lib.infer_module_app/1","doc":"Infer application containing the given module. It's expected that modules which are not preloaded and don't match the  <app>/ebin/<mod>.beam  path pattern will NOT have an app name inferred properly.  no_app  is returned in such cases.","ref":"edoc_lib.html#infer_module_app/1"},{"type":"type","title":"edoc_lib.line/0","doc":"","ref":"edoc_lib.html#t:line/0"},{"type":"type","title":"edoc_lib.proplist/0","doc":"","ref":"edoc_lib.html#t:proplist/0"},{"type":"function","title":"edoc_lib.write_file/4","doc":"","ref":"edoc_lib.html#write_file/4"},{"type":"module","title":"edoc_run","doc":"Interface for calling EDoc from Erlang startup options. The following is an example of typical usage in a Makefile: <span class=\"w\">     </span><span class=\"nc\">docs</span><span class=\"p\">:</span><span class=\"w\">\n             </span><span class=\"ss\">erl</span><span class=\"w\"> </span><span class=\"o\">-</span><span class=\"ss\">noshell</span><span class=\"w\"> </span><span class=\"o\">-</span><span class=\"ss\">run</span><span class=\"w\"> </span><span class=\"ss\">edoc_run</span><span class=\"w\"> </span><span class=\"ss\">application</span><span class=\"w\"> </span><span class=\"s\">&quot;&#39;$(APP_NAME)&#39;&quot;</span><span class=\"w\"> </span><span class=\"err\">\\</span><span class=\"w\">\n               </span><span class=\"ss\">&#39;&quot;.&quot;&#39;</span><span class=\"w\"> </span><span class=\"ss\">&#39;[{def,{vsn,&quot;$(VSN)&quot;}}]&#39;</span> (note the single-quotes to avoid shell expansion, and the double-quotes enclosing the strings). New feature in version 0.6.9 : It is no longer necessary to write  -s init stop  last on the command line in order to make the execution terminate. The termination (signalling success or failure to the operating system) is now built into these functions. See also:  edoc .","ref":"edoc_run.html"},{"type":"function","title":"edoc_run.application/1","doc":"Calls  edoc:application/3  with the corresponding arguments. The strings in the list are parsed as Erlang constant terms. The list can be either  [App] ,  [App, Options]  or  [App, Dir, Options] . In the first case  edoc:application/1  is called instead; in the second case,  edoc:application/2  is called. The function call never returns; instead, the emulator is automatically terminated when the call has completed, signalling success or failure to the operating system.","ref":"edoc_run.html#application/1"},{"type":"type","title":"edoc_run.args/0","doc":"","ref":"edoc_run.html#t:args/0"},{"type":"function","title":"edoc_run.file/1","doc":"Calls  edoc:file/2  with the corresponding arguments. The strings in the list are parsed as Erlang constant terms. The list can be either  [File]  or  [File, Options] . In the first case, an empty list of options is passed to  edoc:file/2 . The following is an example of typical usage in a Makefile: <span class=\"w\">     </span><span class=\"sc\">$(</span><span class=\"n\">DOCDIR</span><span class=\"p\">)</span><span class=\"o\">/</span><span class=\"c1\">%.html:%.erl</span><span class=\"w\">\n             </span><span class=\"ss\">erl</span><span class=\"w\"> </span><span class=\"o\">-</span><span class=\"ss\">noshell</span><span class=\"w\"> </span><span class=\"o\">-</span><span class=\"ss\">run</span><span class=\"w\"> </span><span class=\"ss\">edoc_run</span><span class=\"w\"> </span><span class=\"ss\">file</span><span class=\"w\"> </span><span class=\"ss\">&#39;&quot;$&lt;&quot;&#39;</span><span class=\"w\"> </span><span class=\"ss\">&#39;[{dir,&quot;$(DOCDIR)&quot;}]&#39;</span><span class=\"w\"> </span><span class=\"err\">\\</span><span class=\"w\">\n</span><span class=\"w\">               </span><span class=\"p\">-</span><span class=\"na\">s</span><span class=\"w\"> </span><span class=\"ss\">init</span><span class=\"w\"> </span><span class=\"ss\">stop</span> The function call never returns; instead, the emulator is automatically terminated when the call has completed, signalling success or failure to the operating system.","ref":"edoc_run.html#file/1"},{"type":"function","title":"edoc_run.files/1","doc":"Calls  edoc:files/2  with the corresponding arguments. The strings in the list are parsed as Erlang constant terms. The list can be either  [Files]  or  [Files, Options] . In the first case,  edoc:files/1  is called instead. The function call never returns; instead, the emulator is automatically terminated when the call has completed, signalling success or failure to the operating system.","ref":"edoc_run.html#files/1"},{"type":"extras","title":"EDoc Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# EDoc Release Notes\n\nThis document describes the changes made to the EDoc application.","ref":"notes.html"},{"type":"extras","title":"Edoc 1.4.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Rendering of some tables in the documentation has been improved.\n\n  Own Id: OTP-19752 Aux Id: [PR-10142]\n\n[PR-10142]: https://github.com/erlang/otp/pull/10142","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Edoc 1.4 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Refactor code to not rely on `+nowarn_shadow_vars`.\n\n  Own Id: OTP-19574 Aux Id: [PR-9678]\n\n[PR-9678]: https://github.com/erlang/otp/pull/9678","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- [EEP-69: Nominal Types](https://www.erlang.org/eeps/eep-0069) has been implemented. As a side effect, nominal types can encode opaque types. We changed all opaque-handling logic and improved opaque warnings in Dialyzer.\n  \n  All existing Erlang type systems are structural: two types are seen as equivalent if their structures are the same. Type comparisons are based on the structures of the types, not on how the user explicitly defines them. For example, in the following example, `meter()` and `foot()` are equivalent. The two types can be used interchangeably. Neither of them differ from the basic type `integer()`.\n  \n  ````\n  -type meter() :: integer().\n  -type foot() :: integer().\n  ````\n  \n  Nominal typing is an alternative type system, where two types are equivalent if and only if they are declared with the same type name. The EEP proposes one new syntax -nominal for declaring nominal types. Under nominal typing, `meter()` and `foot()` are no longer compatible. Whenever a function expects type `meter()`, passing in type `foot()` would result in a Dialyzer error.\n  \n  ````\n  -nominal meter() :: integer().\n  -nominal foot() :: integer().\n  ````\n  \n  More nominal type-checking rules can be found in the EEP. It is worth noting that most work for adding nominal types and type-checking is in `erl_types.erl`. The rest are changes that removed the previous opaque type-checking, and added an improved version of it using nominal type-checking with reworked warnings.\n  \n  Backwards compatibility for opaque type-checking is not preserved by this PR. Previous opaque warnings can appear with slightly different wordings. A new kind of opaque warning `opaque_union` is added, together with a Dialyzer option `no_opaque_union` to turn this kind of warnings off.\n\n  Own Id: OTP-19364 Aux Id: [PR-9079]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n[PR-9079]: https://github.com/erlang/otp/pull/9079\n[PR-9670]: https://github.com/erlang/otp/pull/9670","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Edoc 1.3.2 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Broken links in release notes have been mended.\n\n  Own Id: OTP-19139 Aux Id: [PR-8584]\n\n[PR-8584]: https://github.com/erlang/otp/pull/8584","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Edoc 1.3.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fix broken makefile dependency when building HTML documentation.\n\n  Own Id: OTP-19116 Aux Id: [PR-8534]\n\n[PR-8534]: https://github.com/erlang/otp/pull/8534","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Edoc 1.3 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- [EEP 48](https://www.erlang.org/eeps/eep-0048) doc chunks now properly include links within `{@type }` macros.\n\n  Own Id: OTP-18945 Aux Id: [PR-8063]\n\n- `@hidden` now means `hidden` in [EEP 48](https://www.erlang.org/eeps/eep-0048) doc chunks instead of `none`.\n\n  Own Id: OTP-18946 Aux Id: [PR-8063]\n\n[PR-8063]: https://github.com/erlang/otp/pull/8063\n[PR-8063]: https://github.com/erlang/otp/pull/8063","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- There is a new `edoc_html_to_markdown` module that can be used to convert EEP-48 [`application/html+erlang`](`t:shell_docs:chunk_elements/0`) to Markdown.\n\n  Own Id: OTP-18947 Aux Id: [PR-8063]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- Added module `m:edoc_doclet_markdown` that can be used to convert EDoc style documentation to [Markdown documentation attributes](`e:system:documentation.md`).\n\n  Own Id: OTP-19052 Aux Id: [PR-8308]\n\n[PR-8063]: https://github.com/erlang/otp/pull/8063\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8308]: https://github.com/erlang/otp/pull/8308","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Edoc 1.2.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Emit   instead of  .\n\n  Own Id: OTP-18782 Aux Id: PR-7643","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Edoc 1.2 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fix unused types warnings in internal edoc module.\n\n  Own Id: OTP-17550 Aux Id: GH-5094 PR-5106","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Add source file to the warning on skipped tags when generating EEP-48 style\n  docs.\n\n  Own Id: OTP-17556 Aux Id: PR-5023\n\n- Fix the doc chunks generators to emit documentation even if there is not\n  module level documentation.\n\n  Fix the doc chunks generators to respect the `@hidden` and `@private` tags\n  properly for both modules and functions.\n\n  Own Id: OTP-17733 Aux Id: PR-5205","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Edoc 1.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-1"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Add option `link_predefined_types` that is used to create links to erlang\n  predefined types. This is mainly to be used by erl_docgen when creating the\n  Erlang/OTP documentation.\n\n  Own Id: OTP-17743 Aux Id: PR-5292","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Edoc 1.0.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fix broken documentation link in edoc_extract:file/4.\n\n  Own Id: OTP-17552 Aux Id: GH-5058","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Edoc 1.0 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-1-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fix so that the edoc_doclet option `file_suffix` also effects the links\n  emitted into the module index.\n\n  Own Id: OTP-17092","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- EDoc, the Erlang documentation engine, hits version 1.0 with this release,\n  which means a few changes.\n\n  EDoc is now capable of emitting EEP-48 doc chunks. This means that, with some\n  configuration, community projects can now provide documentation for\n  `m:shell_docs` the same way that OTP libraries did since OTP 23.0.\n\n  The `@spec` and `@type` EDoc tags have been deprecated. These are not\n  supported with the new chunk-generating doclet and layout. Moreover,\n  previously when there was a redundant `@spec` tag and `-spec` attribute\n  defined for the same function, the `@spec` tag would take precedence. Now, the\n  `-spec` attribute takes precedence and is more important. The same is true for\n  redundant `@type` tags and `-type` attributes. Warnings are now emitted when\n  such redundant entries are found.\n\n  The `?NO_APP` macro in `edoc_doclet.hrl` has been deprecated. Use the atom\n  `no_app` instead.\n\n  See the [Doc chunks chapter in the Edoc User's Guide](chapter.md) for more\n  details.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16949 Aux Id: PR-2803 OTP-17192\n\n- Edoc has been updated to use `-spec` to document its own interface instead of\n  `@doc@` tags.\n\n  Together with this change the inter-application linking for `-spec` style\n  documentation has been improved.\n\n  Own Id: OTP-17095 Aux Id: PR-2914\n\n- Allow user defined edoc macros to be functions.\n\n  Own Id: OTP-17153 Aux Id: PR-2674","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Edoc 0.12 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-12"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Remove Inets dependency from EDoc.\n\n  Own Id: OTP-15999 Aux Id: PR-2317\n\n- Add support for overloaded Erlang specifications.\n\n  Own Id: OTP-16407 Aux Id: PR-2430\n\n- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Edoc 0.11 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-11"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Correct links in the documentation.\n\n  Own Id: OTP-15761","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Edoc 0.10 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-10"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Print a helpful message explaining that adding `{preprocess, true}` can help\n  if reading a source file fails.\n\n  Own Id: OTP-15605 Aux Id: ERL-841","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Edoc 0.9.4 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-9-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Edoc 0.9.3 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-9-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Types and function specifications including the `t:map/0` type are\n  pretty-printed correctly.\n\n  Own Id: OTP-15117","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Update to use the new string api instead of the old.\n\n  Own Id: OTP-15036","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Edoc 0.9.2 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- The map type is correctly denoted as `t:map/0` in function specifications and\n  types.\n\n  Own Id: OTP-14777","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Edoc 0.9.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-9-1"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Tools are updated to show Unicode atoms correctly.\n\n  Own Id: OTP-14464","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Edoc 0.9 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-9"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- To support stable builds, `edoc` no longer includes time stamps in the footer\n  for generated files.\n\n  Own Id: OTP-14277\n\n- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Edoc 0.8.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-8-1"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Document the function tags `@param` and `@returns`.\n\n  Own Id: OTP-13930 Aux Id: PR-1175","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Edoc 0.8 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-8"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Improve types and specs in OTP documentation generated from Erlang source\n  files.\n\n  Own Id: OTP-13720 Aux Id: ERL-120","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Edoc 0.7.19 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-19"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Handle typed record fields.\n\n  Own Id: OTP-13558","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Edoc 0.7.18 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Assign correct names to list arguments.\n\n  Own Id: OTP-13234 Aux Id: ERL-63","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Unless the `sort_functions` option is `true`, `edoc_layout` does not sort\n  functions.\n\n  Own Id: OTP-13302","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Edoc 0.7.17 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-17"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Remove functionality related to packages\n\n  Own Id: OTP-12431","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Edoc 0.7.16 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Maps: Properly align union typed assoc values in documentation\n\n  Own Id: OTP-12190","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Edoc 0.7.15 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fix spec to doc generation from erl_docgen and edoc for maps\n\n  Own Id: OTP-12058","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Edoc 0.7.14 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-14"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- The default encoding for Erlang source files is now UTF-8. As a temporary\n  measure to ease the transition from the old default of Latin-1, if EDoc\n  encounters byte sequences that are not valid UTF-8 sequences, EDoc will re-try\n  in Latin-1 mode. This workaround will be removed in a future release.\n\n  Own Id: OTP-12008","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Edoc 0.7.13 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Edoc 0.7.12.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-12-1"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- The encoding of the `notes.xml` file has been changed from latin1 to utf-8 to\n  avoid future merge problems.\n\n  Own Id: OTP-11310","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Edoc 0.7.12 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- EDoc sometimes failed to associate a comment with the preceding type\n  declaration. This bug has been fixed. (Thanks to Serge Aleynikov for reporting\n  the bug.)\n\n  Own Id: OTP-10866","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Miscellaneous updates due to Unicode support.\n\n  Own Id: OTP-10820","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Edoc 0.7.11 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-11"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Since EDoc 0.7.7 (R14B02) separate values of union types can be annotated.\n  However, the parser has hitherto chosen not to add the necessary parentheses\n  due to backwards compatibility.\n\n  From this release on code traversing the output of `edoc_parser` needs to take\n  care of parentheses around separate values of union types. Examples of such\n  code are layout modules and doclet modules.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10195\n\n- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302\n\n- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Edoc 0.7.10 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- List behaviour callbacks in Edoc when using -callback attribute. (Thanks to\n  Magnus Henoch.)\n\n  Added special case for file names under Windows. (Thanks to Beads\n  Land-Trujillo.)\n\n  Own Id: OTP-10174","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Edoc 0.7.9.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-9-1"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Miscellaneous documentation build updates\n\n  Own Id: OTP-9813","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Edoc 0.7.9 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- `no_return` is a new built-in type.\n\n  Own Id: OTP-9350\n\n- synchronized with edoc development version\n\n  forgot to ensure that xmerl is found in path for include_lib to work\n\n  fix -spec declaration that doesn't work in R13B04\n\n  eliminate warnings about unused imports\n\n  removed CVS-keywords from source files (Thanks to Richard Carlsson )\n\n  Own Id: OTP-9463\n\n- Add a proplist() type\n\n  Recently I was adding specs to an API and found that there is no canonical\n  proplist() type defined. (Thanks to Ryan Zezeski)\n\n  Own Id: OTP-9499\n\n- Removed some never-matching clauses reported by dialyzer Fix macro expansion\n  in comments following Erlang types URI-escape bytes as two hex digits always\n  (reported by Alfonso De Gregorio) Updated author e-mail Recognize some more\n  URI schemas in wiki text, in particular https (Thanks to Richard Carlsson)\n\n  Own Id: OTP-9590","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Edoc 0.7.8 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fix infinite loop for malformed edoc input\n\n  When processing an edoc comment with \\`\\`\\` in it, if the comment ends without\n  a matching ''' then an infinite loop occurs in the function\n  edoc_wiki:strip_empty_lines/2. This change fixes that by adding a clause to\n  return from the function upon the end of the comment input. This allows an\n  error to be thrown to indicate the problem, which is the same behaviour as\n  leaving either \\`\\` or \\` unmatched. (Thanks to Taylor Venable)\n\n  Own Id: OTP-9165\n\n- Bugs concerning the option `report_missing_types` that was added in EDoc-0.7.7\n  have been corrected: the option was misspelled in the source, and local\n  definitions as well as the function tags `@private` and `@hidden` were not\n  handled correctly. (Thanks to Manolis Papadakis.)\n\n  Own Id: OTP-9301","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Edoc 0.7.7 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Add encoding when parsing Wiki text. EDoc used to fail on strings such as\n  \"äåö\". (Thanks to Richard Carlsson.)\n\n  Own Id: OTP-9109","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- It is now possible to use Erlang specifications and types in EDoc\n  documentation. Erlang specifications and types will be used unless there is\n  also a function specification (`@spec`) or a type alias (`@type`) with the\n  same name. In the current implementation the placement of `-spec` matters: it\n  should be placed where the `@spec` would otherwise have been placed.\n\n  Not all Erlang types are included in the documentation, but only those\n  exported by some `export_type` declaration or used by some documented Erlang\n  specification (`-spec`).\n\n  There is currently no support for overloaded Erlang specifications.\n\n  The syntax definitions of EDoc have been augmented to cope with most of the\n  Erlang types. (But we recommend that Erlang types should be used instead.)\n\n  `edoc:read_source()` takes one new option, `report_missing_types`.\n  `edoc_layout:module()` takes one new option, `pretty_printer`.\n\n  Own Id: OTP-8525\n\n- The `edoc_lib` module is meant to be private, but since it is referred to from\n  other man pages it has been included in the OTP documentation. The\n  modifications introduced in this ticket make all functions private except\n  those referred to from other pages.\n\n  Own Id: OTP-9110","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Edoc 0.7.6.8 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-8"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Compiler warnings were eliminated.\n\n  Own Id: OTP-8855","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Edoc 0.7.6.7 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Edoc now uses the new API functions to `inets` instead of the deprecated ones.\n\n  Own Id: OTP-8749","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Edoc 0.7.6.6 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-6"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- The documentation is now possible to build in an open source environment after\n  a number of bugs are fixed and some features are added in the documentation\n  build process.\n\n  \\- The arity calculation is updated.\n\n  \\- The module prefix used in the function names for bif's are removed in the\n  generated links so the links will look like\n  \"http://www.erlang.org/doc/man/erlang.html#append_element-2\" instead of\n  \"http://www.erlang.org/doc/man/erlang.html#erlang:append_element-2\".\n\n  \\- Enhanced the menu positioning in the html documentation when a new page is\n  loaded.\n\n  \\- A number of corrections in the generation of man pages (thanks to Sergei\n  Golovan)\n\n  \\- The legal notice is taken from the xml book file so OTP's build process can\n  be used for non OTP applications.\n\n  Own Id: OTP-8343","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Edoc 0.7.6.5 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-5"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Edoc 0.7.6.4 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-4"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Miscellaneous updates.\n\n  Own Id: OTP-8190","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Edoc 0.7.6.3 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-3"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- The copyright notices have been updated.\n\n  Own Id: OTP-7851","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Edoc 0.7.6.2 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-2"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Minor updates.\n\n  Own Id: OTP-7642","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Edoc 0.7.6.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Correction to work with new versions of STDLIB that no longer has the\n  `erl_internal:obsolete/3` function.\n\n  Own Id: OTP-7539","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Edoc 0.7.6 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-6"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Minor changes.\n\n  Own Id: OTP-7388","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Edoc 0.7.5 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-5"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Minor updates, mostly cosmetic.\n\n  Own Id: OTP-7243","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Edoc 0.7.3 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-3"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689\n\n- Dialyzer warnings were eliminated.\n\n  Own Id: OTP-6737","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"EDoc 0.7.2 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Some missing files have been added: `~/include/edoc_doclet.hrl`,\n  `~/priv/edoc.dtd`, `~/priv/erlang.png`\n\n  Own Id: OTP-6457","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Improvements and New Features - EDoc Release Notes","doc":"- - Undefined macros only cause warnings, not errors.\n  - New, built-in `@version` macro.\n  - Documented the `@docfile` and `@headerfile` generic tags.\n  - Added recognition of `\"TODO:\"` as a wiki equivalent for `@todo` tags.\n  - Added documentation about overview pages.\n  - `'where'` and `','` are allowed as separators in specs.\n  - Corrected ambiguity in spec grammar (possible incompatibility issue -\n    parentheses may need to be added in some cases, in existing code).\n  - Experimental (and undocumented) support for `@param` and `@return` tags and\n    corresponding `\"...\"` annotations on `@spec` parameters.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-6568","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"EDoc 0.7.1 - EDoc Release Notes","doc":"","ref":"notes.html#edoc-0-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EDoc Release Notes","doc":"- Fixed some broken links in the documentation.\n\n  Own Id: OTP-6419","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"EDoc 0.7.0 - EDoc Release Notes","doc":"Miscellaneous changes.","ref":"notes.html#edoc-0-7-0"},{"type":"extras","title":"Welcome to EDoc","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0 OR LGPL-2.1-or-later\n\nCopyright 2001-2025 Richard Carlsson. All Rights Reserved.\nCopyright Ericsson AB 2024-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\nAlternatively, you may use this file under the terms of the GNU Lesser\nGeneral Public License (the \"LGPL\") as published by the Free Software\nFoundation; either version 2.1, or (at your option) any later version.\nIf you wish to allow use of your version of this file only under the\nterms of the LGPL, you should delete the provisions above and replace\nthem with the notice and other provisions required by the LGPL; see\n . If you do not delete the provisions\nabove, a recipient may use your version of this file under the terms of\neither the Apache License or the LGPL.\n\n%CopyrightEnd%\n-->\n# Welcome to EDoc\n\nEDoc is the Erlang program documentation generator. Inspired by the Javadoc(TM)\ntool for the Java(TM) programming language, EDoc is adapted to the conventions\nof the Erlang world, and has several features not found in Javadoc.\n\nEDoc can generate static HTML documentation accessible with any web browser or\n[EEP-48](https://www.erlang.org/erlang-enhancement-proposals/eep-0048.html) doc\nchunks with [erlang+html(3)](`e:edoc:doc_storage.md`) to provide\ndocumentation for other tools like `m:shell_docs`.","ref":"chapter.html"},{"type":"extras","title":"Contents - Welcome to EDoc","doc":"- [Introduction](chapter.md#introduction)\n- [Running EDoc](chapter.md#Running_EDoc)\n- [The overview page](chapter.md#The_overview_page)\n- [Generic tags](chapter.md#Generic_tags)\n- [Overview tags](chapter.md#Overview_tags)\n- [Module tags](chapter.md#Module_tags)\n- [Function tags](chapter.md#Function_tags)\n- [References](chapter.md#references)\n- [Notes on XHTML](chapter.md#Notes_on_XHTML)\n- [Wiki notation](chapter.md#Wiki_notation)\n- [Macro expansion](chapter.md#Macro_expansion)\n- [Type specifications](chapter.md#Type_specifications)\n- [Doc chunks](chapter.md#Doc_chunks)\n- [Acknowledgements](chapter.md#acknowledgements)","ref":"chapter.html#contents"},{"type":"extras","title":"Introduction - Welcome to EDoc","doc":"EDoc lets you write the documentation of an Erlang program as comments in the\nsource code itself, using _tags_ of the form \"`@Name ...`\". A source file does\nnot have to contain tags for EDoc to generate its documentation, but without\ntags the result will only contain the basic available information that can be\nextracted from the module.\n\nA tag must be the first thing on a comment line, except for leading '`%`'\ncharacters and whitespace. The comment must be between program declarations, and\nnot on the same line as any program text. All the following text - including\nconsecutive comment lines - up until the end of the comment or the next tagged\nline, is taken as the _content_ of the tag.\n\nTags are associated with the nearest following program construct \"of\nsignificance\" (the module name declaration and function definitions). Other\nconstructs are ignored; e.g., in:\n\n```text\n   %% @doc Prints the value X.\n\n   -record(foo, {x, y, z}).\n\n   print(X) -> ...\n```\n\nthe `@doc` tag is associated with the function `print/1`.\n\nNote that in a comment such as:\n\n```text\n   % % @doc ...\n```\n\nthe tag is ignored, because only the first '`%`' character is considered\n\"leading\". This allows tags to be \"commented out\".\n\nSome tags, such as `@type`, do not need to be associated with any program\nconstruct. These may be placed at the end of the file, in the \"footer\".\n\n[](){: #Running_EDoc }","ref":"chapter.html#introduction"},{"type":"extras","title":"Running EDoc - Welcome to EDoc","doc":"The following are the main functions for running EDoc:\n\n- `edoc:application/2`: Creates documentation for a typical Erlang application.\n- `edoc:files/2`: Creates documentation for a specified set of source files.\n- `edoc:run/2`: General interface function; the common back-end for the above\n  functions. Options are documented here.\n\nNote that the function `edoc:file/2` belongs to the old, deprecated interface\n(from EDoc version 0.1), and should not be used.\n\nIt's also possible to run EDoc directly from the command line, using the\n[bin/edoc EScript](edoc_cmd.md). The script acts as a command line entry point\nto both `edoc:application/2` and `edoc:files/2` functions. It also allows to\ngenerate just the EEP-48 doc chunks (using the `-chunks` flag) instead of the\ncomplete HTML documentation.\n\n[](){: #The_overview_page }","ref":"chapter.html#running-edoc"},{"type":"extras","title":"The overview page - Welcome to EDoc","doc":"When documentation is generated for an entire application, an overview page, or\n\"front page\", is generated. (The page you are now reading is an overview page.)\nThis should contain the high-level description or user manual for the\napplication, leaving the finer details to the documentation for individual\nmodules. By default, the overview page is generated from the file\n`overview.edoc` in the target directory (typically, this is the `doc`\nsubdirectory of the application directory); see `m:edoc_doclet` for details.\n\nThe format of the overview file is the same as for EDoc documentation comments\n(see [Introduction](chapter.md#introduction)), except that the lines do not have\nleading '`%`' characters. Furthermore, all lines before the first tag line are\nignored, and can be used as a comment. All tags in the overview file, such as\n`@doc`, `@version`, etc., refer to the application as a whole; see\n[Overview tags](chapter.md#Overview_tags) for details.\n\nHere is an example of the contents of an overview file:\n\n```text\n   ** this is the overview.doc file for the application 'frob' **\n\n   @author R. J. Hacker  \n   @copyright 2007 R. J. Hacker\n   @version 1.0.0\n   @title Welcome to the `frob' application!\n   @doc `frob' is a highly advanced frobnicator with low latency,\n   ...\n```\n\n[](){: #Generic_tags }","ref":"chapter.html#the-overview-page"},{"type":"extras","title":"Generic tags - Welcome to EDoc","doc":"The following tags can be used anywhere within a module:\n\n- **`@clear`** - [](){: #gtag-clear } This tag causes all tags above it (up to\n  the previous program construct), to be discarded, including the `@clear` tag\n  itself. The text following the tag is also ignored. _This is typically only\n  useful in code containing conditional compilation, when preprocessing is\n  turned on._ (Preprocessing is turned off by default.) E.g., in\n\n  ```text\n     -ifdef(DEBUG).\n     %% @doc ...\n     foo(...) -> ...\n     -endif.\n     %% @clear\n\n     %% @doc ...\n     bar(...) -> ...\n  ```\n\n  the `@clear` tag makes sure that EDoc does not see two `@doc` tags before the\n  function `bar`, even if the code for function `foo` is removed by\n  preprocessing. (There is no way for EDoc to see what the first `@doc` tag\n  \"really\" belongs to, since preprocessing strips away all such information.)\n\n- **`@docfile`** - [](){: #gtag-docfile } Reads a plain documentation file (on\n  the same format as an overview file - see\n  [The overview page](chapter.md#The_overview_page) for details), and uses the\n  tags in that file as if they had been written in place of the `@docfile` tag.\n  The content is the name of the file to be read; leading and trailing\n  whitespace is ignored. See also [@headerfile](chapter.md#gtag-headerfile).\n\n- **`@end`** - [](){: #gtag-end } The text following this tag is always ignored.\n  Use this to mark the end of the previous tag, when necessary, as e.g. in:\n\n  ```text\n     %% ----------------------------------\n     %% ...\n     %% @doc ...\n     %% ...\n     %% @end\n     %% ----------------------------------\n  ```\n\n  to avoid including the last \"ruler\" line in the `@doc` tag.\n\n  _Note: using some other \"dummy\" @-tag for the same purpose might work in a\n  particular implementation of EDoc, but is not guaranteed to. Always use @end\n  to ensure future compatibility._\n\n- **`@headerfile`** - [](){: #gtag-headerfile } Similar to the\n  [@docfile tag](chapter.md#gtag-docfile), but reads a file containing Erlang\n  source code - generally this should be a header file (with the extension\n  `.hrl`). If the file turns out to contain one or more function definitions or\n  a module declaration, all tags that occur above the last such definition or\n  module declaration are ignored, and EDoc will print a warning. This tag allows\n  you to write documentation in a header file and insert it at a specific place\n  in the documentation, even if the header file is used (i.e., included) by\n  several modules. The `includes` option can be used to specify a search path\n  (see `edoc:read_source/2`).\n\n- **`@todo` (or `@TODO`)** - [](){: #gtag-todo } Attaches a To-Do note to a\n  function, module or overview-page. The content can be any XHTML text\n  describing the issue, e.g.:\n\n  ```text\n     %% @TODO Finish writing the documentation.\n  ```\n\n  or\n\n  ```text\n     %% @todo Implement  RFC 2549 .\n  ```\n\n  These tags can also be written as \"`TODO:`\", e.g.:\n\n  ```text\n     %% TODO: call your mother\n  ```\n\n  see [Wiki notation](chapter.md#Wiki_notation) for more information. To-Do\n  notes are normally not shown unless the `todo` option is turned on (see\n  `edoc:get_doc/2`).\n\n- **`@type`** - [](){: #gtag-type } Documents an abstract data type or type\n  alias. The content consists of a type declaration or definition, optionally\n  followed by a period ('`.`') separator and XHTML text describing the type\n  (i.e., its purpose, use, etc.). There must be at least one whitespace\n  character between the '`.`' and the text. See\n  [Type specifications](chapter.md#Type_specifications) for syntax and examples.\n  All data type descriptions are placed in a separate section of the\n  documentation, regardless of where the tags occur.\n\n  Instead of specifying the complete type alias in an EDoc documentation\n  comment, type definitions from the actual Erlang code can be re-used for\n  documentation. See [Type specifications](chapter.md#Type_specifications) for\n  examples.\n\n[](){: #Overview_tags }","ref":"chapter.html#generic-tags"},{"type":"extras","title":"Overview tags - Welcome to EDoc","doc":"The following tags can be used in an overview file.\n\n- **`@author`** - [](){: #otag-author } See the\n  [@author module tag](chapter.md#mtag-author) for details.\n\n- **`@copyright`** - [](){: #otag-copyright } See the\n  [@copyright module tag](chapter.md#mtag-copyright) for details.\n\n- **`@doc`** - [](){: #otag-doc } See the [@doc module tag](chapter.md#mtag-doc)\n  for details.\n\n- **`@reference`** - [](){: #otag-reference } See the\n  [@reference module tag](chapter.md#mtag-reference) for details.\n\n- **`@see`** - [](){: #otag-see } See the [@see module tag](chapter.md#mtag-see)\n  for details.\n\n- **`@since`** - [](){: #otag-since } See the\n  [@since module tag](chapter.md#mtag-since) for details.\n\n- **`@title`** - [](){: #otag-title } Specifies a title for the overview page.\n  This tag can _only_ be used in an overview file. The content can be arbitrary\n  text.\n\n- **`@version`** - [](){: #otag-version } See the\n  [@version module tag](chapter.md#mtag-version) for details.\n\n[](){: #Module_tags }","ref":"chapter.html#overview-tags"},{"type":"extras","title":"Module tags - Welcome to EDoc","doc":"The following tags can be used before a module declaration:\n\n- **`@author`** - [](){: #mtag-author } Specifies the name of an author, along\n  with contact information. An e-mail address can be given within `<...>`\n  delimiters, and a URI within `[...]` delimiters. Both e-mail and URI are\n  optional, and any surrounding whitespace is stripped from all strings.\n\n  The name is the first nonempty string that is not within `<...>` or `[...]`,\n  and does not contain only whitespace. (In other words, the name can come\n  before, between, or after the e-mail and URI, but cannot be split up; any\n  sections after the first are ignored.) If an e-mail address is given, but no\n  name, the e-mail string will be used also for the name. If no `<...>` section\n  is present, but the name string contains an '`@`' character, it is assumed to\n  be an e-mail address. Not both name and e-mail may be left out.\n\n  Examples:\n\n  ```text\n     %% @author Richard Carlsson\n  ```\n\n  ```text\n     %% @author Richard Carlsson  \n     %%   [http://example.net/richardc/]\n  ```\n\n  ```text\n     %% @author  \n  ```\n\n  ```text\n     %% @author carlsson.richard@gmail.com [http://example.net/richardc/]\n  ```\n\n- **`@copyright`** - [](){: #mtag-copyright } Specifies the module copyrights.\n  The content can be arbitrary text; for example:\n\n  ```text\n     %% @copyright 2001-2003 Richard Carlsson\n  ```\n\n- **`@deprecated`** - [](){: #mtag-deprecated } Mark the module as deprecated,\n  indicating that it should no longer be used. The content must be well-formed\n  XHTML, and should preferably include a `{@link}` reference to a replacement;\n  as in:\n\n  ```text\n     %% @deprecated Please use the module {@link foo} instead.\n  ```\n\n- **`@doc`** - [](){: #mtag-doc } Describes the module, using well-formed XHTML\n  text. The first sentence is used as a summary (see the\n  [@doc function tag](chapter.md#ftag-doc) for details). For example.:\n\n  ```text\n     %% @doc This is a  very  useful module. It is ...\n  ```\n\n- **`@hidden`** - [](){: #mtag-hidden } Marks the module so that it will not\n  appear in the documentation (even if \"private\" documentation is generated).\n  Useful for sample code, test modules, etc. The content can be used as a\n  comment; it is ignored by EDoc.\n\n- **`@private`** - [](){: #mtag-private } Marks the module as private (i.e., not\n  part of the public interface), so that it will not appear in the normal\n  documentation. (If \"private\" documentation is generated, the module will be\n  included.) The content can be used as a comment; it is ignored by EDoc.\n\n- **`@reference`** - [](){: #mtag-reference } Specifies a reference to some\n  arbitrary external resource, such as an article, book, or web site. The\n  content must be well-formed XHTML text. Examples:\n\n  ```text\n     %% @reference Pratchett, T.,  Interesting Times ,\n     %% Victor Gollancz Ltd, 1994.\n  ```\n\n  ```text\n     %% @reference See  Google  for\n     %% more information.\n  ```\n\n- **`@see`** - [](){: #mtag-see } See the\n  [@see function tag](chapter.md#ftag-see) for details.\n\n- **`@since`** - [](){: #mtag-since } Specifies when the module was introduced,\n  with respect to the application, release or distribution it is part of. The\n  content can be arbitrary text.\n\n- **`@version`** - [](){: #mtag-version } Specifies the module version. The\n  content can be arbitrary text.\n\n[](){: #Function_tags }","ref":"chapter.html#module-tags"},{"type":"extras","title":"Function tags - Welcome to EDoc","doc":"The following tags can be used before a function definition:\n\n- **`@deprecated`** - [](){: #ftag-deprecated } See the\n  [@deprecated module tag](chapter.md#mtag-deprecated) for details.\n\n- **`@doc`** - [](){: #ftag-doc } XHTML text describing the function. The first\n  sentence of the text is used as a quick summary; this ends at the first period\n  character ('`.`') or exclamation mark ('`!`') that is followed by a whitespace\n  character, a line break, or the end of the tag text, and is not within XML\n  markup. (As an exception, the first sentence may be within an initial\n  paragraph element)\n\n- **`@equiv`** - [](){: #ftag-equiv } Specify equivalence to another function\n  call/expression. The content must be a proper Erlang expression. If the\n  expression is a function call, a cross-reference to the called function is\n  created automatically. Typically, this tag is used instead of `@doc`.\n\n- **`@hidden`** - [](){: #ftag-hidden } Marks the function so that it will not\n  appear in the documentation (even if \"private\" documentation is generated).\n  Useful for debug/test functions, etc. The content can be used as a comment; it\n  is ignored by EDoc.\n\n- **`@param`** - [](){: #ftag-param } Provide more information on a single\n  parameter of the enclosing function. The content consists of a parameter name,\n  followed by one or more whitespace characters, and XHTML text.\n\n- **`@private`** - [](){: #ftag-private } Marks the function as private (i.e.,\n  not part of the public interface), so that it will not appear in the normal\n  documentation. (If \"private\" documentation is generated, the function will be\n  included.) Only useful for exported functions, e.g. entry points for `spawn`.\n  (Non-exported functions are always \"private\".) The content can be used as a\n  comment; it is ignored by EDoc.\n\n- **`@returns`** - [](){: #ftag-returns } Specify additional information about\n  the value returned by the function. Content consists of XHTML text.\n\n- **`@see`** - [](){: #ftag-see } Make a reference to a module, function,\n  datatype, or application. (See [References](chapter.md#references).) The\n  content consists of a reference, optionally followed by a period ('`.`'), one\n  or more whitespace characters, and XHTML text to be used for the label; for\n  example \"`@see edoc`\" or \"`@see edoc.  EDoc `\". If no label text is\n  specified, the reference itself is used as the label.\n\n- **`@since`** - [](){: #ftag-since } Specifies in what version of the module\n  the function was introduced; cf. the\n  [@version module tag](chapter.md#mtag-version). The content can be arbitrary\n  text.\n\n- **`@spec`** - [](){: #ftag-spec } Used to specify the function type; see\n  [Type specifications](chapter.md#Type_specifications) for syntax details. If\n  the function name is included in the specification, it must match the name in\n  the actual code. When parameter names are not given in the specification,\n  suitable names will be taken from the source code if possible, and otherwise\n  synthesized.\n\n  Instead of specifying the complete function type in an EDoc documentation\n  comment, specifications from the actual Erlang code can be re-used for\n  documentation. See [Type specifications](chapter.md#Type_specifications) for\n  examples.\n\n- **`@throws`** - [](){: #ftag-throws } Specifies which types of terms may be\n  thrown by the function, if its execution terminates abruptly due to a call to\n  `erlang:throw(Term)`. The content is a type expression (see\n  [Type specifications](chapter.md#Type_specifications)), and can be a union\n  type.\n\n  Note that exceptions of type `exit` (as caused by calls to\n  `erlang:exit(Term)`) and `error` (run-time errors such as `badarg` or\n  `badarith`) are not viewed as part of the normal interface of the function,\n  and cannot be documented with the `@throws` tag.\n\n- **`@type`** - [](){: #ftag-type } See the\n  [@type generic tag](chapter.md#gtag-type) for details. Placing a `@type` tag\n  by a function definition may be convenient, but does not affect where the\n  description is placed in the generated documentation.","ref":"chapter.html#function-tags"},{"type":"extras","title":"References - Welcome to EDoc","doc":"In several contexts (`@see` tags, `@link` macros, etc.), EDoc lets you refer to\nthe generated documentation for modules, functions, datatypes, and applications,\nusing a simple and compact syntax. The possible formats for references are:\n\n| Reference syntax                      | Example                                      | Scope         |\n| ------------------------------------- | -------------------------------------------- | ------------- |\n| `Module`                              | `m:edoc_run`, `erl.lang.list`                | Global        |\n| `Function/Arity`                      | `file/2`                                     | Within module |\n| `Module:Function/Arity`               | `edoc:application/2`                         | Global        |\n| `Type()`                              | `filename()`                                 | Within module |\n| `Module:Type()`                       | [edoc:edoc_module()](`t:edoc:edoc_module/0`) | Global        |\n| `//Application`                       | [edoc](index.html)                           | Global        |\n| `//Application/Module`                | `m:edoc_doclet`                              | Global        |\n| `//Application/Module:Function/Arity` | `edoc_run:file/1`                            | Global        |\n| `//Application/Module:Type()`         | [edoc:edoc_module()](`t:edoc:edoc_module/0`) | Global        |\n\n_Table: reference syntax_\n\nEDoc will resolve references using the information it finds in\n`edoc-info`\\-files at the locations specified with the `doc_path` option. EDoc\nwill automatically (and somewhat intelligently) try to find any local\n`edoc-info`\\-files using the current code path, and add them to the end of the\n`doc_path` list. The target doc-directory is also searched for an existing info\nfile; this allows documentation to be built incrementally. (Use the `new` option\nto ignore any old info file.)\n\nNote that if the name of a module, function or datatype is explicitly qualified\nwith an application (as in \"`//edoc/edoc_run`\"), this overrides any other\ninformation about that name, and the reference will be made relative to the\nlocation of the application (if it can be found). This makes it possible to\nrefer to e.g. a module \"`fred`\" as \"`//foo/fred`\" without accidentally getting a\nreference to \"`//bar/fred`\". You should not use this form of explicit references\nfor names that are local to the application you are currently creating - they\nwill always be resolved correctly.\n\nNote that module-local references such as `file/2` only work properly within a\nmodule. In an overview-page like this (i.e., the one you are currently reading),\nno module context is available.\n\n[](){: #Notes_on_XHTML }","ref":"chapter.html#references"},{"type":"extras","title":"Notes on XHTML - Welcome to EDoc","doc":"In several places, XHTML markup can be used in the documentation text, in\nparticular in `@doc` tags. The main differences from HTML are the following:\n\n- All elements must have explicit start and end tags, and be correctly nested.\n  This means that you cannot e.g. write a ` ` tag without also writing a\n  corresponding ` ` tag in the right place. This could be an annoyance at\n  times, but has the great advantage that EDoc can report all malformed XHTML in\n  your source code, rather than propagate the errors to the generated\n  documentation.\n- XHTML tag and attribute names should always be lower-case.\n- Attributes must be quoted, as in e.g. ` `.\n\nTo write an element like the HTML ` `, which has no actual content, you can\nwrite either the full `  `, or better, use the XHTML abbreviated form\n` `.\n\nSince the purpose of EDoc is to document programs, there is also a limited form\nof \"wiki\"-syntax available for making program code easier to write inline (and\nto make the doc-comments easier to read). See\n[Wiki notation](chapter.md#Wiki_notation) for details.\n\nThe HTML heading tags `h1` and `h2` are reserved for use by EDoc. Headings in\ndocumentation source code should start at `h3`. There is however a special\nsyntax for writing headings which avoids using specific level numbers\naltogether; see [Headings](chapter.md#headings) for details.\n\nEDoc uses [XMerL](`e:xmerl:index.html`) to parse and export XML markup.\n\n[](){: #Wiki_notation }","ref":"chapter.html#notes-on-xhtml"},{"type":"extras","title":"Wiki notation - Welcome to EDoc","doc":"When EDoc parses XHTML, it does additional pre- and post-processing of the text\nin order to expand certain notation specific to EDoc into proper XHTML markup.\nThis \"wiki\"\n([http://en.wikipedia.org/wiki/Wiki](http://en.wikipedia.org/wiki/Wiki))\nnotation is intended to make it easier to write source code documentation.\n\n[](){: #Empty_lines_separate_paragraphs }","ref":"chapter.html#wiki-notation"},{"type":"extras","title":"Empty lines separate paragraphs - Welcome to EDoc","doc":"Leaving an empty line in XHTML text (i.e., a line which except for any leading\nstart-of-comment '`%`' characters contains only whitespace), will make EDoc\nsplit the text before and after the empty line into separate paragraphs. For\nexample:\n\n```text\n   %% @doc This will all be part of the first paragraph.\n   %% It can stretch over several lines and contain  any\n   %% XHTML markup .\n   %%\n   %% This is the second paragraph. The above line is\n   %% regarded as \"empty\" by EDoc, even though it ends with\n   %% a space.\n```\n\nwill generate the following text:\n\n> This will all be part of the first paragraph. It can stretch over several\n> lines and contain _any XHTML markup_.\n>\n> This is the second paragraph. The above line is regarded as \"empty\" by EDoc,\n> even though it ends with a space.\n\nParagraph splitting takes place after the actual XHTML parsing. It only affects\nblock-level text, and not e.g., text within ` ` markup, or text that is\nalready within ` ` markup.","ref":"chapter.html#empty-lines-separate-paragraphs"},{"type":"extras","title":"Headings - Welcome to EDoc","doc":"Section headings, sub-headings, and sub-sub-headings, can be written using the\nfollowing notation:\n\n```text\n   == Heading ==\n   === Sub-heading ===\n   ==== Sub-sub-heading ====\n```\n\nSuch a heading must be alone on a line, except for whitespace, and cannot be\nsplit over several lines. A link target is automatically created for the\nheading, by replacing any whitespace within the text by a single underscore\ncharacter. E.g.,\n\n```text\n   == Concerning Hobbits ==\n```\n\nis equivalent to\n\n```text\n     Concerning Hobbits  \n```\n\nThus, headings using this notation should not contain characters that may not be\npart of URL labels, except for whitespace. If you need to create such headings,\nyou have to use the explicit XHTML markup.\n\nA hypertext link to a heading written this way can be created using the\n`@section` macro, which transforms the argument text into a label as described\nabove. E.g.,\n\n```text\n   {@section Concerning Hobbits}\n```\n\nis equivalent to writing\n\n```text\n    Concerning Hobbits \n```\n\nThe above expansions take place before XML parsing.\n\n[](){: #External_links }","ref":"chapter.html#headings"},{"type":"extras","title":"External links - Welcome to EDoc","doc":"Writing a URL within brackets, as in \"`[http://www.w3c.org/]`\", will generate a\nhyperlink such as [http://www.w3c.org/](http://www.w3c.org/), using the URL both\nfor the destination and the label of the reference, equivalent to writing\n\"`  http://www.w3c.org/  `\". This\nshort-hand keeps external URL references short and readable. The recognized\nprotocols are `http`, `ftp`, and `file`. This expansion takes place before XML\nparsing.","ref":"chapter.html#external-links"},{"type":"extras","title":"TODO-notes - Welcome to EDoc","doc":"Lines that begin with the text \"`TODO:`\" (the colon is required) are recognized\nas tags, as if they had been written as \"`@todo ...`\" (see\n[@todo tags](chapter.md#gtag-todo) for further details).\n\n[](){: #Verbatim_quoting }","ref":"chapter.html#todo-notes"},{"type":"extras","title":"Verbatim quoting - Welcome to EDoc","doc":"In XHTML text, the '`` ` ``' character (Unicode `000060`, known as \"grave\naccent\" or \"back-quote\") can be used for verbatim quoting. This expansion takes\nplace before XML parsing.\n\n- A character sequence \"`` `...' ``\" or \"` ``...'' `\" will be expanded to\n  \"` ... `\", where all occurrences of the special XML characters\n  '`<`' and '`&`' (and for completeness, also '`>`') in the quoted text have\n  been escaped to \"`&lt;`\", \"`&amp;`\", and \"`&gt;`\", respectively. All\n  whitespace is stripped from the beginning and end of the quoted text.\n\n  Double back-quotes \"` ``...'' `\" can be used to quote text containing single\n  '`'`' characters. The automatic stripping of any surrounding whitespace makes\n  it possible to write things like \"` `` 'foo@bar' '' `\".\n\n  To quote text containing \"`''`\" verbatim, explicit ` ` markup or similar\n  must be used.\n\n- A character sequence \"` ```...''' `\" will be expanded to\n  \"` <![CDATA[...]]> `\", which disables all XML markup within the\n  quoted text, and displays the result in fixed-font with preserved indentation.\n  Whitespace is stripped from the end of the quoted text, but not from the\n  beginning, except for whole leading lines of whitespace. This is useful for\n  multi-line code examples, or displayed one-liners.\n- To produce a single '`` ` ``'-character in XML without beginning a new quote,\n  you can write \"`` `' ``\" (no space between the '`` ` ``' and the '`'`'). You\n  can of course also use the XML character entity \"`&#x60;`\".\n\nExamples:\n\n```text\n     %% @doc ...where the variable `Foo' refers to...\n```\n\n```text\n     %% @doc ...returns the atom `` 'foo@erlang.org' ''...\n```\n\n````text\n     %% @doc ...use the command ```erl -name foo''' to...\n````\n\n````text\n     %% @doc ...as in the following code:\n     %% ```f(X) ->\n     %%       case X of\n     %%          ...\n     %%       end'''\n````\n\n````text\n     %% @doc ...or in the following:\n     %% ```\n     %%     g(X) ->\n     %%       fun () -> ... end\n     %% '''\n````\n\n[](){: #Macro_expansion }","ref":"chapter.html#verbatim-quoting"},{"type":"extras","title":"Macro expansion - Welcome to EDoc","doc":"Before the content of a tag is parsed, the text undergoes _macro expansion_. The\nsyntax for macro calls is:\n\n```text\n    {@name}\n```\n\nor\n\n```text\n    {@name argument}\n```\n\nwhere _name_ and _argument_ are separated by one or more whitespace characters.\nThe argument can be any text, which may contain other macro calls. The number of\nnon-escaped \"`{@`\" and \"`}`\" delimiters must be balanced.\n\nThe argument text is first expanded in the current environment, and the result\nis bound to the _macro parameter_, written `{@?}`. (If no argument is given,\n`{@?}` is bound to the empty string.) The macro definition is then substituted\nfor the call, and expansion continues over the resulting text. Recursive macro\nexpansions are not allowed.\n\n[](){: #User-defined_macros }","ref":"chapter.html#macro-expansion"},{"type":"extras","title":"User-defined macros - Welcome to EDoc","doc":"Users can define their own macros by using the `def` EDoc option; see\n`edoc:file/2` and `edoc:get_doc/2` for more information. User-defined macros\noverride predefined macros.\n\n[](){: #Predefined_macros }","ref":"chapter.html#user-defined-macros"},{"type":"extras","title":"Predefined macros - Welcome to EDoc","doc":"- **`{@date}`** - [](){: #predefmacro-date } Expands to the current date, as\n  \"`Month Day Year`\", e.g. \"Jan 29 2024\".\n\n- **`{@link reference. description}`** - [](){: #predefmacro-link } This creates\n  a hypertext link; cf. the [@see function tag](chapter.md#ftag-see) above for\n  details. The description text (including the period separator) is optional; if\n  no text is given, the reference itself is used. For example,\n  `{@link edoc:file/2}` creates the link `edoc:file/2`, and\n  `{@link edoc:file/2.  this link }` creates [this link](`edoc:file/2`).\n\n- **`{@module}`** - [](){: #predefmacro-module } Expands to the name of the\n  current module. Only defined when a module is being processed.\n\n- **`{@section heading}`** - [](){: #predefmacro-section } Expands to a\n  hypertext link to the specified section heading; see\n  [Headings](chapter.md#headings) for more information.\n\n- **`{@time}`** - [](){: #predefmacro-time } Expands to the current time, as\n  \"`Hr:Min:Sec`\", e.g. \"14:53:19\".\n\n- **`{@type type-expression}`** - [](){: #predefmacro-type } Formats a type\n  expression within ` ... ` markup and with hypertext links for data\n  types. For example, `{@type {options, List::edoc:option_list()@}}` generates\n  \"`{options, List::edoc:option_list()}`\". (Cf.\n  [Escape sequences](chapter.md#Escape_sequences).)\n\n- **`{@version}`** - [](){: #predefmacro-version } Intended for use in\n  [@version tags](chapter.md#mtag-version). Defaults to a timestamp using\n  `{@date}` and `{@time}`. Typically, this macro is redefined by the user when\n  an official release of the application is generated.\n\n[](){: #Escape_sequences }","ref":"chapter.html#predefined-macros"},{"type":"extras","title":"Escape sequences - Welcome to EDoc","doc":"To prevent certain characters from being interpreted as delimiters, for example\nto produce the text \"`{@`\" in the output, or use a '`}`' character in the\nargument text of a macro call, the following escape sequences may be used:\n\n- **`@{`** - Expands to \"`{`\". Example:\n\n  ```text\n     %% @doc A macro call starts with the sequence \"@{@\".\n  ```\n\n- **`@}`** - Expands to \"`}`\". Example:\n\n  ```text\n     %% @doc ...{@foo ...{Key, Value@}...}...\n  ```\n\n- **`@@`** - Expands to \"`@`\". Example:\n\n  ```text\n     %% @doc Contact us at support@@{@hostname}\n  ```\n\n  Will generate the text \"Contact us at support@vaporware.acme.com\" if the macro\n  `hostname` is bound to \"`vaporware.acme.com`\". Also:\n\n  ```text\n     %% @doc You might want to write something like\n     %% @@foo that will expand to @foo and does not start\n     %% a new tag even if it appears first in a line.\n  ```\n\n[](){: #Type_specifications }","ref":"chapter.html#escape-sequences"},{"type":"extras","title":"Type specifications - Welcome to EDoc","doc":"[](){: #Function_specifications }","ref":"chapter.html#type-specifications"},{"type":"extras","title":"Function specifications - Welcome to EDoc","doc":"Note that although the syntax described in the following can still be used for\nspecifying functions we recommend that Erlang specifications (that is the\n`-spec` and `-type` attributes) as described in\n[Types and Function Specification](`e:system:typespec.md`) should be added to\nthe source code instead. This way the analyses of [Dialyzer](`m:dialyzer`)'s can\nbe utilized in the process of keeping the documentation consistent and\nup-to-date.\n\nErlang specifications (`-spec` and `-type`) are required to properly generate\ndoc chunks. Redundant `-spec` attributes and `@spec` tags will cause warnings to\nbe emitted and the specifications to be skipped in chunks. Old-style `@spec` and\n`@type` specifications can still be used to generate static HTML documentation.\n\nThe following grammar describes the form of the specifications following a\n`@spec` tag. A '`?`' suffix implies that the element is optional. Function types\nhave higher precedence than union types; e.g.,\n\"`(atom()) -> atom() | integer()`\" is parsed as\n`((atom()) -> atom()) | integer()`, not as `(atom()) -> (atom() | integer())`.\n\n|                 |     |                                                                         |\n| --------------- | --- | ----------------------------------------------------------------------- |\n| `Spec`          | ::= | `FunType \"where\"? DefList?` \\|                                          |\n|                 |     | `FunctionName FunType \"where\"? DefList?`                                |\n| `FunctionName`  | ::= | `Atom`                                                                  |\n| `FunType`       | ::= | `\"(\" UnionTypes? \")\" \"->\" UnionType`                                    |\n| `UnionTypes`    | ::= | `UnionType` \\| `UnionType \",\" UnionTypes`                               |\n| `UnionType`     | ::= | `UnionList` \\| `Name \"::\" UnionList`                                    |\n| `Name`          | ::= | `Variable`                                                              |\n| `UnionList`     | ::= | `Type` \\| `Type \"+\" UnionList` \\| `Type \"\\|\" UnionList`                 |\n| `Type`          | ::= | `TypeVariable` \\|                                                       |\n|                 |     | `Atom` \\|                                                               |\n|                 |     | `Integer` \\|                                                            |\n|                 |     | `Float` \\|                                                              |\n|                 |     | `Integer \"..\" Integer` \\|                                               |\n|                 |     | `FunType` \\|                                                            |\n|                 |     | `\"fun(\" FunType \")\"` \\|                                                 |\n|                 |     | `\"fun(...)\"` \\|                                                         |\n|                 |     | `\"{\" UnionTypes? \"}\"` \\|                                                |\n|                 |     | `\"#\" Atom \"{\" Fields? \"}\"` \\|                                           |\n|                 |     | `\"[\" \"]\"` \\|                                                            |\n|                 |     | `\"[\" UnionType \"]\"` \\|                                                  |\n|                 |     | `\"[\" UnionType \",\" \"...\" \"]\"` \\|                                        |\n|                 |     | `\"(\" UnionType \")\"` \\|                                                  |\n|                 |     | `BinType` \\|                                                            |\n|                 |     | `TypeName \"(\" UnionTypes? \")\"` \\|                                       |\n|                 |     | `ModuleName \":\" TypeName \"(\" UnionTypes? \")\"` \\|                        |\n|                 |     | `\"//\" AppName \"/\" ModuleName \":\" TypeName \"(\" UnionTypes? \")\"`          |\n| `Fields`        | ::= | `Field` \\| `Fields \",\" Fields`                                          |\n| `Field`         | ::= | `Atom \"=\" UnionList`                                                    |\n| `BinType`       | ::= | `\"<<>>\"` \\|                                                             |\n|                 |     | `\"<<\" BaseType \">>\"` \\|                                                 |\n|                 |     | `\"<<\" UnitType \">>\"` \\|                                                 |\n|                 |     | `\"<<\" BaseType \",\" UnitType \">>\"`                                       |\n| `BaseType`      | ::= | `\"_\" \":\" Integer`                                                       |\n| `UnitType`      | ::= | `\"_\" \":\" \"_\" \"*\" Integer`                                               |\n| `TypeVariable`  | ::= | `Variable`                                                              |\n| `TypeName`      | ::= | `Atom`                                                                  |\n| `ModuleName`    | ::= | `Atom` \\| `ModuleName \".\" Atom`                                         |\n| `AppName`       | ::= | `Atom`                                                                  |\n| `DefList`       | ::= | `Def` \\| `DefList Def` \\| `DefList \",\" Def`                             |\n| `Def`           | ::= | `TypeVariable \"=\" UnionList` \\|                                         |\n|                 |     | `TypeName \"(\" TypeVariables? \")\" \"=\" UnionType`                         |\n| `TypeVariables` | ::= | `TypeVariable` \\|                                                       |\n|                 |     | `TypeVariable \",\" TypeVariables`                                        |\n\n_Table: specification syntax grammar_\n\nExamples:\n\n```text\n    -spec my_function(X :: integer()) -> integer().\n    %% @doc Creates ...\n```\n\n```text\n    %% @spec my_function(X::integer()) -> integer()\n```\n\n```text\n    %% @spec (X::integer()) -> integer()\n```\n\n```text\n    %% @spec sqrt(float()) -> float()\n```\n\n```text\n    %% @spec pair(S, T) -> {S, T}\n```\n\n```text\n    %% @spec append(List, List) -> List\n    %%       List = [term()]\n```\n\n```text\n    %% @spec append(A::List, B::List) -> List\n    %%       List = [Item]\n    %%       Item = term()\n```\n\n```text\n    %% @spec open(File::filename()) -> FileDescriptor\n    %% where\n    %%       filename() = string() + atom(),\n    %%       FileDescriptor = term()\n```\n\n```text\n    %% @spec close(graphics:window()) -> ok\n```\n\nThe first example shows the recommended way of specifying functions.\n\nIn the above examples, `X`, `A`, `B`, and `File` are parameter names, used for\nreferring to the parameters from the documentation text. The _type variables_\n`S`, `T` and `List` are used to simplify the type specifications, and may be\nsupplied with definitions. It is also possible to give definitions for named\ntypes, which means that the name is simply an alias. (Use the `@type` tag to\ndocument abstract data types.) If a named type is defined in another module, it\ncan be referred to as `Module:TypeName(...)`. Note that the keyword '`where`' is\noptional before a list of definitions, and that the definitions in the list may\noptionally be separated by '`,`'.\n\nBoth the '`|`' and the '`+`' character may be used to separate alternatives in\nunion types; there is no semantic difference. Note that the notation `[Type]`\nmeans \"proper (nil-terminated) list whose elements all belong to `Type`\"; For\nexample, `[atom()|integer()]` means the same thing as `[atom()+integer()]`,\ni.e., a proper list of atoms and/or integers.\n\nIf only a type variable is given for a parameter, as in \"`pair(S, T) -> ...`\",\nthe same variable name may implicitly be used as the parameter name; there is no\nneed to write \"`pair(S::S, T::T) -> ...`\".\n\nEDoc automatically extracts possible parameter names from the source code, to be\nused if no parameter name is given in the specification (or if the specification\nis missing altogether). If this fails, EDoc will generate a dummy parameter\nname, such as `X1`. This way, EDoc can often produce helpful documentation even\nfor code that does not contain any annotations at all.\n\n[](){: #Type_definitions }","ref":"chapter.html#function-specifications"},{"type":"extras","title":"Type definitions - Welcome to EDoc","doc":"Note that although the syntax described in the following can still be used for\nspecifying types we recommend that Erlang types as described in\n[Types and Function Specification](`e:system:typespec.md`) should be added to\nthe source code instead.\n\nOld-style `@type` tags will result in just type names, but no definitions, in\ndoc chunks - please use `-type` attributes to ensure all available type\ninformation is available in the chunks. For static HTML, Erlang types will be\nused unless there is a type alias with the same name.\n\nThe following grammar (see above for auxiliary definitions) describes the form\nof the definitions that may follow a `@type` tag:\n\n|           |     |                                                          |\n| --------- | --- | -------------------------------------------------------- |\n| `Typedef` | ::= | `TypeName \"(\" TypeVariables? \")\" DefList?` \\|            |\n|           |     | `TypeName \"(\" TypeVariables? \")\" \"=\" UnionList DefList?` |\n\n\n_Table: type definition grammar_\n\n(For a truly abstract data type, no equivalence is specified.) The main\ndefinition may be followed by additional local definitions. Examples:\n\n```text\n    -type my_list(X) :: [X]. %% A special kind of lists ...\n```\n\n```text\n    -opaque another_list(X) :: [X].\n    %% another_list() is a kind of list...\n```\n\n```text\n    %% @type myList(X). A special kind of lists ...\n```\n\n```text\n    %% @type filename() = string(). Atoms not allowed!\n```\n\n```text\n    %% @type thing(A) = {thong, A}\n    %%           A = term().\n    %%   A kind of wrapper type thingy.\n```\n\nThe first two examples show the recommended way of specifying types.\n\n[](){: #Pre-defined_data_types }","ref":"chapter.html#type-definitions"},{"type":"extras","title":"Pre-defined data types - Welcome to EDoc","doc":"The following data types are predefined by EDoc, and may not be redefined:\n\n```text\n    any()\n    arity()\n    atom()\n    binary()\n    bitstring()\n    bool()        (allowed, but use boolean() instead)\n    boolean()\n    byte()\n    char()\n    cons()\n    deep_string()\n    float()\n    function()\n    integer()\n    iodata()\n    iolist()\n    list()\n    maybe_improper_list()\n    mfa()\n    module()\n    nil()\n    neg_integer()\n    node()\n    non_neg_integer()\n    nonempty_improper_list()\n    nonempty_list()\n    nonempty_maybe_improper_list()\n    nonempty_string()\n    none()\n    number()\n    pid()\n    port()\n    pos_integer()\n    reference()\n    string()\n    term()\n    timeout()\n    tuple()\n```\n\nDetails:\n\n- `t:any/0` means \"any Erlang data type\". `t:term/0` is simply an alias for\n  `t:any/0`.\n- `t:atom/0`, `t:binary/0`, `t:float/0`, `t:function/0`, `t:integer/0`,\n  `t:pid/0`, `t:port/0` and `t:reference/0` are primitive data types of the\n  Erlang programming language.\n- `t:boolean/0` is the subset of `t:atom/0` consisting of the atoms `true` and\n  `false`.\n- `t:char/0` is the subset of `t:integer/0` representing Unicode character\n  codes: hex 000000-10FFFF.\n- `t:tuple/0` is the set of all tuples `{...}`.\n- [`list(T)`](`t:list/1`) is just an alias for `[T]`; list() is an alias for\n  [`list(any())`](`t:list/1`), i.e., `[any()]`.\n- `t:nil/0` is an alias for the empty list `[]`.\n- `cons(H,T)` is the list constructor. This is usually not used directly. It is\n  possible to recursively define `list(T) := nil()+cons(T,list(T))`.\n- `t:string/0` is an alias for `[char()]`.\n- `deep_string()` is recursively defined as `[char()+deep_string()]`.\n- `t:none/0` means \"no data type\". E.g., a function that never returns has type\n  `(...) -> none()`\n\n[](){: #Doc_chunks }","ref":"chapter.html#pre-defined-data-types"},{"type":"extras","title":"Doc chunks - Welcome to EDoc","doc":"EDoc implements\n[EEP-48](https://www.erlang.org/erlang-enhancement-proposals/eep-0048.html) and\nallows to output doc chunks for Erlang projects which use the EDoc language for\nsource code documentation.\n\nThere are two ways to generate the doc chunks: either by using\n[bin/edoc](edoc_cmd.md) or by using the\n[Rebar3 edoc command](http://rebar3.org/docs/commands/#edoc). Ultimately,\nthey're both just entry points to EDoc, the application, so deciding which to\nuse is just a matter of preference.\n\n[](){: #Using_edoc_EScript }","ref":"chapter.html#doc-chunks"},{"type":"extras","title":"Using edoc EScript - Welcome to EDoc","doc":"In order to generate doc chunks using [bin/edoc](edoc_cmd.md), make sure the\ncompiled Erlang app can be found in the Erlang code path:\n\n```text\n$ pwd\n/tmp/recon\n$ rebar3 compile\n$ export PATH=\"$(dirname `which erl`)/../lib/erlang/lib/edoc-0.12/bin:$PATH\"\n$ edoc -app recon -chunks -pa _build/default/lib/recon/ebin\nRunning with opts:\n#{app => recon,\n  code_paths => [\"_build/default/lib/recon/ebin\"],\n  files => [],mode => chunks,run => app}\n$ ls _build/default/lib/recon/doc/chunks/\nrecon.chunk        recon_lib.chunk    recon_rec.chunk\nrecon_alloc.chunk  recon_map.chunk    recon_trace.chunk\n```\n\nThe project does not have to be built with Rebar3 - the above is just an\nexample. From now on the chunks will be available as the source of\n[documentation for the Erlang shell](`m:shell_docs`):\n\n```text\n$ erl -pa _build/default/lib/recon/ebin\n...\n1> h(recon).\n\n   recon\n\n  Recon, as a module, provides access to the high-level functionality contained in the\n  Recon application.\n  ...\n\n2> h(recon_alloc, allocators, 0).\n\n  -spec allocators() -> [allocdata(term())].\n\n  returns a dump of all allocator settings and values\n```\n\n[](){: #Using_Rebar3_edoc_command }","ref":"chapter.html#using-edoc-escript"},{"type":"extras","title":"Using Rebar3 edoc command - Welcome to EDoc","doc":"Doc chunks can also be built using `rebar3 edoc`, given `edoc_opts` is properly\nset up:\n\n```text\n$ pwd\n/tmp/recon\n$ cat >> rebar.config <  {edoc_opts, [{doclet, edoc_doclet_chunks},\n>              {layout, edoc_layout_chunks},\n>              {preprocess, true},\n>              {dir, \"_build/docs/lib/recon/doc\"}]}.\n> EOF\n$ rebar3 edoc\n$ ls _build/docs/lib/recon/doc/chunks/\nrecon.chunk        recon_lib.chunk    recon_rec.chunk\nrecon_alloc.chunk  recon_map.chunk    recon_trace.chunk\n```\n\n`rebar3 shell` will set up the paths for us if we use the `docs` profile:\n\n```text\n$ rebar3 as docs shell\n...\n1> h(recon).\n\n   recon\n\n  Recon, as a module, provides access to the high-level functionality contained in the\n  Recon application.\n  ...\n```\n\n[](){: #Using_the_EDoc_API }","ref":"chapter.html#using-rebar3-edoc-command"},{"type":"extras","title":"Using the EDoc API - Welcome to EDoc","doc":"EDoc comes with two sets of doclet/layout pairs:\n\n- `m:edoc_doclet` and `m:edoc_layout` \\- the default pair which is used to\n  generate static HTML documentation\n- `m:edoc_doclet_chunks` and `m:edoc_layout_chunks` \\- the\n  [EEP-48](https://www.erlang.org/erlang-enhancement-proposals/eep-0048.html)\n  compliant pair which generates doc chunks with\n  [erlang+html(3)](`e:edoc:doc_storage.md`)\n\nIn order to generate doc chunks using `edoc:application/2` or `edoc:files/2` we\nhave to specify which doclet and layout we want to use:\n\n```text\nOpts = [{doclet, edoc_doclet_chunks},\n        {layout, edoc_layout_chunks}].\n```\n\nThen, it's just a matter of deciding whether we want to generate documentation\nfor the whole application (`edoc:application/2`) or only selected source files\n(`edoc:files/2`):\n\n```text\nApp = my_app.\nedoc:application(App, Opts).\n%% or\nFiles = [\"src/my_app_mod1.erl\", \"src/my_app_mod2.erl\"].\nedoc:files(Files, Opts).\n```\n\nSee `src/edoc_cli.erl` source code for an example of using this interface.","ref":"chapter.html#using-the-edoc-api"},{"type":"extras","title":"Acknowledgements - Welcome to EDoc","doc":"Since the first version of EDoc, several people have come up with suggestions\n(Luke Gorrie, Joe Armstrong, Erik Stenman, Sean Hinde, Ulf Wiger, ...), and some\nhave even submitted code to demonstrate their ideas (Vlad Dumitrescu, Johan\nBlom, Vijay Hirani, ...). None of that code was actually included in the Great\nRewriting that followed the initial public release (EDoc version 0.1), but most\nof the central points were addressed in the new system, such as better\nmodularization and possibility to plug in different layout engines, and making\nEDoc understand the application directory layout.\n\nIt is now getting too hard to keep track of all the people who have made further\nsuggestions or submitted bug reports, but your input is always appreciated.\nThank you.","ref":"chapter.html#acknowledgements"},{"type":"extras","title":"EEP-48: Implementation in Erlang/OTP","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2024-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# EEP-48: Implementation in Erlang/OTP","ref":"doc_storage.html"},{"type":"extras","title":"EEP-48: Documentation storage and format - EEP-48: Implementation in Erlang/OTP","doc":"[EEP-48](`e:kernel:eep48_chapter.md`) defines a common documentation storage\nformat for module documentation in the Erlang/OTP ecosystem. Erl_Docgen can\ngenerate documentation in this format from XML files following the DTD's\ndescribed in the other User's Guides in this application.\n\nSome special considerations have to be taken when writing documentation that\nshould also be available through EEP-48 style storage.","ref":"doc_storage.html#eep-48-documentation-storage-and-format"},{"type":"extras","title":"Erlang Documentation Format - EEP-48: Implementation in Erlang/OTP","doc":"When generating documentation for EEP-48 edoc uses the format mime type\n<<\"application/erlang+html\">>. The documentation content is an Erlang term that\nrepresents an HTML like structure.\n\n```text\n-type chunk_elements() :: [chunk_element()].\n-type chunk_element() :: {chunk_element_type(),chunk_element_attrs(),\n                          chunk_elements()} | unicode:unicode_binary().\n-type chunk_element_attrs() :: [chunk_element_attr()].\n-type chunk_element_attr() :: {atom(),unicode:unicode_binary()}.\n-type chunk_element_type() :: chunk_element_inline_type() | chunk_element_block_type().\n-type chunk_element_inline_type() :: a | code | strong | b | em | i.\n-type chunk_element_block_type() :: p | 'div' | br | pre | ul |\n                                    ol | li | dl | dt | dd |\n                                    h1 | h2 | h3 | h4 | h5 | h6.\n```\n\nThe different element types follow their HTML meaning when rendered. The\nfollowing are some general rules for how the chunk elements are allowed to be\ngenerated.\n\n- Inline and `pre` elements are not allowed to contain block elements.\n- `p` elements are not allowed to be nested.\n\nThe attributes on some elements have a special meaning.\n\n- **`{'div',[{class,unicode:unicode_binary()}],_}`** - The class name will be\n  used to provide styling to the content in the div. The types of classes used\n  by Erlang/OTP are: `warning`, `note`, `do`, `dont` and `quote`.\n\n- **`{ul,[{class,<<\"types\">>}],_}`** - This is a list containing type\n  documentation.\n\n- **`{li,[{name,TypeName :: unicode:unicode_binary()}],_}`** - A list item with\n  a type specification located in the metadata of this modules EEP-48\n  documentation. The implementation should look for the AST representation of\n  the type under the `types` key. This attribute is only valid under a `ul` with\n  class <<\"types\">>.\n\n- **`{li,[{class,<<\"type\">>}],_}`** - A list item with the type described in the\n  Erlang Documentation Format. This attribute is only valid under a `ul` with\n  class <<\"types\">>.\n\n- **`{li,[{class,<<\"description\">>}],_}`** - A list item with the description of\n  the type previous in the list. This attribute is only valid under a `ul` with\n  class <<\"types\">>.\n\nThe `shell_docs:validate/1` function can be used to do a validation of the\nErlang Documentation Format.","ref":"doc_storage.html#erlang-documentation-format"},{"type":"extras","title":"Erlang Documentation extra Metadata - EEP-48: Implementation in Erlang/OTP","doc":"Erlang/OTP uses some extra metadata fields to embed more information into the\nEEP-48 docs.\n\n- Fields on module level:\n\n  - **`otp_doc_vsn := {non_neg_integer(),non_neg_integer(),non_neg_integer()}`** -\n    Describes the version of the Erlang Documentation Format used within this\n    module\n\n  - **`types := #{ TypeName :: unicode:unicode_binary() => TypeAST }`** - A map\n    containing the AST of the types that are part of this module. This map is\n    used to by functions and callbacks to render the types inline into their\n    documentation.\n\n- Fields on functions and types:\n\n  - **`signature := SpecAST`** - The spec AST associated with this function. It\n    is used to render a more descriptive slogan for the documentation entry.\n\n  - **`equiv := {Type,Name,Arity}`** - The current function/type shares\n    documentation with another function/type. This means that if this and the\n    target function/type are to be shown at the same time only the prototype of\n    this function/type should will be displayed and the documentation will use a\n    common body of text.","ref":"doc_storage.html#erlang-documentation-extra-metadata"},{"type":"extras","title":"See Also - EEP-48: Implementation in Erlang/OTP","doc":"`m:shell_docs`, `code:get_doc/1`","ref":"doc_storage.html#see-also"},{"type":"extras","title":"edoc","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# edoc\n\nGenerate documentation as HTML or EEP-48 doc chunks.","ref":"edoc_cmd.html"},{"type":"extras","title":"Description - edoc","doc":"This program is a command line entry point to both `edoc:application/2` and\n`edoc:files/2` functions. It also allows to generate just the EEP-48 doc chunks\n(using the `-chunks` flag) instead of the complete HTML documentation.","ref":"edoc_cmd.html#description"},{"type":"extras","title":"edoc -app <app> [-chunks] - edoc","doc":"EDoc is invoked via `edoc:application/2`, with the default set of options. If\n`-chunks` is given, then only doc chunks will be generated, not the full HTML\ndocumentation.\n\nRun the script with no arguments to get the full list of options.","ref":"edoc_cmd.html#edoc-app-app-chunks"},{"type":"extras","title":"edoc -files <erl_file>... [-chunks] - edoc","doc":"EDoc is invoked via `edoc:files/2`, with the default set of options. If\n`-chunks` is given, then only doc chunks will be generated, not the full HTML\ndocumentation.\n\nRun the script with no arguments to get the full list of options.","ref":"edoc_cmd.html#edoc-files-erl_file-chunks"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}